/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.msd.model.core.IIon;

public class IonAbundanceComparator
implements Comparator<IIon>,
Serializable {
    private static final long serialVersionUID = -654515618249449848L;
    private SortOrder sortOrder;

    public IonAbundanceComparator() {
        this.sortOrder = SortOrder.ASC;
    }

    public IonAbundanceComparator(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    @Override
    public int compare(IIon ion1, IIon ion2) {
        int returnValue;
        switch (this.sortOrder) {
            case ASC: {
                returnValue = Float.compare(ion1.getAbundance(), ion2.getAbundance());
                break;
            }
            case DESC: {
                returnValue = Float.compare(ion2.getAbundance(), ion1.getAbundance());
                break;
            }
            default: {
                returnValue = Float.compare(ion1.getAbundance(), ion2.getAbundance());
            }
        }
        return returnValue;
    }
}

