/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.targets.IPeakTarget;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.IMassSpectrumTarget;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.swt.ui.converter.SeriesConverterMSD;
import org.eclipse.chemclipse.swt.ui.components.chromatogram.AbstractViewChromatogramUI;
import org.eclipse.chemclipse.swt.ui.converter.SeriesConverter;
import org.eclipse.chemclipse.swt.ui.exceptions.NoIdentifiedScansAvailableException;
import org.eclipse.chemclipse.swt.ui.exceptions.NoPeaksAvailableException;
import org.eclipse.chemclipse.swt.ui.series.IMultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.AxisTitlesMassScale;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.chemclipse.swt.ui.support.IOffset;
import org.eclipse.chemclipse.swt.ui.support.Offset;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.swtchart.ICustomPaintListener;
import org.swtchart.ILineSeries;
import org.swtchart.IPlotArea;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;

public class LabeledPeakChromatogramUI
extends AbstractViewChromatogramUI {
    private ILineSeries activePeaksSeries;
    private List<String> activePeakLabels;
    private ILineSeries inactivePeaksSeries;
    private List<String> inactivePeakLabels;
    private ILineSeries identifiedScanSeries;
    private List<String> identifiedScanLabels;
    private IOffset offset = new Offset(0.0, 0.0);
    private TargetExtendedComparator targetComparator = new TargetExtendedComparator(SortOrder.DESC);
    private Transform transform = new Transform((Device)Display.getCurrent());

    public LabeledPeakChromatogramUI(Composite parent, int style) {
        super(parent, style, (IAxisTitles)new AxisTitlesMassScale());
        this.transform.rotate(-90.0f);
    }

    public void setViewSeries() {
        IChromatogramSelection chromatogramSelection = this.getChromatogramSelection();
        if (chromatogramSelection != null) {
            List peaks = null;
            IMassSpectra massSpectra = null;
            if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
                IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)chromatogramSelection;
                peaks = chromatogramSelectionMSD.getChromatogramMSD().getPeaks(chromatogramSelectionMSD);
                massSpectra = SeriesConverterMSD.getIdentifiedScans((IChromatogramSelectionMSD)chromatogramSelectionMSD, (boolean)false);
            } else if (chromatogramSelection instanceof IChromatogramSelectionCSD) {
                IChromatogramSelectionCSD chromatogramSelectionCSD = (IChromatogramSelectionCSD)chromatogramSelection;
                peaks = chromatogramSelectionCSD.getChromatogramCSD().getPeaks(chromatogramSelectionCSD);
            }
            ISeries seriesChromatogram = SeriesConverter.convertChromatogram((IChromatogramSelection)chromatogramSelection, (Sign)Sign.POSITIVE, (boolean)true);
            this.addSeries(seriesChromatogram);
            ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, seriesChromatogram.getId());
            lineSeries.setXSeries(seriesChromatogram.getXSeries());
            lineSeries.setYSeries(seriesChromatogram.getYSeries());
            lineSeries.enableArea(true);
            lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            lineSeries.setLineColor(Colors.RED);
            if (peaks != null) {
                ISeries seriesPeak;
                IMultipleSeries multipleSeries;
                boolean activeForAnalysis;
                try {
                    activeForAnalysis = true;
                    this.activePeakLabels = this.extractLabels(peaks, activeForAnalysis);
                    multipleSeries = SeriesConverter.convertPeakMaxMarker((List)peaks, (Sign)Sign.POSITIVE, (IOffset)this.offset, (boolean)activeForAnalysis);
                    seriesPeak = (ISeries)multipleSeries.getMultipleSeries().get(0);
                    this.activePeaksSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, seriesPeak.getId());
                    this.activePeaksSeries.setXSeries(seriesPeak.getXSeries());
                    this.activePeaksSeries.setYSeries(seriesPeak.getYSeries());
                    this.activePeaksSeries.setLineStyle(LineStyle.NONE);
                    this.activePeaksSeries.setSymbolType(ILineSeries.PlotSymbolType.INVERTED_TRIANGLE);
                    this.activePeaksSeries.setSymbolSize(5);
                    this.activePeaksSeries.setLineColor(Colors.GRAY);
                    this.activePeaksSeries.setSymbolColor(Colors.DARK_GRAY);
                }
                catch (NoPeaksAvailableException noPeaksAvailableException) {}
                try {
                    activeForAnalysis = false;
                    this.inactivePeakLabels = this.extractLabels(peaks, activeForAnalysis);
                    multipleSeries = SeriesConverter.convertPeakMaxMarker((List)peaks, (Sign)Sign.POSITIVE, (IOffset)this.offset, (boolean)activeForAnalysis);
                    seriesPeak = (ISeries)multipleSeries.getMultipleSeries().get(0);
                    this.inactivePeaksSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, seriesPeak.getId());
                    this.inactivePeaksSeries.setXSeries(seriesPeak.getXSeries());
                    this.inactivePeaksSeries.setYSeries(seriesPeak.getYSeries());
                    this.inactivePeaksSeries.setLineStyle(LineStyle.NONE);
                    this.inactivePeaksSeries.setSymbolType(ILineSeries.PlotSymbolType.INVERTED_TRIANGLE);
                    this.inactivePeaksSeries.setSymbolSize(5);
                    this.inactivePeaksSeries.setLineColor(Colors.GRAY);
                    this.inactivePeaksSeries.setSymbolColor(Colors.GRAY);
                }
                catch (NoPeaksAvailableException noPeaksAvailableException) {}
            }
            if (massSpectra != null) {
                try {
                    this.identifiedScanLabels = this.extractLabels(massSpectra);
                    IMultipleSeries multipleSeries = SeriesConverterMSD.convertIdentifiedScans((IMassSpectra)massSpectra, (Sign)Sign.POSITIVE, (IOffset)this.offset);
                    ISeries seriesScans = (ISeries)multipleSeries.getMultipleSeries().get(0);
                    this.identifiedScanSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, seriesScans.getId());
                    this.identifiedScanSeries.setXSeries(seriesScans.getXSeries());
                    this.identifiedScanSeries.setYSeries(seriesScans.getYSeries());
                    this.identifiedScanSeries.setLineStyle(LineStyle.NONE);
                    this.identifiedScanSeries.setSymbolType(ILineSeries.PlotSymbolType.CIRCLE);
                    this.identifiedScanSeries.setSymbolSize(3);
                    this.identifiedScanSeries.setLineColor(Colors.GRAY);
                    this.identifiedScanSeries.setSymbolColor(Colors.DARK_GRAY);
                }
                catch (NoIdentifiedScansAvailableException noIdentifiedScansAvailableException) {}
            }
        }
    }

    protected void initialize() {
        super.initialize();
        IPlotArea plotArea = (IPlotArea)this.getPlotArea();
        plotArea.addCustomPaintListener(new ICustomPaintListener(){

            public void paintControl(PaintEvent e) {
                LabeledPeakChromatogramUI.this.paintIdentificationLabels(e);
            }

            public boolean drawBehindSeries() {
                return true;
            }
        });
    }

    private List<String> extractLabels(List<? extends IPeak> peaks, boolean activeForAnalysis) {
        ArrayList<String> labels = new ArrayList<String>();
        if (peaks != null) {
            for (IPeak iPeak : peaks) {
                if (iPeak == null || iPeak.isActiveForAnalysis() != activeForAnalysis) continue;
                List peakTargets = iPeak.getTargets();
                if (peakTargets.size() == 0) {
                    labels.add("");
                    continue;
                }
                Collections.sort(peakTargets, this.targetComparator);
                IPeakTarget peakTarget = (IPeakTarget)peakTargets.get(0);
                String name = peakTarget.getLibraryInformation().getName();
                labels.add(name);
            }
        }
        return labels;
    }

    private List<String> extractLabels(IMassSpectra massSpectra) {
        ArrayList<String> labels = new ArrayList<String>();
        if (massSpectra != null) {
            for (IScanMSD scanMSD : massSpectra.getList()) {
                if (scanMSD == null) continue;
                List massSpectrumTargets = scanMSD.getTargets();
                if (massSpectrumTargets.size() == 0) {
                    labels.add("");
                    continue;
                }
                Collections.sort(massSpectrumTargets, this.targetComparator);
                IMassSpectrumTarget massSpectrumTarget = (IMassSpectrumTarget)massSpectrumTargets.get(0);
                String name = massSpectrumTarget.getLibraryInformation().getName();
                labels.add(name);
            }
        }
        return labels;
    }

    private void paintIdentificationLabels(PaintEvent e) {
        if (this.activePeakLabels != null && this.activePeaksSeries != null) {
            this.printLabels(this.activePeakLabels, this.activePeaksSeries, e);
        }
        if (this.inactivePeakLabels != null && this.inactivePeaksSeries != null) {
            this.printLabels(this.inactivePeakLabels, this.inactivePeaksSeries, e);
        }
        if (this.identifiedScanLabels != null && this.identifiedScanSeries != null) {
            this.printLabels(this.identifiedScanLabels, this.identifiedScanSeries, e);
        }
    }

    private void printLabels(List<String> labels, ILineSeries lineSeries, PaintEvent e) {
        int i = 0;
        while (i < labels.size()) {
            String label = labels.get(i);
            Point point = lineSeries.getPixelCoordinates(i);
            Point labelSize = e.gc.textExtent(label);
            int x = -labelSize.x - (point.y - labelSize.x - 15);
            int y = point.x - labelSize.y / 2;
            GC gc = e.gc;
            gc.setTransform(this.transform);
            gc.drawText(label, x, y, true);
            gc.setTransform(null);
            ++i;
        }
    }
}

