/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.lu;

import org.ejml.alg.dense.decomposition.lu.LUDecompositionBase_D64;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_D64;
import org.ejml.data.DenseMatrix64F;

public abstract class LinearSolverLuBase_D64
extends LinearSolverAbstract_D64 {
    protected LUDecompositionBase_D64 decomp;

    public LinearSolverLuBase_D64(LUDecompositionBase_D64 decomp) {
        this.decomp = decomp;
    }

    @Override
    public boolean setA(DenseMatrix64F A) {
        this._setA(A);
        return this.decomp.decompose(A);
    }

    @Override
    public double quality() {
        return this.decomp.quality();
    }

    @Override
    public void invert(DenseMatrix64F A_inv) {
        double[] vv = this.decomp._getVV();
        DenseMatrix64F LU = this.decomp.getLU();
        if (A_inv.numCols != LU.numCols || A_inv.numRows != LU.numRows) {
            throw new IllegalArgumentException("Unexpected matrix dimension");
        }
        int n = this.A.numCols;
        double[] dataInv = A_inv.data;
        int j = 0;
        while (j < n) {
            int i = 0;
            while (i < n) {
                vv[i] = i == j ? 1 : 0;
                ++i;
            }
            this.decomp._solveVectorInternal(vv);
            int index = j;
            int i2 = 0;
            while (i2 < n) {
                dataInv[index] = vv[i2];
                ++i2;
                index += n;
            }
            ++j;
        }
    }

    public void improveSol(DenseMatrix64F b, DenseMatrix64F x) {
        if (b.numCols != x.numCols) {
            throw new IllegalArgumentException("bad shapes");
        }
        double[] dataA = this.A.data;
        double[] dataB = b.data;
        double[] dataX = x.data;
        int nc = b.numCols;
        int n = b.numCols;
        double[] vv = this.decomp._getVV();
        int k = 0;
        while (k < nc) {
            int i = 0;
            while (i < n) {
                double sdp = -dataB[i * nc + k];
                int j = 0;
                while (j < n) {
                    sdp += dataA[i * n + j] * dataX[j * nc + k];
                    ++j;
                }
                vv[i] = sdp;
                ++i;
            }
            this.decomp._solveVectorInternal(vv);
            i = 0;
            while (i < n) {
                int n2 = i * nc + k;
                dataX[n2] = dataX[n2] - vv[i];
                ++i;
            }
            ++k;
        }
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public LUDecompositionBase_D64 getDecomposition() {
        return this.decomp;
    }
}

