/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.internal.editingsupport;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class LibraryTextEditingSupport
extends EditingSupport {
    private TextCellEditor cellEditor;
    private TableViewer tableViewer;
    private String columnLabel;
    private DecimalFormat decimalFormat;

    public LibraryTextEditingSupport(TableViewer tableViewer, String columnLabel) {
        super((ColumnViewer)tableViewer);
        this.tableViewer = tableViewer;
        this.columnLabel = columnLabel;
        this.decimalFormat = ValueFormat.getDecimalFormatEnglish();
        this.cellEditor = new TextCellEditor((Composite)tableViewer.getTable());
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        String object;
        block31: {
            object = null;
            if (!(element instanceof IRegularLibraryMassSpectrum)) break block31;
            IRegularLibraryMassSpectrum libraryMassSpectrum = (IRegularLibraryMassSpectrum)element;
            ILibraryInformation libraryInformation = libraryMassSpectrum.getLibraryInformation();
            switch (this.columnLabel) {
                case "Name": {
                    object = libraryInformation.getName();
                    break;
                }
                case "Retention Time": {
                    object = this.decimalFormat.format((double)libraryMassSpectrum.getRetentionTime() / 60000.0);
                    break;
                }
                case "Retention Index": {
                    object = this.decimalFormat.format(libraryMassSpectrum.getRetentionIndex());
                    break;
                }
                case "CAS": {
                    object = libraryInformation.getCasNumber();
                    break;
                }
                case "Formula": {
                    object = libraryInformation.getFormula();
                    break;
                }
                case "SMILES": {
                    object = libraryInformation.getSmiles();
                    break;
                }
                case "InChI": {
                    object = libraryInformation.getInChI();
                    break;
                }
                case "Reference Identifier": {
                    object = libraryInformation.getReferenceIdentifier();
                    break;
                }
                case "Comments": {
                    object = libraryInformation.getComments();
                }
            }
        }
        return object;
    }

    protected void setValue(Object element, Object value) {
        block31: {
            if (!(element instanceof IRegularLibraryMassSpectrum)) break block31;
            IRegularLibraryMassSpectrum libraryMassSpectrum = (IRegularLibraryMassSpectrum)element;
            ILibraryInformation libraryInformation = libraryMassSpectrum.getLibraryInformation();
            switch (this.columnLabel) {
                case "Name": {
                    libraryInformation.setName(value.toString());
                    break;
                }
                case "Retention Time": {
                    libraryMassSpectrum.setRetentionTime((int)(Double.parseDouble(value.toString()) * 60000.0));
                    break;
                }
                case "Retention Index": {
                    libraryMassSpectrum.setRetentionIndex(Float.parseFloat(value.toString()));
                    break;
                }
                case "CAS": {
                    libraryInformation.setCasNumber(value.toString());
                    break;
                }
                case "Formula": {
                    libraryInformation.setFormula(value.toString());
                    break;
                }
                case "SMILES": {
                    libraryInformation.setSmiles(value.toString());
                    break;
                }
                case "InChI": {
                    libraryInformation.setInChI(value.toString());
                    break;
                }
                case "Reference Identifier": {
                    libraryInformation.setReferenceIdentifier(value.toString());
                    break;
                }
                case "Comments": {
                    libraryInformation.setComments(value.toString());
                }
            }
            this.tableViewer.refresh();
        }
    }
}

