/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.SimpleMirroredMassSpectrumUI;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LibraryMassSpectrumComparisonUI
extends Composite {
    private static final Logger logger = Logger.getLogger(LibraryMassSpectrumComparisonUI.class);
    private Label infoLabelUnknown;
    private SimpleMirroredMassSpectrumUI mirroredMassSpectrumUI;
    private Label infoLabelLibrary;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0####");
    private MassValueDisplayPrecision massValueDisplayPrecision;

    public LibraryMassSpectrumComparisonUI(Composite parent, int style, MassValueDisplayPrecision massValueDisplayPrecision) {
        super(parent, style);
        this.massValueDisplayPrecision = massValueDisplayPrecision;
        this.initialize(parent);
    }

    private void initialize(Composite parent) {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.infoLabelUnknown = new Label(composite, 0);
        this.infoLabelUnknown.setText("");
        this.infoLabelUnknown.setLayoutData((Object)new GridData(768));
        this.mirroredMassSpectrumUI = new SimpleMirroredMassSpectrumUI(composite, 2052, this.massValueDisplayPrecision);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.mirroredMassSpectrumUI.setLayoutData(gridData);
        this.infoLabelLibrary = new Label(composite, 0);
        this.infoLabelLibrary.setText("");
        this.infoLabelLibrary.setLayoutData((Object)new GridData(768));
    }

    public void update(IScanMSD unknownMassSpectrum, IScanMSD libraryMassSpectrum, boolean forceReload) {
        if (unknownMassSpectrum != null && libraryMassSpectrum != null) {
            try {
                IScanMSD unknownMassSpectrumCopy = unknownMassSpectrum.makeDeepCopy().normalize(1000.0f);
                IScanMSD libraryMassSpectrumCopy = libraryMassSpectrum.makeDeepCopy().normalize(1000.0f);
                this.setMassSpectrumLabel(unknownMassSpectrumCopy, libraryMassSpectrumCopy);
                this.mirroredMassSpectrumUI.update(unknownMassSpectrumCopy, libraryMassSpectrumCopy, forceReload);
            }
            catch (CloneNotSupportedException e) {
                logger.warn((Object)e);
            }
        } else {
            this.mirroredMassSpectrumUI.update(null, null, true);
        }
    }

    private void setMassSpectrumLabel(IScanMSD unknownMassSpectrum, IScanMSD libraryMassSpectrum) {
        this.setMassSpectrumLabel(unknownMassSpectrum, "UNKNOWN MS = ", this.infoLabelUnknown);
        this.setMassSpectrumLabel(libraryMassSpectrum, "LIBRARY MS = ", this.infoLabelLibrary);
    }

    private void setMassSpectrumLabel(IScanMSD massSpectrum, String title, Label label) {
        StringBuilder builder = new StringBuilder();
        builder.append(title);
        if (massSpectrum instanceof IRegularLibraryMassSpectrum) {
            IRegularLibraryMassSpectrum libraryMassSpectrum = (IRegularLibraryMassSpectrum)massSpectrum;
            ILibraryInformation libraryInformation = libraryMassSpectrum.getLibraryInformation();
            builder.append("NAME: ");
            builder.append(libraryInformation.getName());
            builder.append(" | ");
            builder.append("CAS: ");
            builder.append(libraryInformation.getCasNumber());
            builder.append(" | ");
        }
        builder.append("RT: ");
        builder.append(this.decimalFormat.format((double)massSpectrum.getRetentionTime() / 60000.0));
        builder.append(" | ");
        builder.append("RI: ");
        if (PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
            builder.append(Integer.toString((int)massSpectrum.getRetentionIndex()));
        } else {
            builder.append(this.decimalFormat.format(massSpectrum.getRetentionIndex()));
        }
        label.setText(builder.toString());
    }
}

