/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.chromatogram;

import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.chromatogram.AbstractViewMSDChromatogramUI;
import org.eclipse.chemclipse.swt.ui.converter.SeriesConverter;
import org.eclipse.chemclipse.swt.ui.series.IMultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

public class DerivativeChromatogramUI
extends AbstractViewMSDChromatogramUI {
    private int derivative;
    private int scale;

    public DerivativeChromatogramUI(Composite parent, int derivative, int scale, int style) {
        super(parent, style);
        this.derivative = derivative;
        this.scale = scale;
    }

    public void setViewSeries() {
        IChromatogramSelection storedChromatogramSelection = this.getChromatogramSelection();
        if (storedChromatogramSelection instanceof IChromatogramSelectionMSD) {
            IChromatogramSelectionMSD chromatogramSelection = (IChromatogramSelectionMSD)storedChromatogramSelection;
            IMultipleSeries multipleSeries = SeriesConverter.convertDerivativeChromatogram((IChromatogramSelection)chromatogramSelection, (int)this.derivative, (int)this.scale, (boolean)true);
            ISeries series = (ISeries)multipleSeries.getMultipleSeries().get(0);
            this.setAdditionalIonSeries(series, Colors.BLACK);
            series = (ISeries)multipleSeries.getMultipleSeries().get(1);
            this.setAdditionalIonSeries(series, Colors.RED);
        }
    }

    private void setAdditionalIonSeries(ISeries series, Color color) {
        this.addSeries(series);
        ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(true);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(color);
    }
}

