/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClassHelper;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.cache.ResultSetUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class ResultClass
implements IResultClass {
    private ResultFieldMetadata[] projectedCols;
    private int m_fieldCount;
    private HashMap nameToIdMapping;
    private String[] fieldNames;
    private int[] fieldDriverPositions;
    private ResultClassHelper resultClassHelper;
    private boolean hasAny;
    private List originalAnyTypeField;
    private int version;

    public ResultClass(List projectedColumns) throws DataException {
        assert (projectedColumns != null);
        this.initColumnsInfo(projectedColumns);
    }

    private void validateProjectColumns(ResultFieldMetadata[] projectedColumns) throws DataException {
        HashSet<String> columnNameSet = new HashSet<String>();
        int i = 0;
        while (i < projectedColumns.length) {
            ResultFieldMetadata column = projectedColumns[i];
            if (columnNameSet.contains(column.getName())) {
                throw new DataException("data.engine.DupColumnName", column.getName());
            }
            if (columnNameSet.contains(column.getAlias())) {
                throw new DataException("data.engine.DupColumnName", column.getAlias());
            }
            columnNameSet.add(column.getName());
            if (column.getAlias() != null) {
                columnNameSet.add(column.getAlias());
            }
            ++i;
        }
    }

    private void initColumnsInfo(List projectedColumns) {
        this.m_fieldCount = projectedColumns.size();
        this.projectedCols = new ResultFieldMetadata[this.m_fieldCount];
        this.nameToIdMapping = new HashMap();
        this.originalAnyTypeField = new ArrayList();
        int i = 0;
        int n = projectedColumns.size();
        while (i < n) {
            String upperCaseAlias;
            this.projectedCols[i] = (ResultFieldMetadata)projectedColumns.get(i);
            ResultFieldMetadata column = this.projectedCols[i];
            if (this.isOfAnyType(column)) {
                this.hasAny = true;
                this.originalAnyTypeField.add(i + 1);
            }
            String upperCaseName = column.getName();
            Integer index = i + 1;
            if (!this.nameToIdMapping.containsKey(upperCaseName)) {
                this.nameToIdMapping.put(upperCaseName, index);
            }
            if ((upperCaseAlias = column.getAlias()) != null && upperCaseAlias.length() > 0 && !this.nameToIdMapping.containsKey(upperCaseAlias)) {
                this.nameToIdMapping.put(upperCaseAlias, index);
            }
            ++i;
        }
        i = 0;
        while (i < this.projectedCols.length) {
            String JDBCAlias = this.projectedCols[i].getLabel();
            if (!this.nameToIdMapping.containsKey(JDBCAlias)) {
                this.nameToIdMapping.put(JDBCAlias, i + 1);
            }
            ++i;
        }
    }

    private boolean isOfAnyType(ResultFieldMetadata column) {
        return column.getDataType().getName().equals(DataType.AnyType.class.getName());
    }

    public ResultClass(InputStream inputStream, int version, boolean includeInnerID) throws DataException {
        assert (inputStream != null);
        this.version = version;
        DataInputStream dis = new DataInputStream(inputStream);
        try {
            ArrayList<ResultFieldMetadata> newProjectedColumns = new ArrayList<ResultFieldMetadata>();
            int size = IOUtil.readInt((InputStream)dis);
            int i = 0;
            while (i < size) {
                int driverPos = IOUtil.readInt((InputStream)dis);
                String name = IOUtil.readString((DataInputStream)dis);
                String lable = IOUtil.readString((DataInputStream)dis);
                String alias = IOUtil.readString((DataInputStream)dis);
                String dtName = IOUtil.readString((DataInputStream)dis);
                String ntName = IOUtil.readString((DataInputStream)dis);
                boolean bool = IOUtil.readBool((InputStream)dis);
                String dpdpName = IOUtil.readString((DataInputStream)dis);
                int analysistype = -1;
                String analysisColumn = null;
                boolean indexColumn = false;
                boolean isCompressedColumn = false;
                if (version >= 130) {
                    analysistype = IOUtil.readInt((InputStream)dis);
                    analysisColumn = IOUtil.readString((DataInputStream)dis);
                    indexColumn = IOUtil.readBool((InputStream)dis);
                    isCompressedColumn = IOUtil.readBool((InputStream)dis);
                }
                ResultFieldMetadata metaData = new ResultFieldMetadata(driverPos, name, lable, Class.forName(dtName), ntName, bool, analysistype, analysisColumn, indexColumn, isCompressedColumn);
                metaData.setAnalysisType(analysistype);
                metaData.setAlias(alias);
                if (dpdpName != null) {
                    metaData.setDriverProvidedDataType(Class.forName(dpdpName));
                }
                newProjectedColumns.add(metaData);
                ++i;
            }
            dis.close();
            if (includeInnerID) {
                ResultFieldMetadata rfm = new ResultFieldMetadata(0, "_$$_dte_inner_row_id_$$_", null, Integer.class, null, true, -1);
                newProjectedColumns.add(rfm);
            }
            this.initColumnsInfo(newProjectedColumns);
        }
        catch (ClassNotFoundException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Class");
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Class");
        }
    }

    public ResultClass(InputStream inputStream, int version) throws DataException {
        this(inputStream, version, false);
    }

    public void doSave(OutputStream outputStream, List<IBinding> requestColumnMap, int version) throws DataException {
        assert (outputStream != null);
        DataOutputStream dos = new DataOutputStream(outputStream);
        Set requestNameSet = requestColumnMap == null ? null : ResultSetUtil.getRsColumnRequestMap(requestColumnMap);
        HashSet<String> resultSetNameSet = null;
        if (requestNameSet != null) {
            String columnName;
            resultSetNameSet = new HashSet<String>();
            int i = 0;
            while (i < this.projectedCols.length) {
                columnName = this.projectedCols[i].getName();
                String columnAlias = this.projectedCols[i].getAlias();
                if (requestNameSet.remove(columnName) | requestNameSet.remove(columnAlias)) {
                    resultSetNameSet.add(columnName);
                }
                ++i;
            }
            i = 0;
            while (i < this.projectedCols.length) {
                columnName = this.projectedCols[i].getName();
                String columnLabel = this.projectedCols[i].getLabel();
                if (requestNameSet.remove(columnLabel)) {
                    resultSetNameSet.add(columnName);
                }
                ++i;
            }
        }
        int size = resultSetNameSet == null ? this.projectedCols.length : resultSetNameSet.size();
        try {
            IOUtil.writeInt((OutputStream)outputStream, (int)size);
            int writeCount = 0;
            int i = 0;
            while (i < this.m_fieldCount) {
                ResultFieldMetadata column = this.projectedCols[i];
                if (resultSetNameSet == null || resultSetNameSet.remove(column.getName())) {
                    IOUtil.writeInt((OutputStream)dos, (int)column.getDriverPosition());
                    IOUtil.writeString((DataOutputStream)dos, (String)column.getName());
                    IOUtil.writeString((DataOutputStream)dos, (String)column.getLabel());
                    IOUtil.writeString((DataOutputStream)dos, (String)column.getAlias());
                    IOUtil.writeString((DataOutputStream)dos, (String)column.getDataType().getName());
                    IOUtil.writeString((DataOutputStream)dos, (String)column.getNativeTypeName());
                    IOUtil.writeBool((OutputStream)dos, (boolean)column.isCustom());
                    if (column.getDriverProvidedDataType() == null) {
                        IOUtil.writeString((DataOutputStream)dos, null);
                    } else {
                        IOUtil.writeString((DataOutputStream)dos, (String)column.getDriverProvidedDataType().getName());
                    }
                    if (version >= 130) {
                        IOUtil.writeInt((OutputStream)dos, (int)column.getAnalysisType());
                        IOUtil.writeString((DataOutputStream)dos, (String)column.getAnalysisColumn());
                        IOUtil.writeBool((OutputStream)dos, (boolean)column.isIndexColumn());
                        IOUtil.writeBool((OutputStream)dos, (boolean)column.isCompressedColumn());
                    }
                    ++writeCount;
                }
                ++i;
            }
            if (writeCount != size) {
                this.validateProjectColumns(this.projectedCols);
                StringBuffer buf = new StringBuffer();
                for (String colName : resultSetNameSet) {
                    buf.append(colName);
                    buf.append(',');
                }
                buf.deleteCharAt(buf.length() - 1);
                throw new DataException("data.engine.resultClassSaveError", buf.toString());
            }
            dos.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Class");
        }
    }

    @Override
    public int getFieldCount() {
        return this.m_fieldCount;
    }

    @Override
    public String[] getFieldNames() {
        return this.doGetFieldNames();
    }

    private String[] doGetFieldNames() {
        if (this.fieldNames == null) {
            int size = this.m_fieldCount;
            this.fieldNames = new String[size];
            int i = 0;
            while (i < size) {
                this.fieldNames[i] = this.projectedCols[i].getName();
                ++i;
            }
        }
        return this.fieldNames;
    }

    public int[] getFieldDriverPositions() {
        if (this.fieldDriverPositions == null) {
            int size = this.m_fieldCount;
            this.fieldDriverPositions = new int[size];
            int i = 0;
            while (i < size) {
                ResultFieldMetadata column = this.projectedCols[i];
                this.fieldDriverPositions[i] = column.getDriverPosition();
                ++i;
            }
        }
        return this.fieldDriverPositions;
    }

    @Override
    public String getFieldName(int index) throws DataException {
        return this.projectedCols[index - 1].getName();
    }

    @Override
    public String getFieldAlias(int index) throws DataException {
        return this.projectedCols[index - 1].getAlias();
    }

    @Override
    public int getFieldIndex(String fieldName) {
        Integer i = (Integer)this.nameToIdMapping.get(fieldName);
        return i == null ? -1 : i;
    }

    private int doGetFieldIndex(String fieldName) throws DataException {
        int index = this.getFieldIndex(fieldName);
        if (index <= 0) {
            throw new DataException("data.engine.InvalidFieldName", fieldName);
        }
        return index;
    }

    @Override
    public Class getFieldValueClass(String fieldName) throws DataException {
        int index = this.doGetFieldIndex(fieldName);
        return this.getFieldValueClass(index);
    }

    @Override
    public Class getFieldValueClass(int index) throws DataException {
        return this.projectedCols[index - 1].getDataType();
    }

    @Override
    public boolean isCustomField(String fieldName) throws DataException {
        int index = this.doGetFieldIndex(fieldName);
        return this.isCustomField(index);
    }

    @Override
    public boolean isCustomField(int index) throws DataException {
        return this.projectedCols[index - 1].isCustom();
    }

    @Override
    public String getFieldLabel(int index) throws DataException {
        return this.projectedCols[index - 1].getLabel();
    }

    @Override
    public String getFieldNativeTypeName(int index) throws DataException {
        return this.projectedCols[index - 1].getNativeTypeName();
    }

    @Override
    public ResultFieldMetadata getFieldMetaData(int index) throws DataException {
        return this.projectedCols[index - 1];
    }

    @Override
    public boolean hasClobOrBlob() throws DataException {
        return this.getResultClasstHelper().hasClobOrBlob();
    }

    @Override
    public int[] getClobFieldIndexes() throws DataException {
        return this.getResultClasstHelper().getClobIndexArray();
    }

    @Override
    public int[] getBlobFieldIndexes() throws DataException {
        return this.getResultClasstHelper().getBlobIndexArray();
    }

    public ResultClassHelper getResultClasstHelper() throws DataException {
        if (this.resultClassHelper == null) {
            this.resultClassHelper = new ResultClassHelper(this);
        }
        return this.resultClassHelper;
    }

    @Override
    public boolean hasAnyTYpe() throws DataException {
        if (this.hasAny) {
            int i = 0;
            while (i < this.projectedCols.length) {
                if (this.isOfAnyType(this.projectedCols[i])) {
                    return this.hasAny;
                }
                ++i;
            }
            this.hasAny = false;
        }
        return this.hasAny;
    }

    @Override
    public boolean wasAnyType(String name) throws DataException {
        Iterator it = this.originalAnyTypeField.iterator();
        while (it.hasNext()) {
            int index = (Integer)it.next();
            if (!this.getFieldName(index).equals(name) && !this.getFieldAlias(index).equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean wasAnyType(int index) {
        Iterator it = this.originalAnyTypeField.iterator();
        while (it.hasNext()) {
            if (index != (Integer)it.next()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getAnalysisType(int index) throws DataException {
        return this.projectedCols[index - 1].getAnalysisType();
    }

    @Override
    public String getAnalysisColumn(int index) throws DataException {
        return this.projectedCols[index - 1].getAnalysisColumn();
    }

    @Override
    public boolean isIndexColumn(int index) throws DataException {
        return this.projectedCols[index - 1].isIndexColumn();
    }

    @Override
    public boolean isCompressedColumn(int index) throws DataException {
        return this.projectedCols[index - 1].isCompressedColumn();
    }
}

