/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.noise.stein.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.AbstractNoiseCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.INoiseCalculator;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.exceptions.AnalysisSupportException;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.exceptions.SegmentNotAcceptedException;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignals;
import org.eclipse.chemclipse.model.support.AnalysisSupport;
import org.eclipse.chemclipse.model.support.IAnalysisSegment;
import org.eclipse.chemclipse.model.support.SegmentValidator;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.exceptions.NoExtractedIonSignalStoredException;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignalExtractor;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.chemclipse.numeric.statistics.Calculations;

public class NoiseCalculator
extends AbstractNoiseCalculator
implements INoiseCalculator {
    private static final Logger logger = Logger.getLogger(NoiseCalculator.class);
    private IChromatogram chromatogram;
    private int segmentWidth;
    private boolean recalculate = false;
    private float noiseFactor = 0.0f;

    public void setChromatogram(IChromatogram chromatogram, int segmentWidth) {
        this.chromatogram = chromatogram;
        this.segmentWidth = segmentWidth;
        this.recalculate = true;
    }

    public void recalculate() {
        this.recalculate = true;
    }

    public float getSignalToNoiseRatio(float intensity) {
        if (this.recalculate && this.chromatogram != null) {
            this.noiseFactor = this.calculateNoiseFactorByStein(this.chromatogram);
            this.recalculate = false;
        }
        if (this.noiseFactor != 0.0f) {
            return (float)(Math.sqrt(intensity) * (double)this.noiseFactor);
        }
        return 0.0f;
    }

    private float calculateNoiseFactorByStein(IChromatogram chromatogram) {
        float noiseValue = 0.0f;
        try {
            AnalysisSupport analysisSupport = new AnalysisSupport(chromatogram.getNumberOfScans(), this.segmentWidth);
            List segments = analysisSupport.getAnalysisSegments();
            if (chromatogram instanceof IChromatogramMSD) {
                IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogram;
                ExtractedIonSignalExtractor extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogramMSD);
                IExtractedIonSignals signals = extractedIonSignalExtractor.getExtractedIonSignals();
                noiseValue = this.performNoiseFactorCalculationByStein(segments, signals);
            } else {
                TotalScanSignals signals = new TotalScanSignals(chromatogram);
                noiseValue = this.performNoiseFactorCalculationByStein(segments, signals);
            }
        }
        catch (AnalysisSupportException e) {
            noiseValue = 0.0f;
            logger.warn((Object)e);
        }
        catch (ChromatogramIsNullException e) {
            noiseValue = 0.0f;
            logger.warn((Object)e);
        }
        if (noiseValue == 0.0f) {
            noiseValue = chromatogram.getMinSignal();
        }
        return noiseValue;
    }

    private float performNoiseFactorCalculationByStein(List<IAnalysisSegment> segments, Object signals) {
        List<Double> noiseFactors = this.getNoiseFactors(segments, signals);
        double medianNoiseFactor = Calculations.getMedian(noiseFactors);
        return (float)medianNoiseFactor;
    }

    private List<Double> getNoiseFactors(List<IAnalysisSegment> segments, Object signals) {
        ArrayList<Double> noiseFactors;
        block10: {
            SegmentValidator segmentValidator;
            double noiseValue;
            block9: {
                noiseFactors = new ArrayList<Double>();
                noiseValue = 0.0;
                segmentValidator = new SegmentValidator();
                if (!(signals instanceof IExtractedIonSignals)) break block9;
                IExtractedIonSignals extractedSignals = (IExtractedIonSignals)signals;
                int startIon = extractedSignals.getStartIon();
                int stopIon = extractedSignals.getStopIon();
                for (IAnalysisSegment segment : segments) {
                    int ion = startIon;
                    while (ion <= stopIon) {
                        try {
                            noiseValue = this.getMedianFromMeanByStein(segment, segmentValidator, ion, extractedSignals);
                            noiseFactors.add(noiseValue);
                        }
                        catch (SegmentNotAcceptedException segmentNotAcceptedException) {}
                        ++ion;
                    }
                    try {
                        noiseValue = this.getMedianFromMeanByStein(segment, segmentValidator, 0, extractedSignals);
                        noiseFactors.add(noiseValue);
                    }
                    catch (SegmentNotAcceptedException segmentNotAcceptedException) {}
                }
                break block10;
            }
            if (!(signals instanceof ITotalScanSignals)) break block10;
            ITotalScanSignals totalSignals = (ITotalScanSignals)signals;
            for (IAnalysisSegment segment : segments) {
                try {
                    noiseValue = this.getMedianFromMeanByStein(segment, segmentValidator, totalSignals);
                    noiseFactors.add(noiseValue);
                }
                catch (SegmentNotAcceptedException segmentNotAcceptedException) {}
            }
        }
        return noiseFactors;
    }

    private double getMedianFromMeanByStein(IAnalysisSegment segment, SegmentValidator segmentValidator, int ion, IExtractedIonSignals signals) throws SegmentNotAcceptedException {
        double[] values = new double[segment.getSegmentWidth()];
        int counter = 0;
        int scan = segment.getStartScan();
        while (scan <= segment.getStopScan()) {
            try {
                try {
                    IExtractedIonSignal signal = signals.getExtractedIonSignal(scan);
                    if ((double)ion == 0.0) {
                        values[counter] = signal.getTotalSignal();
                        continue;
                    }
                    values[counter] = signal.getAbundance(ion);
                }
                catch (NoExtractedIonSignalStoredException e) {
                    logger.warn((Object)e);
                    ++counter;
                }
            }
            finally {
                ++counter;
            }
        }
        return this.calculateNoiseFactorValue(segmentValidator, values);
    }

    private double getMedianFromMeanByStein(IAnalysisSegment segment, SegmentValidator segmentValidator, ITotalScanSignals signals) throws SegmentNotAcceptedException {
        double[] values = new double[segment.getSegmentWidth()];
        int counter = 0;
        int scan = segment.getStartScan();
        while (scan <= segment.getStopScan()) {
            ITotalScanSignal signal = signals.getTotalScanSignal(scan);
            values[counter] = signal.getTotalSignal();
            ++counter;
            ++scan;
        }
        return this.calculateNoiseFactorValue(segmentValidator, values);
    }

    private double calculateNoiseFactorValue(SegmentValidator segmentValidator, double[] values) throws SegmentNotAcceptedException {
        double mean = Calculations.getMean((double[])values);
        if (!segmentValidator.acceptSegment(values, mean)) {
            throw new SegmentNotAcceptedException();
        }
        double medianFromMedian = Calculations.getMedianDeviationFromMedian((double[])values);
        double nf = medianFromMedian / Math.sqrt(mean);
        return nf;
    }
}

