/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.swt.ui.components;

import java.util.ArrayList;
import org.eclipse.chemclipse.swt.ui.series.IMultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.ISeriesSetter;
import org.eclipse.chemclipse.swt.ui.series.MultipleSeries;
import org.eclipse.chemclipse.swt.ui.support.ChartUtil;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.thirdpartylibraries.swtchart.ext.InteractiveChartExtended;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.IAxis;
import org.swtchart.IAxisSet;
import org.swtchart.ISeries;
import org.swtchart.Range;

public abstract class AbstractBarSeriesUI
extends InteractiveChartExtended
implements ISeriesSetter,
KeyListener,
MouseListener {
    protected boolean master = false;
    protected IChromatogramSelectionWSD chromatogramSelection;
    protected IScanWSD supplierScan;
    protected IMultipleSeries multipleLineSeries;
    private double maxSignal = 0.0;
    private IAxis wavelength;
    private IAxis nm;
    private IAxis abundance;
    private IAxis relativeAbundance;
    private int xStart;
    private int yStart;
    private static final double SPACE_FACTOR = 0.15;

    public AbstractBarSeriesUI(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void clear() {
        this.deleteAllCurrentSeries();
        this.maxSignal = 1.0;
        this.supplierScan = null;
        ArrayList<IAxis> axisList = new ArrayList<IAxis>();
        axisList.add(this.wavelength);
        axisList.add(this.nm);
        axisList.add(this.abundance);
        axisList.add(this.relativeAbundance);
        for (IAxis axis : axisList) {
            Range range = axis.getRange();
            range.lower = 0.0;
            range.upper = 1.0;
            axis.setRange(range);
        }
        this.getAxisSet().adjustRange();
        super.redraw();
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public void update(IScanWSD supplierScan, boolean forceReload) {
        this.supplierScan = supplierScan;
        if (!this.master || this.master && forceReload) {
            this.setSeries(forceReload);
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void redraw() {
        super.redraw();
        double xMin = this.multipleLineSeries.getXMin();
        double xMax = this.multipleLineSeries.getXMax();
        if (xMin < xMax) {
            ChartUtil.checkAndSetRange((IAxis)this.wavelength, (double)xMin, (double)xMax);
            double yMin = this.multipleLineSeries.getYMin();
            double yMax = this.multipleLineSeries.getYMax();
            yMax += yMax * 0.15;
            ChartUtil.checkAndSetRange((IAxis)this.abundance, (double)yMin, (double)yMax);
            this.addSpaceToTopOfAbundance(yMax);
            this.redrawIonScale();
            this.redrawRelativeAbundanceScale();
        }
    }

    private void addSpaceToTopOfAbundance(double yMax) {
        Range range = this.abundance.getRange();
        double upperLimit = range.upper + range.upper * 0.15;
        if (upperLimit >= yMax) {
            range.upper = yMax;
            this.abundance.setRange(range);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.xStart = e.x;
        this.yStart = e.y;
    }

    public void mouseUp(MouseEvent e) {
        if (this.master && e.button == 1 && (this.xStart != e.x || this.yStart != e.y)) {
            System.out.println("wavelength selection");
        }
    }

    protected void initialize() {
        this.getPlotArea().addKeyListener((KeyListener)this);
        this.getPlotArea().addMouseListener((MouseListener)this);
        this.multipleLineSeries = new MultipleSeries();
        this.getLegend().setVisible(false);
        this.getTitle().setVisible(false);
        this.createPrimaryAxes();
        this.createSecondaryAxes();
        this.setAxesAndBackgroundColors();
        this.getAxisSet().adjustRange();
    }

    private void redrawIonScale() {
        assert (this.wavelength != null) : "The ions instance must be not null.";
        assert (this.nm != null) : "The dalton instance must be not null.";
        Range range = this.wavelength.getRange();
        double min = range.lower;
        double max = range.upper;
        ChartUtil.setRange((IAxis)this.nm, (double)min, (double)max);
    }

    private void redrawRelativeAbundanceScale() {
        assert (this.abundance != null) : "The abundance instance must be not null.";
        assert (this.relativeAbundance != null) : "The relativeAbundance instance must be not null.";
        Range range = this.abundance.getRange();
        double min = ChartUtil.getRelativeAbundance((double)this.maxSignal, (double)range.lower);
        double max = ChartUtil.getRelativeAbundance((double)this.maxSignal, (double)range.upper);
        ChartUtil.setRange((IAxis)this.relativeAbundance, (double)min, (double)max);
    }

    private void createPrimaryAxes() {
        IAxisSet axisSet = this.getAxisSet();
        this.wavelength = axisSet.getXAxis(0);
        this.abundance = axisSet.getYAxis(0);
        this.abundance.getTitle().setText("abundance");
        this.wavelength.getTitle().setText("wavelength");
    }

    private void createSecondaryAxes() {
        IAxisSet axisSet = this.getAxisSet();
        int axisIdMinutes = axisSet.createXAxis();
        this.nm = axisSet.getXAxis(axisIdMinutes);
        this.nm.getTitle().setText("nm");
        this.nm.setPosition(IAxis.Position.Secondary);
        int axisIdAbundanceRelative = axisSet.createYAxis();
        this.relativeAbundance = axisSet.getYAxis(axisIdAbundanceRelative);
        this.relativeAbundance.getTitle().setText("relative abundance");
        this.relativeAbundance.setPosition(IAxis.Position.Secondary);
    }

    private void setSecondaryRanges() {
        assert (this.chromatogramSelection != null) : "The chromatogramSelection instance must be not null.";
        assert (this.nm != null) : "The nm instance must be not null.";
        assert (this.relativeAbundance != null) : "The relativeAbundance instance must be not null.";
        double min = this.multipleLineSeries.getXMin();
        double max = this.multipleLineSeries.getXMax();
        Range range = new Range(min, max);
        this.nm.setRange(range);
        min = ChartUtil.getRelativeAbundance((double)this.maxSignal, (double)this.multipleLineSeries.getYMin());
        max = ChartUtil.getRelativeAbundance((double)this.maxSignal, (double)this.multipleLineSeries.getYMax());
        range = new Range(min, max);
        this.relativeAbundance.setRange(range);
    }

    private void setAxesAndBackgroundColors() {
        assert (this.abundance != null) : "The abundance instance must be not null.";
        assert (this.wavelength != null) : "The wavelength instance must be not null.";
        assert (this.nm != null) : "The dalton instance must be not null.";
        assert (this.relativeAbundance != null) : "The relativeAbundance instance must be not null.";
        this.setBackground(Colors.WHITE);
        this.setBackgroundInPlotArea(Colors.WHITE);
        ChartUtil.setAxisColor((IAxis)this.abundance, (Color)Colors.BLACK);
        ChartUtil.setAxisColor((IAxis)this.wavelength, (Color)Colors.BLACK);
        ChartUtil.setAxisColor((IAxis)this.nm, (Color)Colors.BLACK);
        ChartUtil.setAxisColor((IAxis)this.relativeAbundance, (Color)Colors.BLACK);
    }

    protected void setSeries(boolean forceReload) {
        assert (this.chromatogramSelection != null) : "The chromatogramSelection instance must be not null.";
        assert (this.multipleLineSeries != null) : "The multipleLineSeries instance must be not null.";
        this.deleteAllCurrentSeries();
        this.setViewSeries();
        double xMin = this.multipleLineSeries.getXMin();
        double xMax = this.multipleLineSeries.getXMax();
        if (xMin < xMax) {
            this.maxSignal = this.multipleLineSeries.getYMax();
            this.getAxisSet().adjustRange();
            this.setSecondaryRanges();
        }
        this.redraw();
    }

    private void deleteAllCurrentSeries() {
        this.multipleLineSeries.removeAll();
        ISeries[] series = this.getSeriesSet().getSeries();
        ArrayList<String> ids = new ArrayList<String>();
        ISeries[] iSeriesArray = series;
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries serie = iSeriesArray[n2];
            ids.add(serie.getId());
            ++n2;
        }
        for (String id : ids) {
            this.getSeriesSet().deleteSeries(id);
        }
    }
}

