/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RectangularCholeskyDecomposition;
import org.apache.commons.math3.random.NormalizedRandomGenerator;
import org.apache.commons.math3.random.RandomVectorGenerator;

public class CorrelatedRandomVectorGenerator
implements RandomVectorGenerator {
    private final double[] mean;
    private final NormalizedRandomGenerator generator;
    private final double[] normalized;
    private final RealMatrix root;

    public CorrelatedRandomVectorGenerator(double[] mean, RealMatrix covariance, double small, NormalizedRandomGenerator generator) {
        int order = covariance.getRowDimension();
        if (mean.length != order) {
            throw new DimensionMismatchException(mean.length, order);
        }
        this.mean = (double[])mean.clone();
        RectangularCholeskyDecomposition decomposition = new RectangularCholeskyDecomposition(covariance, small);
        this.root = decomposition.getRootMatrix();
        this.generator = generator;
        this.normalized = new double[decomposition.getRank()];
    }

    public CorrelatedRandomVectorGenerator(RealMatrix covariance, double small, NormalizedRandomGenerator generator) {
        int order = covariance.getRowDimension();
        this.mean = new double[order];
        int i = 0;
        while (i < order) {
            this.mean[i] = 0.0;
            ++i;
        }
        RectangularCholeskyDecomposition decomposition = new RectangularCholeskyDecomposition(covariance, small);
        this.root = decomposition.getRootMatrix();
        this.generator = generator;
        this.normalized = new double[decomposition.getRank()];
    }

    public NormalizedRandomGenerator getGenerator() {
        return this.generator;
    }

    public int getRank() {
        return this.normalized.length;
    }

    public RealMatrix getRootMatrix() {
        return this.root;
    }

    @Override
    public double[] nextVector() {
        int i = 0;
        while (i < this.normalized.length) {
            this.normalized[i] = this.generator.nextNormalizedDouble();
            ++i;
        }
        double[] correlated = new double[this.mean.length];
        int i2 = 0;
        while (i2 < correlated.length) {
            correlated[i2] = this.mean[i2];
            int j = 0;
            while (j < this.root.getColumnDimension()) {
                int n = i2;
                correlated[n] = correlated[n] + this.root.getEntry(i2, j) * this.normalized[j];
                ++j;
            }
            ++i2;
        }
        return correlated;
    }
}

