/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.io.Serializable;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.AbstractFieldMatrix;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.FieldMatrixChangingVisitor;
import org.apache.commons.math3.linear.FieldMatrixPreservingVisitor;
import org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

public class Array2DRowFieldMatrix<T extends FieldElement<T>>
extends AbstractFieldMatrix<T>
implements Serializable {
    private static final long serialVersionUID = 7260756672015356458L;
    private T[][] data;

    public Array2DRowFieldMatrix(Field<T> field) {
        super(field);
    }

    public Array2DRowFieldMatrix(Field<T> field, int rowDimension, int columnDimension) throws NotStrictlyPositiveException {
        super(field, rowDimension, columnDimension);
        this.data = (FieldElement[][])MathArrays.buildArray(field, rowDimension, columnDimension);
    }

    public Array2DRowFieldMatrix(T[][] d) throws DimensionMismatchException, NullArgumentException, NoDataException {
        this(Array2DRowFieldMatrix.extractField(d), (FieldElement[][])d);
    }

    public Array2DRowFieldMatrix(Field<T> field, T[][] d) throws DimensionMismatchException, NullArgumentException, NoDataException {
        super(field);
        this.copyIn((FieldElement[][])d);
    }

    public Array2DRowFieldMatrix(T[][] d, boolean copyArray) throws DimensionMismatchException, NoDataException, NullArgumentException {
        this(Array2DRowFieldMatrix.extractField(d), (FieldElement[][])d, copyArray);
    }

    public Array2DRowFieldMatrix(Field<T> field, T[][] d, boolean copyArray) throws DimensionMismatchException, NoDataException, NullArgumentException {
        super(field);
        if (copyArray) {
            this.copyIn((FieldElement[][])d);
        } else {
            MathUtils.checkNotNull(d);
            int nRows = d.length;
            if (nRows == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
            }
            int nCols = d[0].length;
            if (nCols == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
            }
            int r = 1;
            while (r < nRows) {
                if (d[r].length != nCols) {
                    throw new DimensionMismatchException(nCols, d[r].length);
                }
                ++r;
            }
            this.data = d;
        }
    }

    public Array2DRowFieldMatrix(T[] v) throws NoDataException {
        this(Array2DRowFieldMatrix.extractField(v), (FieldElement[])v);
    }

    public Array2DRowFieldMatrix(Field<T> field, T[] v) {
        super(field);
        int nRows = v.length;
        this.data = (FieldElement[][])MathArrays.buildArray(this.getField(), nRows, 1);
        int row = 0;
        while (row < nRows) {
            this.data[row][0] = v[row];
            ++row;
        }
    }

    @Override
    public FieldMatrix<T> createMatrix(int rowDimension, int columnDimension) throws NotStrictlyPositiveException {
        return new Array2DRowFieldMatrix(this.getField(), rowDimension, columnDimension);
    }

    @Override
    public FieldMatrix<T> copy() {
        return new Array2DRowFieldMatrix(this.getField(), this.copyOut(), false);
    }

    @Override
    public Array2DRowFieldMatrix<T> add(Array2DRowFieldMatrix<T> m) throws MatrixDimensionMismatchException {
        this.checkAdditionCompatible(m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldElement[][] outData = (FieldElement[][])MathArrays.buildArray(this.getField(), rowCount, columnCount);
        int row = 0;
        while (row < rowCount) {
            T[] dataRow = this.data[row];
            T[] mRow = m.data[row];
            FieldElement[] outDataRow = outData[row];
            int col = 0;
            while (col < columnCount) {
                outDataRow[col] = (FieldElement)dataRow[col].add(mRow[col]);
                ++col;
            }
            ++row;
        }
        return new Array2DRowFieldMatrix(this.getField(), outData, false);
    }

    @Override
    public Array2DRowFieldMatrix<T> subtract(Array2DRowFieldMatrix<T> m) throws MatrixDimensionMismatchException {
        this.checkSubtractionCompatible(m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldElement[][] outData = (FieldElement[][])MathArrays.buildArray(this.getField(), rowCount, columnCount);
        int row = 0;
        while (row < rowCount) {
            T[] dataRow = this.data[row];
            T[] mRow = m.data[row];
            FieldElement[] outDataRow = outData[row];
            int col = 0;
            while (col < columnCount) {
                outDataRow[col] = (FieldElement)dataRow[col].subtract(mRow[col]);
                ++col;
            }
            ++row;
        }
        return new Array2DRowFieldMatrix(this.getField(), outData, false);
    }

    @Override
    public Array2DRowFieldMatrix<T> multiply(Array2DRowFieldMatrix<T> m) throws DimensionMismatchException {
        this.checkMultiplicationCompatible(m);
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        FieldElement[][] outData = (FieldElement[][])MathArrays.buildArray(this.getField(), nRows, nCols);
        int row = 0;
        while (row < nRows) {
            T[] dataRow = this.data[row];
            FieldElement[] outDataRow = outData[row];
            int col = 0;
            while (col < nCols) {
                FieldElement sum = (FieldElement)this.getField().getZero();
                int i = 0;
                while (i < nSum) {
                    sum = sum.add((FieldElement)dataRow[i].multiply(m.data[i][col]));
                    ++i;
                }
                outDataRow[col] = sum;
                ++col;
            }
            ++row;
        }
        return new Array2DRowFieldMatrix(this.getField(), outData, false);
    }

    @Override
    public T[][] getData() {
        return this.copyOut();
    }

    public T[][] getDataRef() {
        return this.data;
    }

    @Override
    public void setSubMatrix(T[][] subMatrix, int row, int column) throws OutOfRangeException, NullArgumentException, NoDataException, DimensionMismatchException {
        if (this.data == null) {
            if (row > 0) {
                throw new MathIllegalStateException(LocalizedFormats.FIRST_ROWS_NOT_INITIALIZED_YET, row);
            }
            if (column > 0) {
                throw new MathIllegalStateException(LocalizedFormats.FIRST_COLUMNS_NOT_INITIALIZED_YET, column);
            }
            int nRows = subMatrix.length;
            if (nRows == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
            }
            int nCols = subMatrix[0].length;
            if (nCols == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
            }
            this.data = (FieldElement[][])MathArrays.buildArray(this.getField(), subMatrix.length, nCols);
            int i = 0;
            while (i < this.data.length) {
                if (subMatrix[i].length != nCols) {
                    throw new DimensionMismatchException(nCols, subMatrix[i].length);
                }
                System.arraycopy(subMatrix[i], 0, this.data[i + row], column, nCols);
                ++i;
            }
        } else {
            super.setSubMatrix(subMatrix, row, column);
        }
    }

    @Override
    public T getEntry(int row, int column) throws OutOfRangeException {
        this.checkRowIndex(row);
        this.checkColumnIndex(column);
        return this.data[row][column];
    }

    @Override
    public void setEntry(int row, int column, T value) throws OutOfRangeException {
        this.checkRowIndex(row);
        this.checkColumnIndex(column);
        this.data[row][column] = value;
    }

    @Override
    public void addToEntry(int row, int column, T increment) throws OutOfRangeException {
        this.checkRowIndex(row);
        this.checkColumnIndex(column);
        this.data[row][column] = (FieldElement)this.data[row][column].add(increment);
    }

    @Override
    public void multiplyEntry(int row, int column, T factor) throws OutOfRangeException {
        this.checkRowIndex(row);
        this.checkColumnIndex(column);
        this.data[row][column] = (FieldElement)this.data[row][column].multiply(factor);
    }

    @Override
    public int getRowDimension() {
        return this.data == null ? 0 : this.data.length;
    }

    @Override
    public int getColumnDimension() {
        return this.data == null || this.data[0] == null ? 0 : this.data[0].length;
    }

    @Override
    public T[] operate(T[] v) throws DimensionMismatchException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nCols) {
            throw new DimensionMismatchException(v.length, nCols);
        }
        FieldElement[] out = (FieldElement[])MathArrays.buildArray(this.getField(), nRows);
        int row = 0;
        while (row < nRows) {
            T[] dataRow = this.data[row];
            FieldElement sum = (FieldElement)this.getField().getZero();
            int i = 0;
            while (i < nCols) {
                sum = sum.add((FieldElement)dataRow[i].multiply(v[i]));
                ++i;
            }
            out[row] = sum;
            ++row;
        }
        return out;
    }

    @Override
    public T[] preMultiply(T[] v) throws DimensionMismatchException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nRows) {
            throw new DimensionMismatchException(v.length, nRows);
        }
        FieldElement[] out = (FieldElement[])MathArrays.buildArray(this.getField(), nCols);
        int col = 0;
        while (col < nCols) {
            FieldElement sum = (FieldElement)this.getField().getZero();
            int i = 0;
            while (i < nRows) {
                sum = sum.add((FieldElement)this.data[i][col].multiply(v[i]));
                ++i;
            }
            out[col] = sum;
            ++col;
        }
        return out;
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int i = 0;
        while (i < rows) {
            T[] rowI = this.data[i];
            int j = 0;
            while (j < columns) {
                rowI[j] = visitor.visit(i, j, rowI[j]);
                ++j;
            }
            ++i;
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int i = 0;
        while (i < rows) {
            T[] rowI = this.data[i];
            int j = 0;
            while (j < columns) {
                visitor.visit(i, j, rowI[j]);
                ++j;
            }
            ++i;
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws OutOfRangeException, NumberIsTooSmallException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int i = startRow;
        while (i <= endRow) {
            T[] rowI = this.data[i];
            int j = startColumn;
            while (j <= endColumn) {
                rowI[j] = visitor.visit(i, j, rowI[j]);
                ++j;
            }
            ++i;
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws OutOfRangeException, NumberIsTooSmallException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int i = startRow;
        while (i <= endRow) {
            T[] rowI = this.data[i];
            int j = startColumn;
            while (j <= endColumn) {
                visitor.visit(i, j, rowI[j]);
                ++j;
            }
            ++i;
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int j = 0;
        while (j < columns) {
            int i = 0;
            while (i < rows) {
                T[] rowI = this.data[i];
                rowI[j] = visitor.visit(i, j, rowI[j]);
                ++i;
            }
            ++j;
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int j = 0;
        while (j < columns) {
            int i = 0;
            while (i < rows) {
                visitor.visit(i, j, this.data[i][j]);
                ++i;
            }
            ++j;
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws OutOfRangeException, NumberIsTooSmallException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int j = startColumn;
        while (j <= endColumn) {
            int i = startRow;
            while (i <= endRow) {
                T[] rowI = this.data[i];
                rowI[j] = visitor.visit(i, j, rowI[j]);
                ++i;
            }
            ++j;
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws OutOfRangeException, NumberIsTooSmallException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int j = startColumn;
        while (j <= endColumn) {
            int i = startRow;
            while (i <= endRow) {
                visitor.visit(i, j, this.data[i][j]);
                ++i;
            }
            ++j;
        }
        return visitor.end();
    }

    private T[][] copyOut() {
        int nRows = this.getRowDimension();
        FieldElement[][] out = (FieldElement[][])MathArrays.buildArray(this.getField(), nRows, this.getColumnDimension());
        int i = 0;
        while (i < nRows) {
            System.arraycopy(this.data[i], 0, out[i], 0, this.data[i].length);
            ++i;
        }
        return out;
    }

    private void copyIn(T[][] in) throws NullArgumentException, NoDataException, DimensionMismatchException {
        this.setSubMatrix((FieldElement[][])in, 0, 0);
    }
}

