/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.handlers;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabase;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.QuantDatabases;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.exceptions.NoQuantitationTableAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards.AddPeakToQuantitationTableWizard;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.chemclipse.rcp.app.ui.handlers.PerspectiveSwitchHandler;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class AddSelectedPeakToQuantitationTableHandler
implements EventHandler {
    private static final Logger logger = Logger.getLogger(AddSelectedPeakToQuantitationTableHandler.class);
    private static IChromatogramSelectionMSD chromatogramSelection;
    @Inject
    IEventBroker eventBroker;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        IChromatogramPeakMSD chromatogramPeakMSD;
        PerspectiveSwitchHandler.focusPerspectiveAndView((String)"org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.perspective", (String)"org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.views.QuantitationCompoundsView");
        if (chromatogramSelection != null && (chromatogramPeakMSD = chromatogramSelection.getSelectedPeak()) != null) {
            try {
                IQuantDatabase database = QuantDatabases.getQuantDatabase();
                AddPeakToQuantitationTableWizard wizard = new AddPeakToQuantitationTableWizard(database, chromatogramPeakMSD);
                WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    if (this.eventBroker != null) {
                        this.eventBroker.send("quantitation/msd/update/supplier/chemclipse/quantitationtable", (Object)PreferenceSupplier.getSelectedQuantitationTable());
                    }
                    StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Done: The peak has been successfully added to the quantitation table.");
                }
            }
            catch (NoQuantitationTableAvailableException e) {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Quantitation", (String)"Please select a quantitation table previously.");
                StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"There is no quantitation table available.");
                logger.warn((Object)e);
            }
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("chromatogram/msd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
        }
    }
}

