/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow;

import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.ComboBoxGlazedListsFilterStrategy;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.GlazedListsFilterRowComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowDataLayer;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.ComboBoxFilterRowConfiguration;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboUpdateEvent;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.IFilterRowComboUpdateListener;
import org.eclipse.nebula.widgets.nattable.filterrow.command.ClearAllFiltersCommand;
import org.eclipse.nebula.widgets.nattable.filterrow.command.ClearFilterCommand;
import org.eclipse.nebula.widgets.nattable.filterrow.command.ToggleFilterRowCommand;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;

public class ComboBoxFilterRowHeaderComposite<T>
extends CompositeLayer
implements IFilterRowComboUpdateListener {
    protected final FilterRowDataLayer<T> filterRowDataLayer;
    protected boolean filterRowVisible = true;
    protected final FilterRowComboBoxDataProvider<T> comboBoxDataProvider;
    protected final ComboBoxGlazedListsFilterStrategy<T> filterStrategy;

    public ComboBoxFilterRowHeaderComposite(FilterList<T> filterList, ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> bodyDataColumnAccessor, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry) {
        this(filterList, bodyLayer, baseCollection, bodyDataColumnAccessor, columnHeaderLayer, columnHeaderDataProvider, configRegistry, true);
    }

    public ComboBoxFilterRowHeaderComposite(FilterList<T> filterList, ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> bodyDataColumnAccessor, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        this(filterList, new GlazedListsFilterRowComboBoxDataProvider<T>(bodyLayer, baseCollection, bodyDataColumnAccessor), bodyDataColumnAccessor, columnHeaderLayer, columnHeaderDataProvider, configRegistry, useDefaultConfiguration);
    }

    public ComboBoxFilterRowHeaderComposite(FilterList<T> filterList, CompositeMatcherEditor<T> matcherEditor, ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> bodyDataColumnAccessor, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        this(filterList, matcherEditor, new GlazedListsFilterRowComboBoxDataProvider<T>(bodyLayer, baseCollection, bodyDataColumnAccessor), bodyDataColumnAccessor, columnHeaderLayer, columnHeaderDataProvider, configRegistry, useDefaultConfiguration);
    }

    public ComboBoxFilterRowHeaderComposite(FilterList<T> filterList, FilterRowComboBoxDataProvider<T> comboBoxDataProvider, IColumnAccessor<T> bodyDataColumnAccessor, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry) {
        this(filterList, comboBoxDataProvider, bodyDataColumnAccessor, columnHeaderLayer, columnHeaderDataProvider, configRegistry, true);
    }

    public ComboBoxFilterRowHeaderComposite(FilterList<T> filterList, FilterRowComboBoxDataProvider<T> comboBoxDataProvider, IColumnAccessor<T> bodyDataColumnAccessor, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        this(new ComboBoxGlazedListsFilterStrategy<T>(comboBoxDataProvider, filterList, bodyDataColumnAccessor, configRegistry), comboBoxDataProvider, columnHeaderLayer, columnHeaderDataProvider, configRegistry, useDefaultConfiguration);
    }

    public ComboBoxFilterRowHeaderComposite(FilterList<T> filterList, CompositeMatcherEditor<T> matcherEditor, FilterRowComboBoxDataProvider<T> comboBoxDataProvider, IColumnAccessor<T> bodyDataColumnAccessor, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        this(new ComboBoxGlazedListsFilterStrategy<T>(comboBoxDataProvider, filterList, matcherEditor, bodyDataColumnAccessor, configRegistry), comboBoxDataProvider, columnHeaderLayer, columnHeaderDataProvider, configRegistry, useDefaultConfiguration);
    }

    public ComboBoxFilterRowHeaderComposite(ComboBoxGlazedListsFilterStrategy<T> filterStrategy, FilterRowComboBoxDataProvider<T> comboBoxDataProvider, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        super(1, 2);
        this.setChildLayer("columnHeader", columnHeaderLayer, 0, 0);
        this.filterStrategy = filterStrategy;
        this.comboBoxDataProvider = comboBoxDataProvider;
        this.comboBoxDataProvider.addCacheUpdateListener((IFilterRowComboUpdateListener)this);
        this.filterRowDataLayer = new FilterRowDataLayer(this.filterStrategy, columnHeaderLayer, columnHeaderDataProvider, configRegistry);
        this.setAllValuesSelected();
        this.setChildLayer("FILTER_ROW", (ILayer)this.filterRowDataLayer, 0, 1);
        if (useDefaultConfiguration) {
            this.addConfiguration((IConfiguration)new ComboBoxFilterRowConfiguration(this.comboBoxDataProvider));
        }
    }

    public FilterRowDataLayer<T> getFilterRowDataLayer() {
        return this.filterRowDataLayer;
    }

    public CompositeMatcherEditor<T> getMatcherEditor() {
        return this.filterStrategy.getMatcherEditor();
    }

    public ComboBoxGlazedListsFilterStrategy<T> getFilterStrategy() {
        return this.filterStrategy;
    }

    public FilterRowComboBoxDataProvider<T> getComboBoxDataProvider() {
        return this.comboBoxDataProvider;
    }

    public boolean isFilterRowVisible() {
        return this.filterRowVisible;
    }

    public void setFilterRowVisible(boolean filterRowVisible) {
        this.filterRowVisible = filterRowVisible;
        this.fireLayerEvent((ILayerEvent)new RowStructuralRefreshEvent(this.filterRowDataLayer));
    }

    public void setAllValuesSelected() {
        FilterRowDataProvider dataProvider = this.filterRowDataLayer.getFilterRowDataProvider();
        int i = 0;
        while (i < dataProvider.getColumnCount()) {
            dataProvider.getFilterIndexToObjectMap().put(i, this.comboBoxDataProvider.getValues(i, 0));
            ++i;
        }
        this.getFilterStrategy().applyFilter(dataProvider.getFilterIndexToObjectMap());
    }

    public int getHeight() {
        if (this.filterRowVisible) {
            return super.getHeight();
        }
        return this.getHeightOffset(1);
    }

    public int getRowCount() {
        if (this.filterRowVisible) {
            return super.getRowCount();
        }
        return super.getRowCount() - 1;
    }

    public boolean doCommand(ILayerCommand command) {
        boolean handled = false;
        if (command instanceof ToggleFilterRowCommand) {
            this.setFilterRowVisible(!this.filterRowVisible);
            return true;
        }
        if (command instanceof ClearFilterCommand && command.convertToTargetLayer((ILayer)this)) {
            int columnPosition = ((ClearFilterCommand)command).getColumnPosition();
            this.filterRowDataLayer.setDataValueByPosition(columnPosition, 0, (Object)this.getComboBoxDataProvider().getValues(columnPosition, 0));
            handled = true;
        } else if (command instanceof ClearAllFiltersCommand) {
            this.setAllValuesSelected();
            handled = true;
        }
        if (handled) {
            this.fireLayerEvent((ILayerEvent)new RowStructuralRefreshEvent((ILayer)this));
            return true;
        }
        return super.doCommand(command);
    }

    public void handleEvent(FilterRowComboUpdateEvent event) {
        Map filterIndexToObjectMap = this.filterRowDataLayer.getFilterRowDataProvider().getFilterIndexToObjectMap();
        Object filterObject = filterIndexToObjectMap.get(event.getColumnIndex());
        if (filterObject != null && filterObject instanceof Collection) {
            Collection filterCollection = (Collection)filterObject;
            if (event.getAddedItems() != null && !event.getAddedItems().isEmpty()) {
                ArrayList itemsToAdd = new ArrayList(event.getAddedItems());
                itemsToAdd.removeAll(filterCollection);
                filterCollection.addAll(itemsToAdd);
            }
            if (event.getRemovedItems() != null && !event.getRemovedItems().isEmpty()) {
                filterCollection.removeAll(event.getRemovedItems());
            }
        }
        this.getFilterStrategy().applyFilter(this.filterRowDataLayer.getFilterRowDataProvider().getFilterIndexToObjectMap());
    }
}

