/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.views;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IChromatogramIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.ICombinedIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.notifier.IIntegrationResultUpdateNotifier;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.swt.IntegrationResultsTabFolderUI;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class IntegrationResultView
implements IIntegrationResultUpdateNotifier {
    @Inject
    private Composite parent;
    private IntegrationResultsTabFolderUI resultsTabFolderUI;
    @Inject
    private EPartService partService;
    @Inject
    MPart part;
    @Inject
    private IEventBroker eventBroker;
    private EventHandler eventHandlerCombined;
    private EventHandler eventHandlerChromatogram;
    private EventHandler eventHandlerPeak;

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.resultsTabFolderUI = new IntegrationResultsTabFolderUI(this.parent, 0);
        this.subscribe();
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.resultsTabFolderUI.setFocus();
    }

    public boolean isPartVisible() {
        return this.partService != null && this.partService.isPartVisible(this.part);
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandlerCombined = new EventHandler(){

                public void handleEvent(Event event) {
                    ICombinedIntegrationResult combinedIntegrationResult = (ICombinedIntegrationResult)event.getProperty("org.eclipse.e4.data");
                    IntegrationResultView.this.update(combinedIntegrationResult);
                }
            };
            this.eventBroker.subscribe("integration/msd/update/result/combined", this.eventHandlerCombined);
            this.eventHandlerChromatogram = new EventHandler(){

                public void handleEvent(Event event) {
                    IChromatogramIntegrationResults chromatogramIntegrationResult = (IChromatogramIntegrationResults)event.getProperty("org.eclipse.e4.data");
                    IntegrationResultView.this.update(chromatogramIntegrationResult);
                }
            };
            this.eventBroker.subscribe("integration/msd/update/result/chromatogram", this.eventHandlerChromatogram);
            this.eventHandlerPeak = new EventHandler(){

                public void handleEvent(Event event) {
                    IPeakIntegrationResults peakIntegrationResults = (IPeakIntegrationResults)event.getProperty("org.eclipse.e4.data");
                    IntegrationResultView.this.update(peakIntegrationResults);
                }
            };
            this.eventBroker.subscribe("integration/msd/update/result/peak", this.eventHandlerPeak);
        }
    }

    public void unsubscribe() {
        if (this.eventBroker != null) {
            if (this.eventHandlerCombined != null) {
                this.eventBroker.unsubscribe(this.eventHandlerCombined);
            }
            if (this.eventHandlerChromatogram != null) {
                this.eventBroker.unsubscribe(this.eventHandlerChromatogram);
            }
            if (this.eventHandlerPeak != null) {
                this.eventBroker.unsubscribe(this.eventHandlerPeak);
            }
        }
    }

    @Override
    public void update(ICombinedIntegrationResult combinedIntegrationResult) {
        if (this.isPartVisible()) {
            this.resultsTabFolderUI.update(combinedIntegrationResult);
        }
    }

    @Override
    public void update(IChromatogramIntegrationResults chromatogramIntegrationResults) {
        if (this.isPartVisible()) {
            this.resultsTabFolderUI.update(chromatogramIntegrationResults);
        }
    }

    @Override
    public void update(IPeakIntegrationResults peakIntegrationResults) {
        if (this.isPartVisible()) {
            this.resultsTabFolderUI.update(peakIntegrationResults);
        }
    }
}

