/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.menu;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemState;
import org.eclipse.nebula.widgets.nattable.ui.menu.MenuItemProviders;
import org.eclipse.nebula.widgets.nattable.ui.menu.MenuItemStateMap;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PopupMenuBuilder {
    public static final String HIDE_COLUMN_MENU_ITEM_ID = "hideColumnMenuItem";
    public static final String SHOW_ALL_COLUMNS_MENU_ITEM_ID = "showAllColumnsMenuItem";
    public static final String HIDE_ROW_MENU_ITEM_ID = "hideRowMenuItem";
    public static final String SHOW_ALL_ROWS_MENU_ITEM_ID = "showAllRowsMenuItem";
    public static final String AUTO_RESIZE_COLUMN_MENU_ITEM_ID = "autoResizeColumnMenuItem";
    public static final String AUTO_RESIZE_ROW_MENU_ITEM_ID = "autoResizeRowMenuItem";
    public static final String AUTO_RESIZE_ALL_SELECTED_COLUMN_MENU_ITEM_ID = "autoResizeAllSelectedColumnMenuItem";
    public static final String COLUMN_CHOOSER_MENU_ITEM_ID = "columnChooserMenuItem";
    public static final String COLUMN_STYLE_EDITOR_MENU_ITEM_ID = "columnStyleEditorMenuItem";
    public static final String COLUMN_RENAME_MENU_ITEM_ID = "columnRenameMenuItem";
    public static final String CREATE_COLUMN_GROUP_MENU_ITEM_ID = "createColumnGroupMenuItem";
    public static final String RENAME_COLUMN_GROUP_MENU_ITEM_ID = "renameColumnGroupMenuItem";
    public static final String REMOVE_COLUMN_GROUP_MENU_ITEM_ID = "removeColumnGroupMenuItem";
    public static final String UNGROUP_COLUMNS_MENU_ITEM_ID = "ungroupColumnsMenuItem";
    public static final String INSPECT_LABEL_MENU_ITEM_ID = "inspectLabelMenuItem";
    public static final String CATEGORIES_BASED_COLUMN_CHOOSER_MENU_ITEM_ID = "categoriesBasedColumnChooserMenuItem";
    public static final String CLEAR_ALL_FILTERS_MENU_ITEM_ID = "clearAllFiltersMenuItem";
    public static final String TOGGLE_FILTER_ROW_MENU_ITEM_ID = "toggleFilterRowMenuItem";
    public static final String STATE_MANAGER_MENU_ITEM_ID = "stateManagerMenuItem";
    public static final String SEPARATOR_MENU_ITEM_ID = "separatorMenuItem";
    protected NatTable natTable;
    protected Menu popupMenu;
    protected MenuManager menuManager;
    protected final MenuItemStateMap visibility = new MenuItemStateMap();
    protected final MenuItemStateMap enablement = new MenuItemStateMap();

    public PopupMenuBuilder(NatTable parent) {
        this(parent, new MenuManager());
    }

    public PopupMenuBuilder(NatTable parent, MenuManager manager) {
        this.natTable = parent;
        this.menuManager = manager;
        this.popupMenu = manager.createContextMenu((Control)this.natTable);
    }

    public PopupMenuBuilder(NatTable natTable, Menu menu) {
        this.natTable = natTable;
        this.popupMenu = menu;
        if (menu.getData() != null && menu.getData() instanceof MenuManager) {
            this.menuManager = (MenuManager)menu.getData();
        }
    }

    public PopupMenuBuilder withMenuItemProvider(IMenuItemProvider menuItemProvider) {
        if (this.menuManager == null) {
            menuItemProvider.addMenuItem(this.natTable, this.popupMenu);
        } else {
            this.menuManager.add((IContributionItem)new PopupContributionItem(menuItemProvider));
        }
        return this;
    }

    public PopupMenuBuilder withMenuItemProvider(String id, IMenuItemProvider menuItemProvider) {
        if (this.menuManager == null) {
            menuItemProvider.addMenuItem(this.natTable, this.popupMenu);
        } else {
            this.menuManager.add((IContributionItem)new PopupContributionItem(id, menuItemProvider));
        }
        return this;
    }

    public PopupMenuBuilder withContributionItem(ContributionItem contributionItem) {
        if (this.menuManager == null) {
            throw new IllegalStateException("This PopupMenuBuilder is not created using a MenuManager, therefore ContributionItems can not be added");
        }
        this.menuManager.add((IContributionItem)contributionItem);
        return this;
    }

    public PopupMenuBuilder withHideColumnMenuItem() {
        return this.withMenuItemProvider(HIDE_COLUMN_MENU_ITEM_ID, MenuItemProviders.hideColumnMenuItemProvider());
    }

    public PopupMenuBuilder withHideColumnMenuItem(String menuLabel) {
        return this.withMenuItemProvider(HIDE_COLUMN_MENU_ITEM_ID, MenuItemProviders.hideColumnMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withShowAllColumnsMenuItem() {
        return this.withMenuItemProvider(SHOW_ALL_COLUMNS_MENU_ITEM_ID, MenuItemProviders.showAllColumnsMenuItemProvider());
    }

    public PopupMenuBuilder withShowAllColumnsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(SHOW_ALL_COLUMNS_MENU_ITEM_ID, MenuItemProviders.showAllColumnsMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withHideRowMenuItem() {
        return this.withMenuItemProvider(HIDE_ROW_MENU_ITEM_ID, MenuItemProviders.hideRowMenuItemProvider());
    }

    public PopupMenuBuilder withHideRowMenuItem(String menuLabel) {
        return this.withMenuItemProvider(HIDE_ROW_MENU_ITEM_ID, MenuItemProviders.hideRowMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withShowAllRowsMenuItem() {
        return this.withMenuItemProvider(SHOW_ALL_ROWS_MENU_ITEM_ID, MenuItemProviders.showAllRowsMenuItemProvider());
    }

    public PopupMenuBuilder withShowAllRowsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(SHOW_ALL_ROWS_MENU_ITEM_ID, MenuItemProviders.showAllRowsMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withAutoResizeSelectedColumnsMenuItem() {
        return this.withMenuItemProvider(AUTO_RESIZE_COLUMN_MENU_ITEM_ID, MenuItemProviders.autoResizeColumnMenuItemProvider());
    }

    public PopupMenuBuilder withAutoResizeSelectedColumnsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(AUTO_RESIZE_COLUMN_MENU_ITEM_ID, MenuItemProviders.autoResizeColumnMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withAutoResizeSelectedRowsMenuItem() {
        return this.withMenuItemProvider(AUTO_RESIZE_ROW_MENU_ITEM_ID, MenuItemProviders.autoResizeRowMenuItemProvider());
    }

    public PopupMenuBuilder withAutoResizeSelectedRowsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(AUTO_RESIZE_ROW_MENU_ITEM_ID, MenuItemProviders.autoResizeRowMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withColumnChooserMenuItem() {
        return this.withMenuItemProvider(COLUMN_CHOOSER_MENU_ITEM_ID, MenuItemProviders.columnChooserMenuItemProvider());
    }

    public PopupMenuBuilder withColumnChooserMenuItem(String menuLabel) {
        return this.withMenuItemProvider(COLUMN_CHOOSER_MENU_ITEM_ID, MenuItemProviders.columnChooserMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withColumnStyleEditor() {
        return this.withMenuItemProvider(COLUMN_STYLE_EDITOR_MENU_ITEM_ID, MenuItemProviders.columnStyleEditorMenuItemProvider());
    }

    public PopupMenuBuilder withColumnStyleEditor(String menuLabel) {
        return this.withMenuItemProvider(COLUMN_STYLE_EDITOR_MENU_ITEM_ID, MenuItemProviders.columnStyleEditorMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withColumnRenameDialog() {
        return this.withMenuItemProvider(COLUMN_RENAME_MENU_ITEM_ID, MenuItemProviders.renameColumnMenuItemProvider());
    }

    public PopupMenuBuilder withColumnRenameDialog(String menuLabel) {
        return this.withMenuItemProvider(COLUMN_RENAME_MENU_ITEM_ID, MenuItemProviders.renameColumnMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withCreateColumnGroupsMenuItem() {
        return this.withMenuItemProvider(CREATE_COLUMN_GROUP_MENU_ITEM_ID, MenuItemProviders.createColumnGroupMenuItemProvider());
    }

    public PopupMenuBuilder withCreateColumnGroupsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(CREATE_COLUMN_GROUP_MENU_ITEM_ID, MenuItemProviders.createColumnGroupMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withUngroupColumnsMenuItem() {
        return this.withMenuItemProvider(UNGROUP_COLUMNS_MENU_ITEM_ID, MenuItemProviders.ungroupColumnsMenuItemProvider());
    }

    public PopupMenuBuilder withUngroupColumnsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(UNGROUP_COLUMNS_MENU_ITEM_ID, MenuItemProviders.ungroupColumnsMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withRenameColumnGroupMenuItem() {
        return this.withMenuItemProvider(RENAME_COLUMN_GROUP_MENU_ITEM_ID, MenuItemProviders.renameColumnGroupMenuItemProvider());
    }

    public PopupMenuBuilder withRenameColumnGroupMenuItem(String menuLabel) {
        return this.withMenuItemProvider(RENAME_COLUMN_GROUP_MENU_ITEM_ID, MenuItemProviders.renameColumnGroupMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withRemoveColumnGroupMenuItem() {
        return this.withMenuItemProvider(REMOVE_COLUMN_GROUP_MENU_ITEM_ID, MenuItemProviders.removeColumnGroupMenuItemProvider());
    }

    public PopupMenuBuilder withRemoveColumnGroupMenuItem(String menuLabel) {
        return this.withMenuItemProvider(REMOVE_COLUMN_GROUP_MENU_ITEM_ID, MenuItemProviders.removeColumnGroupMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withInspectLabelsMenuItem() {
        return this.withMenuItemProvider(INSPECT_LABEL_MENU_ITEM_ID, MenuItemProviders.inspectLabelsMenuItemProvider());
    }

    public PopupMenuBuilder withCategoriesBasedColumnChooser() {
        return this.withMenuItemProvider(CATEGORIES_BASED_COLUMN_CHOOSER_MENU_ITEM_ID, MenuItemProviders.categoriesBasedColumnChooserMenuItemProvider());
    }

    public PopupMenuBuilder withCategoriesBasedColumnChooser(String menuLabel) {
        return this.withMenuItemProvider(CATEGORIES_BASED_COLUMN_CHOOSER_MENU_ITEM_ID, MenuItemProviders.categoriesBasedColumnChooserMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withClearAllFilters() {
        return this.withMenuItemProvider(CLEAR_ALL_FILTERS_MENU_ITEM_ID, MenuItemProviders.clearAllFiltersMenuItemProvider());
    }

    public PopupMenuBuilder withClearAllFilters(String menuLabel) {
        return this.withMenuItemProvider(CLEAR_ALL_FILTERS_MENU_ITEM_ID, MenuItemProviders.clearAllFiltersMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withToggleFilterRow() {
        return this.withMenuItemProvider(TOGGLE_FILTER_ROW_MENU_ITEM_ID, MenuItemProviders.clearToggleFilterRowMenuItemProvider());
    }

    public PopupMenuBuilder withToggleFilterRow(String menuLabel) {
        return this.withMenuItemProvider(TOGGLE_FILTER_ROW_MENU_ITEM_ID, MenuItemProviders.clearToggleFilterRowMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withStateManagerMenuItemProvider() {
        return this.withMenuItemProvider(STATE_MANAGER_MENU_ITEM_ID, MenuItemProviders.stateManagerMenuItemProvider());
    }

    public PopupMenuBuilder withStateManagerMenuItemProvider(String menuLabel) {
        return this.withMenuItemProvider(STATE_MANAGER_MENU_ITEM_ID, MenuItemProviders.stateManagerMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withSeparator() {
        return this.withSeparator(SEPARATOR_MENU_ITEM_ID);
    }

    public PopupMenuBuilder withSeparator(String id) {
        return this.withMenuItemProvider(id, MenuItemProviders.separatorMenuItemProvider());
    }

    public Menu build() {
        this.natTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PopupMenuBuilder.this.popupMenu != null && !PopupMenuBuilder.this.popupMenu.isDisposed()) {
                    PopupMenuBuilder.this.popupMenu.dispose();
                }
            }
        });
        return this.popupMenu;
    }

    public PopupMenuBuilder withVisibleState(String id, IMenuItemState state) {
        this.visibility.addMenuItemState(id, state);
        return this;
    }

    public PopupMenuBuilder withEnabledState(String id, IMenuItemState state) {
        this.enablement.addMenuItemState(id, state);
        return this;
    }

    protected class PopupContributionItem
    extends ContributionItem {
        private String id;
        private IMenuItemProvider provider;

        public PopupContributionItem(IMenuItemProvider provider) {
            this(null, provider);
        }

        public PopupContributionItem(String id, IMenuItemProvider provider) {
            this.id = id;
            this.provider = provider;
        }

        public void fill(Menu menu, int index) {
            MenuItem[] afterItems;
            List<MenuItem> beforeItems = Arrays.asList(menu.getItems());
            this.provider.addMenuItem(PopupMenuBuilder.this.natTable, menu);
            MenuItem[] menuItemArray = afterItems = menu.getItems();
            int n = afterItems.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                if (!beforeItems.contains(item)) {
                    item.setEnabled(this.isEnabled());
                }
                ++n2;
            }
        }

        public boolean isDynamic() {
            return this.id != null;
        }

        public boolean isEnabled() {
            Object eventData;
            if (this.id != null && (eventData = PopupMenuBuilder.this.popupMenu.getData("natEventData")) != null && eventData instanceof NatEventData) {
                return PopupMenuBuilder.this.enablement.isActive(this.id, (NatEventData)eventData);
            }
            return true;
        }

        public boolean isVisible() {
            Object eventData;
            if (this.id != null && (eventData = PopupMenuBuilder.this.popupMenu.getData("natEventData")) != null && eventData instanceof NatEventData) {
                return PopupMenuBuilder.this.visibility.isActive(this.id, (NatEventData)eventData);
            }
            return true;
        }
    }
}

