/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.classifier.core;

import org.eclipse.chemclipse.chromatogram.msd.classifier.core.IChromatogramClassifier;
import org.eclipse.chemclipse.chromatogram.msd.classifier.exceptions.ChromatogramSelectionException;
import org.eclipse.chemclipse.chromatogram.msd.classifier.exceptions.ClassifierSettingsException;
import org.eclipse.chemclipse.chromatogram.msd.classifier.settings.IChromatogramClassifierSettings;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;

public abstract class AbstractChromatogramClassifier
implements IChromatogramClassifier {
    public void validate(IChromatogramSelectionMSD chromatogramSelection, IChromatogramClassifierSettings chromatogramClassifierSettings) throws ChromatogramSelectionException, ClassifierSettingsException {
        this.validateChromatogramSelection(chromatogramSelection);
        this.validateClassifierSettings(chromatogramClassifierSettings);
    }

    private void validateChromatogramSelection(IChromatogramSelectionMSD chromatogramSelection) throws ChromatogramSelectionException {
        if (chromatogramSelection == null) {
            throw new ChromatogramSelectionException("The chromatogram selection must not be null.");
        }
        if (chromatogramSelection.getChromatogram() == null) {
            throw new ChromatogramSelectionException("The chromatogram must not be null.");
        }
    }

    private void validateClassifierSettings(IChromatogramClassifierSettings chromatogramClassifierSettings) throws ClassifierSettingsException {
        if (chromatogramClassifierSettings == null) {
            throw new ClassifierSettingsException("The classifier settings must not be null.");
        }
    }
}

