/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.xpass.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.AbstractMassSpectrumFilter;
import org.eclipse.chemclipse.chromatogram.msd.filter.processing.IMassSpectrumFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.filter.processing.MassSpectrumFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.filter.result.IMassSpectrumFilterResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.result.MassSpectrumFilterResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.settings.IMassSpectrumFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.xpass.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.xpass.settings.IXPassMassSpectrumFilterSettings;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.comparator.IonAbundanceComparator;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public class LowPassMassSpectrumFilter
extends AbstractMassSpectrumFilter {
    private static final String DESCRIPTION = "Low Pass Mass Spectrum Filter";

    public IMassSpectrumFilterProcessingInfo applyFilter(List<IScanMSD> massSpectra, IMassSpectrumFilterSettings massSpectrumFilterSettings, IProgressMonitor monitor) {
        MassSpectrumFilterProcessingInfo processingInfo = new MassSpectrumFilterProcessingInfo();
        processingInfo.addMessages(this.validate(massSpectra, massSpectrumFilterSettings));
        if (processingInfo.hasErrorMessages()) {
            return processingInfo;
        }
        if (massSpectrumFilterSettings instanceof IXPassMassSpectrumFilterSettings) {
            IXPassMassSpectrumFilterSettings xpassMassSpectrumFilterSettings = (IXPassMassSpectrumFilterSettings)massSpectrumFilterSettings;
            int numberLowest = xpassMassSpectrumFilterSettings.getNumberLowest();
            for (IScanMSD massSpectrum : massSpectra) {
                List ions = massSpectrum.getIons();
                Collections.sort(ions, new IonAbundanceComparator(SortOrder.ASC));
                ArrayList<IIon> ionsToRemove = new ArrayList<IIon>();
                int counter = 0;
                for (IIon ion : ions) {
                    if (counter >= numberLowest) {
                        ionsToRemove.add(ion);
                    }
                    ++counter;
                }
                ions.removeAll(ionsToRemove);
            }
            processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, DESCRIPTION, "The mass spectrum has been optimized successfully."));
        } else {
            processingInfo.addErrorMessage(DESCRIPTION, "The filter settings instance is not a type of: " + IXPassMassSpectrumFilterSettings.class);
        }
        MassSpectrumFilterResult massSpectrumFilterResult = new MassSpectrumFilterResult(ResultStatus.OK, "The low pass filter has been applied successfully.");
        processingInfo.setMassSpectrumFilterResult((IMassSpectrumFilterResult)massSpectrumFilterResult);
        return processingInfo;
    }

    public IMassSpectrumFilterProcessingInfo applyFilter(IScanMSD massSpectrum, IMassSpectrumFilterSettings massSpectrumFilterSettings, IProgressMonitor monitor) {
        ArrayList<IScanMSD> massSpectra = new ArrayList<IScanMSD>();
        massSpectra.add(massSpectrum);
        return this.applyFilter(massSpectra, massSpectrumFilterSettings, monitor);
    }

    public IMassSpectrumFilterProcessingInfo applyFilter(IScanMSD massSpectrum, IProgressMonitor monitor) {
        ArrayList<IScanMSD> massSpectra = new ArrayList<IScanMSD>();
        massSpectra.add(massSpectrum);
        IXPassMassSpectrumFilterSettings massSpectrumFilterSettings = PreferenceSupplier.getMassSpectrumFilterSettings();
        return this.applyFilter(massSpectra, (IMassSpectrumFilterSettings)massSpectrumFilterSettings, monitor);
    }

    public IMassSpectrumFilterProcessingInfo applyFilter(List<IScanMSD> massSpectra, IProgressMonitor monitor) {
        IXPassMassSpectrumFilterSettings massSpectrumFilterSettings = PreferenceSupplier.getMassSpectrumFilterSettings();
        return this.applyFilter(massSpectra, (IMassSpectrumFilterSettings)massSpectrumFilterSettings, monitor);
    }
}

