/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.numeric.equations;

import org.eclipse.chemclipse.numeric.equations.IEquation;

public class LinearEquation
implements IEquation {
    private static final long serialVersionUID = -7941955423018899201L;
    private double a;
    private double b;

    public LinearEquation(double a, double b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public double calculateX(double y) {
        if (this.a == 0.0) {
            return Double.NaN;
        }
        return (y - this.b) / this.a;
    }

    @Override
    public double calculateY(double x) {
        return this.a * x + this.b;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        LinearEquation otherEquation = (LinearEquation)other;
        return this.getA() == otherEquation.getA() && this.getB() == otherEquation.getB();
    }

    public int hashCode() {
        return 7 * Double.valueOf(this.a).hashCode() + 11 * Double.valueOf(this.b).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("f(x)=" + this.a + "x" + " + " + this.b);
        builder.append("]");
        return builder.toString();
    }
}

