/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.ui.views;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.ui.preferences.PreferencePage;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.swt.ui.components.chromatogram.MultipleChromatogramOffsetUI;
import org.eclipse.chemclipse.swt.ui.preferences.SWTPreferencePage;
import org.eclipse.chemclipse.swt.ui.support.AxisTitlesIntensityScale;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.chemclipse.swt.ui.support.IOffset;
import org.eclipse.chemclipse.swt.ui.support.Offset;
import org.eclipse.chemclipse.ux.extension.xxd.ui.views.AbstractChromatogramOverlayView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ChromatogramOverlayView
extends AbstractChromatogramOverlayView {
    private static final Offset LOCK_OFFSET = new Offset(0.0, 0.0);
    @Inject
    private Composite composite;
    private MultipleChromatogramOffsetUI chromatogramOverlayUI;
    private Shell shell = Display.getCurrent().getActiveShell();
    private Cursor cursor = this.shell.getCursor();
    private Button buttonLockOffset;
    private Button buttonOffsetLeft;
    private Button buttonOffsetLeftFast;
    private Button buttonOffsetRight;
    private Button buttonOffsetRightFast;
    private Button buttonOffsetUp;
    private Button buttonOffsetDown;
    private Label labelStatusDataDisplay;
    private Label labelStatusLockOffset;

    @Inject
    public ChromatogramOverlayView(EPartService partService, MPart part, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
    }

    @PostConstruct
    private void createControl() {
        this.composite.setLayout((Layout)new GridLayout(4, false));
        this.createButtonBar(this.composite);
        this.createOverlayChart(this.composite);
    }

    private void createButtonBar(Composite composite) {
        Composite compositeLeft = new Composite(composite, 0);
        compositeLeft.setLayoutData((Object)new GridData(768));
        compositeLeft.setLayout((Layout)new GridLayout(1, false));
        Composite compositeCenter = new Composite(composite, 0);
        compositeCenter.setLayoutData((Object)new GridData(768));
        compositeCenter.setLayout((Layout)new GridLayout(1, false));
        Composite compositeRight = new Composite(composite, 0);
        GridData gridDataCompositeRight = new GridData(768);
        gridDataCompositeRight.horizontalAlignment = 0x1000008;
        compositeRight.setLayoutData((Object)gridDataCompositeRight);
        compositeRight.setLayout((Layout)new GridLayout(9, false));
        this.createButtonsCenterLeft(compositeLeft);
        this.createButtonsCenterRight(compositeCenter);
        this.createButtonsRight(compositeRight);
        this.setWidgetStatus();
    }

    private void createButtonsCenterLeft(Composite composite) {
        this.labelStatusDataDisplay = new Label(composite, 0);
        this.labelStatusDataDisplay.setText("");
        this.labelStatusDataDisplay.setLayoutData((Object)new GridData(768));
    }

    private void createButtonsCenterRight(Composite composite) {
        this.labelStatusLockOffset = new Label(composite, 0);
        this.labelStatusLockOffset.setText("");
        this.labelStatusLockOffset.setLayoutData((Object)new GridData(768));
    }

    private void createButtonsRight(Composite composite) {
        this.createButtonLockOffset(composite);
        this.createButtonSettings(composite);
        this.createButtonReset(composite);
        this.createButtonOffsetLeft(composite);
        this.createButtonOffsetLeftFast(composite);
        this.createButtonOffsetRight(composite);
        this.createButtonOffsetRightFast(composite);
        this.createButtonOffsetUp(composite);
        this.createButtonOffsetDown(composite);
    }

    private void createButtonLockOffset(Composite composite) {
        this.buttonLockOffset = new Button(composite, 8);
        this.buttonLockOffset.setText("");
        this.buttonLockOffset.setToolTipText("Lock the offset");
        this.buttonLockOffset.setImage(ApplicationImageFactory.getInstance().getImage("lockOffset.gif", "16x16"));
        this.buttonLockOffset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceSupplier.toggleLockOffset();
                ChromatogramOverlayView.this.setLockOffset();
                ChromatogramOverlayView.this.update(ChromatogramOverlayView.this.getChromatogramSelection(), true);
            }
        });
    }

    private void createButtonSettings(Composite composite) {
        Button buttonSettings = new Button(composite, 8);
        buttonSettings.setText("");
        buttonSettings.setToolTipText("Open Settings");
        buttonSettings.setImage(ApplicationImageFactory.getInstance().getImage("configure.gif", "16x16"));
        buttonSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTPreferencePage preferencePage = new SWTPreferencePage();
                preferencePage.setTitle("Display Settings");
                PreferencePage preferencePageOverlay = new PreferencePage();
                preferencePageOverlay.setTitle("RT Shifter/Offset settings");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePage));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)preferencePageOverlay));
                PreferenceDialog preferenceDialog = new PreferenceDialog(Display.getCurrent().getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Overlay/Shifter Settings");
                if (preferenceDialog.open() == 0) {
                    ChromatogramOverlayView.this.update(ChromatogramOverlayView.this.getChromatogramSelection(), false);
                }
            }
        });
    }

    private void createButtonReset(Composite composite) {
        Button buttonReset = new Button(composite, 8);
        buttonReset.setText("");
        buttonReset.setToolTipText("Reset Settings");
        buttonReset.setImage(ApplicationImageFactory.getInstance().getImage("reset.gif", "16x16"));
        buttonReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramOverlayView.this.resetOffsets();
                ChromatogramOverlayView.this.update(ChromatogramOverlayView.this.getChromatogramSelection(), false);
            }
        });
    }

    private void createButtonOffsetLeft(Composite composite) {
        this.buttonOffsetLeft = new Button(composite, 8);
        this.buttonOffsetLeft.setText("");
        this.buttonOffsetLeft.setToolTipText("Move left");
        this.buttonOffsetLeft.setImage(ApplicationImageFactory.getInstance().getImage("offsetLeft.gif", "16x16"));
        this.buttonOffsetLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramOverlayView.this.setWaitCursor();
                PreferenceSupplier.decreaseXOffset();
                ChromatogramOverlayView.this.setXLockedOffsetConditionally();
                ChromatogramOverlayView.this.update(ChromatogramOverlayView.this.getChromatogramSelection(), false);
                ChromatogramOverlayView.this.setDefaultCursor();
            }
        });
    }

    private void createButtonOffsetLeftFast(Composite composite) {
        this.buttonOffsetLeftFast = new Button(composite, 8);
        this.buttonOffsetLeftFast.setText("");
        this.buttonOffsetLeftFast.setToolTipText("Move left fast");
        this.buttonOffsetLeftFast.setImage(ApplicationImageFactory.getInstance().getImage("offsetLeftFast.gif", "16x16"));
        this.buttonOffsetLeftFast.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramOverlayView.this.setWaitCursor();
                PreferenceSupplier.decreaseXOffsetFast();
                ChromatogramOverlayView.this.setXLockedOffsetConditionally();
                ChromatogramOverlayView.this.update(ChromatogramOverlayView.this.getChromatogramSelection(), false);
                ChromatogramOverlayView.this.setDefaultCursor();
            }
        });
    }

    private void createButtonOffsetRight(Composite composite) {
        this.buttonOffsetRight = new Button(composite, 8);
        this.buttonOffsetRight.setText("");
        this.buttonOffsetRight.setToolTipText("Move right");
        this.buttonOffsetRight.setImage(ApplicationImageFactory.getInstance().getImage("offsetRight.gif", "16x16"));
        this.buttonOffsetRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramOverlayView.this.setWaitCursor();
                PreferenceSupplier.increaseXOffset();
                ChromatogramOverlayView.this.setXLockedOffsetConditionally();
                ChromatogramOverlayView.this.update(ChromatogramOverlayView.this.getChromatogramSelection(), false);
                ChromatogramOverlayView.this.setDefaultCursor();
            }
        });
    }

    private void createButtonOffsetRightFast(Composite composite) {
        this.buttonOffsetRightFast = new Button(composite, 8);
        this.buttonOffsetRightFast.setText("");
        this.buttonOffsetRightFast.setToolTipText("Move right fast");
        this.buttonOffsetRightFast.setImage(ApplicationImageFactory.getInstance().getImage("offsetRightFast.gif", "16x16"));
        this.buttonOffsetRightFast.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramOverlayView.this.setWaitCursor();
                PreferenceSupplier.increaseXOffsetFast();
                ChromatogramOverlayView.this.setXLockedOffsetConditionally();
                ChromatogramOverlayView.this.update(ChromatogramOverlayView.this.getChromatogramSelection(), false);
                ChromatogramOverlayView.this.setDefaultCursor();
            }
        });
    }

    private void createButtonOffsetUp(Composite composite) {
        this.buttonOffsetUp = new Button(composite, 8);
        this.buttonOffsetUp.setText("");
        this.buttonOffsetUp.setToolTipText("Move up");
        this.buttonOffsetUp.setImage(ApplicationImageFactory.getInstance().getImage("offsetUp.gif", "16x16"));
        this.buttonOffsetUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramOverlayView.this.setWaitCursor();
                PreferenceSupplier.increaseYOffset();
                ChromatogramOverlayView.this.setYLockedOffsetConditionally();
                ChromatogramOverlayView.this.update(ChromatogramOverlayView.this.getChromatogramSelection(), false);
                ChromatogramOverlayView.this.setDefaultCursor();
            }
        });
    }

    private void createButtonOffsetDown(Composite composite) {
        this.buttonOffsetDown = new Button(composite, 8);
        this.buttonOffsetDown.setText("");
        this.buttonOffsetDown.setToolTipText("Move down");
        this.buttonOffsetDown.setImage(ApplicationImageFactory.getInstance().getImage("offsetDown.gif", "16x16"));
        this.buttonOffsetDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramOverlayView.this.setWaitCursor();
                PreferenceSupplier.decreaseYOffset();
                ChromatogramOverlayView.this.setYLockedOffsetConditionally();
                ChromatogramOverlayView.this.update(ChromatogramOverlayView.this.getChromatogramSelection(), false);
                ChromatogramOverlayView.this.setDefaultCursor();
            }
        });
    }

    private void createOverlayChart(Composite composite) {
        this.chromatogramOverlayUI = new MultipleChromatogramOffsetUI(composite, 0, (IAxisTitles)new AxisTitlesIntensityScale());
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        this.chromatogramOverlayUI.setLayoutData((Object)gridData);
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.chromatogramOverlayUI.setFocus();
        this.update(this.getChromatogramSelection(), false);
    }

    public void update(IChromatogramSelection chromatogramSelection, boolean forceReload) {
        if (this.doUpdate(chromatogramSelection)) {
            this.setWidgetStatus();
            this.setChromatogramOverlayOffset();
            List chromatogramSelections = this.getChromatogramSelections(chromatogramSelection, false);
            this.chromatogramOverlayUI.updateSelection(chromatogramSelections, forceReload);
        }
    }

    private void setWidgetStatus() {
        int xOffset = PreferenceSupplier.getOverlayXOffset();
        int yOffset = PreferenceSupplier.getOverlayYOffset();
        boolean isLockOffset = PreferenceSupplier.isLockOffset();
        if (xOffset == 0 && yOffset == 0) {
            this.labelStatusDataDisplay.setText("DISPLAY ORIGINAL");
            this.labelStatusDataDisplay.setBackground(Colors.GREEN);
        } else {
            this.labelStatusDataDisplay.setText("DISPLAY SHIFTED");
            this.labelStatusDataDisplay.setBackground(Colors.YELLOW);
        }
        if (isLockOffset) {
            this.buttonLockOffset.setImage(ApplicationImageFactory.getInstance().getImage("unlockOffset.gif", "16x16"));
            this.labelStatusLockOffset.setText("LOCKED OFFSET");
            this.labelStatusLockOffset.setBackground(Colors.YELLOW);
        } else {
            this.buttonLockOffset.setImage(ApplicationImageFactory.getInstance().getImage("lockOffset.gif", "16x16"));
            this.labelStatusLockOffset.setText("DYNAMIC OFFSET");
            this.labelStatusLockOffset.setBackground(Colors.GREEN);
        }
        this.buttonOffsetLeft.setEnabled(true);
        this.buttonOffsetLeftFast.setEnabled(true);
        this.buttonOffsetRight.setEnabled(true);
        this.buttonOffsetRightFast.setEnabled(true);
        this.buttonLockOffset.setEnabled(true);
        this.buttonOffsetUp.setEnabled(true);
        this.buttonOffsetDown.setEnabled(true);
        this.labelStatusLockOffset.setEnabled(true);
    }

    private void setChromatogramOverlayOffset() {
        if (this.buttonLockOffset.getSelection()) {
            this.chromatogramOverlayUI.setOffset((IOffset)LOCK_OFFSET);
        } else {
            int xOffset = PreferenceSupplier.getOverlayXOffset();
            int yOffset = PreferenceSupplier.getOverlayYOffset();
            Offset offset = new Offset((double)xOffset, (double)yOffset);
            this.chromatogramOverlayUI.setOffset((IOffset)offset);
        }
    }

    private void setWaitCursor() {
        this.shell.setCursor(Display.getCurrent().getSystemCursor(1));
    }

    private void setDefaultCursor() {
        this.shell.setCursor(this.cursor);
    }

    private void setXLockedOffsetConditionally() {
        if (PreferenceSupplier.isLockOffset()) {
            int xOffset = PreferenceSupplier.getOverlayXOffset();
            List chromatogramSelections = this.getChromatogramSelections(this.getChromatogramSelection(), false);
            int x = 0;
            for (IChromatogramSelection chromatogramSelection : chromatogramSelections) {
                chromatogramSelection.getOffset().setX((double)x);
                x += xOffset;
            }
        }
    }

    private void setYLockedOffsetConditionally() {
        if (PreferenceSupplier.isLockOffset()) {
            int yOffset = PreferenceSupplier.getOverlayYOffset();
            List chromatogramSelections = this.getChromatogramSelections(this.getChromatogramSelection(), false);
            int y = 0;
            for (IChromatogramSelection chromatogramSelection : chromatogramSelections) {
                chromatogramSelection.getOffset().setY((double)y);
                y += yOffset;
            }
        }
    }

    private void setLockOffset() {
        boolean isLockOffset = PreferenceSupplier.isLockOffset();
        List chromatogramSelections = this.getChromatogramSelections(this.getChromatogramSelection(), false);
        for (IChromatogramSelection chromatogramSelection : chromatogramSelections) {
            chromatogramSelection.setLockOffset(isLockOffset);
        }
    }

    private void resetOffsets() {
        PreferenceSupplier.resetOffset();
        List chromatogramSelections = this.getChromatogramSelections(this.getChromatogramSelection(), false);
        for (IChromatogramSelection chromatogramSelection : chromatogramSelections) {
            chromatogramSelection.resetOffset();
        }
    }
}

