/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.DefaultComparator;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByDataLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByObject;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.IGroupByComparator;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.summary.IGroupBySummaryProvider;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;

public class GroupByComparator<T>
implements IGroupByComparator<T> {
    protected final GroupByModel groupByModel;
    protected final IColumnAccessor<T> columnAccessor;
    protected ISortModel sortModel;
    protected IUniqueIndexLayer treeLayer;
    private GroupByDataLayer<T> dataLayer;
    protected Map<Integer, Boolean> summaryColumnCache = new HashMap<Integer, Boolean>();
    protected Map<GroupByObject, GroupByObjectValueCache> groupByObjectComparatorCache = new HashMap<GroupByObject, GroupByObjectValueCache>();

    public GroupByComparator(GroupByModel groupByModel, IColumnAccessor<T> columnAccessor) {
        this.groupByModel = groupByModel;
        this.columnAccessor = columnAccessor;
    }

    public GroupByComparator(GroupByModel groupByModel, IColumnAccessor<T> columnAccessor, GroupByDataLayer<T> dataLayer) {
        this.groupByModel = groupByModel;
        this.columnAccessor = columnAccessor;
        this.dataLayer = dataLayer;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        int result = 0;
        for (int columnIndex : this.groupByModel.getGroupByColumnIndexes()) {
            if (o1 instanceof GroupByObject && o2 instanceof GroupByObject) {
                GroupByObject g1 = (GroupByObject)o1;
                GroupByObject g2 = (GroupByObject)o2;
                int groupByIndex = columnIndex;
                for (Map.Entry<Integer, Object> entry : g1.getDescriptor().entrySet()) {
                    groupByIndex = entry.getKey();
                }
                Comparator comparator = this.getComparator(groupByIndex);
                result = g1.getDescriptor().size() - g2.getDescriptor().size();
                if (result == 0) {
                    if (this.sortModel != null && this.sortModel.getSortedColumnIndexes() != null && !this.sortModel.getSortedColumnIndexes().isEmpty()) {
                        Iterator iterator = this.sortModel.getSortedColumnIndexes().iterator();
                        while (iterator.hasNext()) {
                            int sortColumnIndex = (Integer)iterator.next();
                            Boolean summaryColumn = this.isSummaryColumn(g1, sortColumnIndex);
                            if (summaryColumn == null) {
                                summaryColumn = this.isSummaryColumn(g2, sortColumnIndex);
                            }
                            if (summaryColumn != null && summaryColumn.booleanValue()) {
                                Object sumValue1 = this.getSummaryValueFromCache(g1, sortColumnIndex);
                                Object sumValue2 = this.getSummaryValueFromCache(g2, sortColumnIndex);
                                result = this.getComparator(sortColumnIndex).compare(sumValue1, sumValue2);
                            }
                            if (result == 0) {
                                result = comparator.compare(g1.getValue(), g2.getValue());
                            }
                            if (!this.isTreeColumn(sortColumnIndex) && !summaryColumn.booleanValue() || !this.sortModel.getSortDirection(sortColumnIndex).equals((Object)SortDirectionEnum.DESC)) continue;
                            result *= -1;
                        }
                    } else {
                        result = comparator.compare(g1.getValue(), g2.getValue());
                    }
                    return result;
                }
            } else if (o1 instanceof GroupByObject && !(o2 instanceof GroupByObject)) {
                result = 1;
            } else if (!(o1 instanceof GroupByObject) && o2 instanceof GroupByObject) {
                result = -1;
            } else {
                Object value1 = this.columnAccessor.getDataValue(o1, columnIndex);
                Object value2 = this.columnAccessor.getDataValue(o2, columnIndex);
                result = this.getComparator(columnIndex).compare(value1, value2);
            }
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    protected boolean isTreeColumn(int columnIndex) {
        int columnPosition;
        ILayerCell cell;
        if (this.treeLayer != null && (cell = this.treeLayer.getCellByPosition(columnPosition = this.treeLayer.getColumnPositionByIndex(columnIndex), 0)) != null) {
            return cell.getConfigLabels().hasLabel("TREE_COLUMN_CELL");
        }
        return false;
    }

    protected Comparator getComparator(int columnIndex) {
        Object result = null;
        if (this.sortModel != null) {
            result = this.sortModel.getColumnComparator(columnIndex);
        }
        if (result == null) {
            result = DefaultComparator.getInstance();
        }
        return result;
    }

    @Override
    public ISortModel getSortModel() {
        return this.sortModel;
    }

    @Override
    public void setSortModel(ISortModel sortModel) {
        this.sortModel = sortModel;
    }

    @Override
    public void setTreeLayer(IUniqueIndexLayer treeLayer) {
        this.treeLayer = treeLayer;
    }

    @Override
    public void setDataLayer(GroupByDataLayer<T> dataLayer) {
        this.dataLayer = dataLayer;
    }

    @Override
    public void clearCache() {
        this.summaryColumnCache.clear();
        this.groupByObjectComparatorCache.clear();
    }

    protected Boolean isSummaryColumn(GroupByObject groupBy, int columnIndex) {
        if (!this.summaryColumnCache.containsKey(columnIndex)) {
            this.getSummaryValueFromCache(groupBy, columnIndex);
        }
        return this.summaryColumnCache.get(columnIndex);
    }

    protected Object getSummaryValueFromCache(GroupByObject groupBy, int columnIndex) {
        Object columnCache = null;
        if (this.dataLayer != null) {
            int rowIndex;
            GroupByObjectValueCache cache = this.groupByObjectComparatorCache.get(groupBy);
            if (cache == null) {
                cache = new GroupByObjectValueCache();
                this.groupByObjectComparatorCache.put(groupBy, cache);
            }
            if ((columnCache = cache.valueCache.get(columnIndex)) == null && (rowIndex = this.dataLayer.getTreeList().indexOf((Object)groupBy)) >= 0) {
                LabelStack labelStack = this.dataLayer.getConfigLabelsByPosition(columnIndex, rowIndex);
                IGroupBySummaryProvider<T> provider = this.dataLayer.getGroupBySummaryProvider(labelStack);
                boolean isSummaryColumn = provider != null;
                this.summaryColumnCache.put(columnIndex, isSummaryColumn);
                if (isSummaryColumn) {
                    Map.Entry<Integer, Object> last = null;
                    Iterator<Map.Entry<Integer, Object>> iterator = groupBy.getDescriptor().entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<Integer, Object> entry;
                        last = entry = iterator.next();
                    }
                    columnCache = last != null && (Integer)last.getKey() == columnIndex ? groupBy.getValue() : this.dataLayer.getDataValueByPosition(columnIndex, rowIndex, labelStack, false);
                    cache.valueCache.put(columnIndex, columnCache);
                }
            }
        } else {
            this.summaryColumnCache.put(columnIndex, false);
        }
        return columnCache;
    }

    class GroupByObjectValueCache {
        Map<Integer, Object> valueCache = new HashMap<Integer, Object>();

        GroupByObjectValueCache() {
        }
    }
}

