/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.support;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.swt.ui.support.ColorScheme;
import org.eclipse.chemclipse.swt.ui.support.IColorScheme;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class Colors {
    public static final Color WHITE = Display.getCurrent().getSystemColor(1);
    public static final Color RED = Display.getCurrent().getSystemColor(3);
    public static final Color BLACK = Display.getCurrent().getSystemColor(2);
    public static final Color DARK_RED = Display.getCurrent().getSystemColor(4);
    public static final Color GREEN = Display.getCurrent().getSystemColor(5);
    public static final Color GRAY = Display.getCurrent().getSystemColor(15);
    public static final Color DARK_GRAY = Display.getCurrent().getSystemColor(16);
    public static final Color DARK_CYAN = Display.getCurrent().getSystemColor(14);
    public static final Color DARK_YELLOW = Display.getCurrent().getSystemColor(8);
    public static final Color DARK_GREEN = Display.getCurrent().getSystemColor(6);
    public static final Color BLUE = Display.getCurrent().getSystemColor(9);
    public static final Color MAGENTA = Display.getCurrent().getSystemColor(11);
    public static final Color YELLOW = Display.getCurrent().getSystemColor(7);
    public static final String COLOR_SCHEME_RED = "Red";
    private static final int[] colorIdsGradientRed;
    private static List<Color> colorsGradientRed;
    public static final String COLOR_SCHEME_GRADIENT = "Gradient";
    private static final int[] colorIdsGradient;
    private static List<Color> colorsGradient;
    public static final String COLOR_SCHEME_RED_CONTRAST = "Red Contrast";
    private static final int[] colorIdsGradientRedContrast;
    private static List<Color> colorsGradientRedContrast;
    public static final String COLOR_SCHEME_HIGH_CONTRAST = "High Contrast";
    private static final int[] colorIdsGradientHighContrast;
    private static List<Color> colorsGradientHighContrast;
    public static final String COLOR_SCHEME_PUBLICATION = "Publication";
    private static final RGB[] colorIdsGradientPublication;
    private static List<Color> colorsGradientPublication;

    static {
        int[] nArray = new int[7];
        nArray[0] = 255;
        nArray[2] = 45;
        nArray[3] = 85;
        nArray[4] = 125;
        nArray[5] = 165;
        nArray[6] = 205;
        colorIdsGradientRed = nArray;
        colorIdsGradient = new int[]{3, 2, 16, 6, 14, 8, 12, 10};
        int[] nArray2 = new int[4];
        nArray2[0] = 255;
        nArray2[2] = 85;
        nArray2[3] = 165;
        colorIdsGradientRedContrast = nArray2;
        colorIdsGradientHighContrast = new int[]{9, 13, 15, 11, 5, 2, 8, 3};
        colorIdsGradientPublication = new RGB[]{new RGB(255, 0, 0), new RGB(0, 255, 0), new RGB(0, 0, 255), new RGB(150, 0, 0), new RGB(0, 150, 0), new RGB(0, 0, 150)};
        Colors.initializeColors();
    }

    public static String[][] getAvailableColorSchemes() {
        String[][] elements = new String[5][2];
        elements[0][0] = COLOR_SCHEME_RED;
        elements[0][1] = COLOR_SCHEME_RED;
        elements[1][0] = COLOR_SCHEME_RED_CONTRAST;
        elements[1][1] = COLOR_SCHEME_RED_CONTRAST;
        elements[2][0] = COLOR_SCHEME_GRADIENT;
        elements[2][1] = COLOR_SCHEME_GRADIENT;
        elements[3][0] = COLOR_SCHEME_HIGH_CONTRAST;
        elements[3][1] = COLOR_SCHEME_HIGH_CONTRAST;
        elements[4][0] = COLOR_SCHEME_PUBLICATION;
        elements[4][1] = COLOR_SCHEME_PUBLICATION;
        return elements;
    }

    public static IColorScheme getColorScheme() {
        String colorSchemeOverlay = PreferenceSupplier.getColorSchemeOverlay();
        return Colors.getColorScheme(colorSchemeOverlay);
    }

    public static IColorScheme getColorScheme(String colorScheme) {
        if (COLOR_SCHEME_GRADIENT.equals(colorScheme)) {
            return new ColorScheme(colorsGradient);
        }
        if (COLOR_SCHEME_RED_CONTRAST.equals(colorScheme)) {
            return new ColorScheme(colorsGradientRedContrast);
        }
        if (COLOR_SCHEME_HIGH_CONTRAST.equals(colorScheme)) {
            return new ColorScheme(colorsGradientHighContrast);
        }
        if (COLOR_SCHEME_PUBLICATION.equals(colorScheme)) {
            return new ColorScheme(colorsGradientPublication);
        }
        return new ColorScheme(colorsGradientRed);
    }

    private static void initializeColors() {
        Color color;
        int colorId;
        Display display = Display.getCurrent();
        colorsGradientRed = new ArrayList<Color>();
        Object[] objectArray = colorIdsGradientRed;
        int n = colorIdsGradientRed.length;
        int n2 = 0;
        while (n2 < n) {
            colorId = objectArray[n2];
            color = new Color((Device)display, colorId, 0, 0);
            colorsGradientRed.add(color);
            ++n2;
        }
        colorsGradient = new ArrayList<Color>();
        objectArray = colorIdsGradient;
        n = colorIdsGradient.length;
        n2 = 0;
        while (n2 < n) {
            colorId = objectArray[n2];
            color = display.getSystemColor(colorId);
            colorsGradient.add(color);
            ++n2;
        }
        colorsGradientRedContrast = new ArrayList<Color>();
        objectArray = colorIdsGradientRedContrast;
        n = colorIdsGradientRedContrast.length;
        n2 = 0;
        while (n2 < n) {
            colorId = objectArray[n2];
            color = new Color((Device)display, colorId, 0, 0);
            colorsGradientRedContrast.add(color);
            ++n2;
        }
        colorsGradientHighContrast = new ArrayList<Color>();
        objectArray = colorIdsGradientHighContrast;
        n = colorIdsGradientHighContrast.length;
        n2 = 0;
        while (n2 < n) {
            colorId = objectArray[n2];
            color = display.getSystemColor(colorId);
            colorsGradientHighContrast.add(color);
            ++n2;
        }
        colorsGradientPublication = new ArrayList<Color>();
        objectArray = colorIdsGradientPublication;
        n = colorIdsGradientPublication.length;
        n2 = 0;
        while (n2 < n) {
            int rgb = objectArray[n2];
            color = new Color((Device)display, (RGB)rgb);
            colorsGradientPublication.add(color);
            ++n2;
        }
    }
}

