/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.provider;

import java.io.File;
import java.util.List;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.ux.extension.ui.provider.ExplorerListSupport;
import org.eclipse.chemclipse.ux.extension.ui.provider.IChromatogramIdentifier;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class ChromatogramFileExplorerLabelProvider
extends LabelProvider
implements ILabelProvider,
IDescriptionProvider {
    private List<? extends IChromatogramIdentifier> chromatogramIdentifierList;

    public ChromatogramFileExplorerLabelProvider(IChromatogramIdentifier chromatogramIdentifier) {
        this(ExplorerListSupport.getChromatogramIdentifierList(chromatogramIdentifier));
    }

    public ChromatogramFileExplorerLabelProvider(List<? extends IChromatogramIdentifier> chromatogramIdentifierList) {
        this.chromatogramIdentifierList = chromatogramIdentifierList;
    }

    public String getDescription(Object anElement) {
        if (anElement instanceof File) {
            File file = (File)anElement;
            String name = file.getName().equals("") ? file.getAbsolutePath() : file.getName();
            return "This is: " + name;
        }
        return "";
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor = null;
        if (element instanceof File) {
            File file = (File)element;
            if (file.getName().equals("")) {
                descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("drive.gif", "16x16");
            } else if (file.isDirectory()) {
                boolean isNormalDirectory = true;
                for (IChromatogramIdentifier iChromatogramIdentifier : this.chromatogramIdentifierList) {
                    if (!iChromatogramIdentifier.isChromatogramDirectory(file) || !iChromatogramIdentifier.isMatchMagicNumber(file) || (descriptor = this.getImageDescriptor(iChromatogramIdentifier, file)) == null) continue;
                    isNormalDirectory = false;
                    break;
                }
                if (isNormalDirectory) {
                    descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("folder_opened.gif", "16x16");
                }
            } else {
                boolean isNormalFile = true;
                for (IChromatogramIdentifier iChromatogramIdentifier : this.chromatogramIdentifierList) {
                    if (!iChromatogramIdentifier.isChromatogram(file) || !iChromatogramIdentifier.isMatchMagicNumber(file) || (descriptor = this.getImageDescriptor(iChromatogramIdentifier, file)) == null) continue;
                    isNormalFile = false;
                    break;
                }
                if (isNormalFile) {
                    descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("file.gif", "16x16");
                }
            }
            Image image = descriptor.createImage();
            return image;
        }
        return null;
    }

    private ImageDescriptor getImageDescriptor(IChromatogramIdentifier chromatogramIdentifier, File file) {
        ImageDescriptor descriptor;
        block13: {
            descriptor = null;
            if (chromatogramIdentifier == null) break block13;
            switch (chromatogramIdentifier.getType()) {
                case "MSD": {
                    descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("chromatogram-msd.gif", "16x16");
                    break;
                }
                case "CSD": {
                    descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("chromatogram-csd.gif", "16x16");
                    break;
                }
                case "WSD": {
                    descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("chromatogram-wsd.gif", "16x16");
                    break;
                }
                default: {
                    descriptor = file.isDirectory() ? ApplicationImageFactory.getInstance().getImageDescriptor("folder_opened.gif", "16x16") : (file.isFile() ? ApplicationImageFactory.getInstance().getImageDescriptor("file.gif", "16x16") : ApplicationImageFactory.getInstance().getImageDescriptor("question.gif", "16x16"));
                }
            }
        }
        return descriptor;
    }

    public String getText(Object element) {
        if (element instanceof File) {
            File file = (File)element;
            String name = file.getName().equals("") ? file.getAbsolutePath() : file.getName();
            return name;
        }
        return "";
    }
}

