/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core;

import org.eclipse.chemclipse.model.core.AbstractPeak;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;

public abstract class AbstractPeakMSD
extends AbstractPeak
implements IPeakMSD {
    private static final long serialVersionUID = 4889978678251526852L;
    private final IPeakModelMSD peakModel;

    public AbstractPeakMSD(IPeakModelMSD peakModel) throws IllegalArgumentException {
        this.validatePeakModel(peakModel);
        this.peakModel = peakModel;
    }

    public AbstractPeakMSD(IPeakModelMSD peakModel, String modelDescription) throws IllegalArgumentException {
        this(peakModel);
        this.setModelDescription(modelDescription);
    }

    @Override
    public IPeakModelMSD getPeakModel() {
        return this.peakModel;
    }

    @Override
    public IPeakMassSpectrum getExtractedMassSpectrum() {
        return this.peakModel.getPeakMassSpectrum();
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        AbstractPeakMSD other = (AbstractPeakMSD)otherObject;
        return this.peakModel.equals(other.getPeakModel());
    }

    public int hashCode() {
        return 7 * this.peakModel.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("peakModel=" + this.peakModel);
        builder.append("]");
        return builder.toString();
    }
}

