/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.identifier;

import org.eclipse.chemclipse.model.identifier.IComparisonResult;

public abstract class AbstractComparisonResult
implements IComparisonResult {
    private static final long serialVersionUID = 7832661625546592609L;
    private boolean isMatch = true;
    private float matchFactor;
    private float matchFactorDirect;
    private float reverseMatchFactor;
    private float reverseMatchFactorDirect;
    private float probability;
    private float penalty;
    private String advise = "";

    public AbstractComparisonResult(float matchFactor, float reverseMatchFactor, float matchFactorDirect, float reverseMatchFactorDirect) {
        this.matchFactor = matchFactor;
        this.reverseMatchFactor = reverseMatchFactor;
        this.matchFactorDirect = matchFactorDirect;
        this.reverseMatchFactorDirect = reverseMatchFactorDirect;
        this.determineAdvise();
    }

    public AbstractComparisonResult(float matchFactor, float reverseMatchFactor, float matchFactorDirect, float reverseMatchFactorDirect, float probability) {
        this(matchFactor, reverseMatchFactor, matchFactorDirect, reverseMatchFactorDirect);
        if (probability >= 0.0f && probability <= 100.0f) {
            this.probability = probability;
        }
    }

    @Override
    public float getPenalty() {
        return this.penalty;
    }

    @Override
    public void clearPenalty() {
        this.penalty = 0.0f;
    }

    @Override
    public void setPenalty(float penalty) {
        if (penalty >= 0.0f) {
            this.penalty = penalty;
        }
    }

    @Override
    public void addPenalty(float penalty) {
        if (penalty >= 0.0f) {
            this.penalty += penalty;
        }
    }

    @Override
    public boolean isMatch() {
        return this.isMatch;
    }

    @Override
    public void setMatch(boolean match) {
        this.isMatch = match;
    }

    @Override
    public float getMatchFactor() {
        return AbstractComparisonResult.getAdjustedValue(this.matchFactor, this.penalty);
    }

    @Override
    public float getMatchFactorDirect() {
        return AbstractComparisonResult.getAdjustedValue(this.matchFactorDirect, this.penalty);
    }

    @Override
    public float getMatchFactorNotAdjusted() {
        return this.matchFactor;
    }

    @Override
    public float getMatchFactorDirectNotAdjusted() {
        return this.matchFactorDirect;
    }

    @Override
    public float getReverseMatchFactor() {
        return AbstractComparisonResult.getAdjustedValue(this.reverseMatchFactor, this.penalty);
    }

    @Override
    public float getReverseMatchFactorDirect() {
        return AbstractComparisonResult.getAdjustedValue(this.reverseMatchFactorDirect, this.penalty);
    }

    @Override
    public float getReverseMatchFactorNotAdjusted() {
        return this.reverseMatchFactor;
    }

    @Override
    public float getReverseMatchFactorDirectNotAdjusted() {
        return this.reverseMatchFactorDirect;
    }

    @Override
    public void adjustMatchFactor(float penalty) {
        if (!(penalty >= 0.0f) || !(penalty <= 100.0f)) {
            throw new IllegalArgumentException();
        }
        this.penalty = penalty;
    }

    @Override
    public void adjustReverseMatchFactor(float penalty) {
        if (!(penalty >= 0.0f) || !(penalty <= 100.0f)) {
            throw new IllegalArgumentException();
        }
        this.penalty = penalty;
    }

    @Override
    public float getProbability() {
        return this.probability;
    }

    @Override
    public String getAdvise() {
        return this.advise;
    }

    @Override
    public float getRating() {
        float rating = (this.matchFactor + this.reverseMatchFactor) / 2.0f;
        if (this.matchFactorDirect > 0.0f) {
            rating = (rating + this.matchFactorDirect) / 2.0f;
        }
        if (this.reverseMatchFactorDirect > 0.0f) {
            rating = (rating + this.reverseMatchFactorDirect) / 2.0f;
        }
        return rating;
    }

    private static float getAdjustedValue(float value, float penalty) {
        float result = value - penalty;
        if (result < 0.0f) {
            return 0.0f;
        }
        return result;
    }

    private void determineAdvise() {
        if (this.getMatchFactor() >= 80.0f && this.getReverseMatchFactor() <= 20.0f) {
            this.advise = "The target is maybe incomplete or recorded under bad conditions.";
        } else if (this.getMatchFactor() <= 20.0f && this.getReverseMatchFactor() >= 80.0f) {
            this.advise = "The target is maybe convoluted by impurities.";
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        IComparisonResult otherResult = (IComparisonResult)other;
        return this.getMatchFactor() == otherResult.getMatchFactor() && this.getReverseMatchFactor() == otherResult.getReverseMatchFactor() && this.getProbability() == otherResult.getProbability();
    }

    public int hashCode() {
        return 7 * Float.valueOf(this.getMatchFactor()).hashCode() + 11 * Float.valueOf(this.getReverseMatchFactor()).hashCode() + 13 * Float.valueOf(this.probability).hashCode();
    }

    public String toString() {
        return "AbstractComparisonResult [isMatch=" + this.isMatch + ", matchFactor=" + this.matchFactor + ", matchFactorDirect=" + this.matchFactorDirect + ", reverseMatchFactor=" + this.reverseMatchFactor + ", reverseMatchFactorDirect=" + this.reverseMatchFactorDirect + ", probability=" + this.probability + ", penalty=" + this.penalty + ", advise=" + this.advise + "]";
    }
}

