/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components;

import java.text.Format;
import java.util.ArrayList;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.series.IMultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.ISeriesSetter;
import org.eclipse.chemclipse.swt.ui.series.MultipleSeries;
import org.eclipse.chemclipse.swt.ui.support.ChartUtil;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.thirdpartylibraries.swtchart.ext.InteractiveChartExtended;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.IAxis;
import org.swtchart.IAxisSet;
import org.swtchart.ISeries;
import org.swtchart.Range;

public abstract class AbstractBarSeriesUI
extends InteractiveChartExtended
implements ISeriesSetter,
KeyListener,
MouseListener {
    protected boolean master = false;
    protected IChromatogramSelectionMSD chromatogramSelection;
    protected IScanMSD massSpectrum;
    protected IMultipleSeries multipleLineSeries;
    private double maxSignal = 0.0;
    private boolean showAxisTop = true;
    private boolean showAxisBottom = true;
    private boolean showAxisLeft = true;
    private boolean showAxisRight = true;
    private static int LOWER_X_NOT_SET = -1;
    private static int UPPER_X_NOT_SET = -1;
    private int lowerX = -1;
    private int upperX = -1;
    private IAxis xAxisTop;
    private IAxis xAxisBottom;
    private IAxis yAxisLeft;
    private IAxis yAxisRight;
    private static final double SPACE_FACTOR = 0.15;

    public AbstractBarSeriesUI(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void setLayoutData(GridData gridData) {
        super.setLayoutData((Object)gridData);
    }

    public void setShowAxis(int selection, boolean showAxis) {
        switch (selection) {
            case 1: {
                this.showAxisTop = showAxis;
                this.showAxisRight = showAxis;
                this.showAxisLeft = showAxis;
                this.showAxisBottom = showAxis;
                break;
            }
            case 128: {
                this.showAxisTop = showAxis;
                break;
            }
            case 131072: {
                this.showAxisRight = showAxis;
                break;
            }
            case 16384: {
                this.showAxisLeft = showAxis;
                break;
            }
            case 1024: {
                this.showAxisBottom = showAxis;
            }
        }
    }

    public void setFixedAxisRangeX(int lowerX, int upperX) {
        if (lowerX <= upperX) {
            this.lowerX = lowerX;
            this.upperX = upperX;
        } else {
            this.lowerX = upperX;
            this.upperX = lowerX;
        }
    }

    public Range getFixedAxisRangeX() {
        return new Range((double)this.lowerX, (double)this.upperX);
    }

    public void setAxisTitle(int selection, String title) {
        switch (selection) {
            case 1: {
                this.xAxisTop.getTitle().setText(title);
                this.yAxisRight.getTitle().setText(title);
                this.yAxisLeft.getTitle().setText(title);
                this.xAxisBottom.getTitle().setText(title);
                break;
            }
            case 128: {
                this.xAxisTop.getTitle().setText(title);
                break;
            }
            case 131072: {
                this.yAxisRight.getTitle().setText(title);
                break;
            }
            case 16384: {
                this.yAxisLeft.getTitle().setText(title);
                break;
            }
            case 1024: {
                this.xAxisBottom.getTitle().setText(title);
            }
        }
    }

    public void resetFixedAxisRangeX() {
        this.lowerX = LOWER_X_NOT_SET;
        this.upperX = UPPER_X_NOT_SET;
    }

    public Range getRange() {
        if (this.xAxisBottom != null) {
            return this.xAxisBottom.getRange();
        }
        return null;
    }

    public void setRange(Range range) {
        if (this.xAxisBottom != null && range != null) {
            Range rangeBottom = this.xAxisBottom.getRange();
            rangeBottom.lower = range.lower;
            rangeBottom.upper = range.upper;
            this.xAxisBottom.setRange(rangeBottom);
            this.redraw();
        }
    }

    public void clear() {
        this.deleteAllCurrentSeries();
        this.maxSignal = 1.0;
        this.massSpectrum = null;
        ArrayList<IAxis> axisList = new ArrayList<IAxis>();
        axisList.add(this.xAxisBottom);
        axisList.add(this.xAxisTop);
        axisList.add(this.yAxisLeft);
        axisList.add(this.yAxisRight);
        for (IAxis axis : axisList) {
            Range range = axis.getRange();
            range.lower = 0.0;
            range.upper = 1.0;
            axis.setRange(range);
        }
        this.getAxisSet().adjustRange();
        super.redraw();
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public void update(IScanMSD massSpectrum, boolean forceReload) {
        this.massSpectrum = massSpectrum;
        if (!this.master || this.master && forceReload) {
            this.setSeries(forceReload);
        }
    }

    public void dispose() {
        super.dispose();
    }

    public synchronized void redraw() {
        double xMax;
        super.redraw();
        double xMin = this.lowerX > LOWER_X_NOT_SET ? (double)this.lowerX : this.multipleLineSeries.getXMin();
        double d = xMax = this.upperX > UPPER_X_NOT_SET ? (double)this.upperX : this.multipleLineSeries.getXMax();
        if (xMin < xMax) {
            ChartUtil.checkAndSetRange((IAxis)this.xAxisBottom, (double)xMin, (double)xMax);
            double yMin = this.multipleLineSeries.getYMin();
            double yMax = this.multipleLineSeries.getYMax();
            yMin += yMin * 0.15;
            yMax += yMax * 0.15;
            ChartUtil.checkAndSetRange((IAxis)this.yAxisLeft, (double)yMin, (double)yMax);
            this.addSpaceToTopOfAbundance(yMin, yMax);
            this.redrawIonScale();
            this.redrawRelativeAbundanceScale();
            this.setTopAndLeftAxisVisibility();
        }
    }

    private void addSpaceToTopOfAbundance(double yMin, double yMax) {
        Range range = this.yAxisLeft.getRange();
        double lowerLimit = range.lower + range.lower * 0.15;
        double upperLimit = range.upper + range.upper * 0.15;
        if (lowerLimit <= yMin || upperLimit >= yMax) {
            range.lower = yMin;
            range.upper = yMax;
            this.yAxisLeft.setRange(range);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        super.mouseDoubleClick(e);
    }

    public void mouseDown(MouseEvent e) {
        super.mouseDown(e);
    }

    protected void initialize() {
        this.multipleLineSeries = new MultipleSeries();
        this.getLegend().setVisible(false);
        this.getTitle().setVisible(false);
        this.createPrimaryAxes();
        this.createSecondaryAxes();
        this.setAxesAndBackgroundColors();
        this.getAxisSet().adjustRange();
    }

    private void redrawIonScale() {
        assert (this.xAxisBottom != null) : "The ions instance must be not null.";
        assert (this.xAxisTop != null) : "The dalton instance must be not null.";
        Range range = this.xAxisBottom.getRange();
        double min = range.lower;
        double max = range.upper;
        ChartUtil.setRange((IAxis)this.xAxisTop, (double)min, (double)max);
    }

    private void redrawRelativeAbundanceScale() {
        assert (this.yAxisLeft != null) : "The abundance instance must be not null.";
        assert (this.yAxisRight != null) : "The relativeAbundance instance must be not null.";
        Range range = this.yAxisLeft.getRange();
        double min = ChartUtil.getRelativeAbundance((double)this.maxSignal, (double)range.lower);
        double max = ChartUtil.getRelativeAbundance((double)this.maxSignal, (double)range.upper);
        ChartUtil.setRange((IAxis)this.yAxisRight, (double)min, (double)max);
    }

    private void createPrimaryAxes() {
        IAxisSet axisSet = this.getAxisSet();
        this.xAxisBottom = axisSet.getXAxis(0);
        this.yAxisLeft = axisSet.getYAxis(0);
        this.yAxisLeft.getTitle().setText("abundance");
        this.yAxisLeft.getTick().setFormat((Format)ValueFormat.getDecimalFormatEnglish((String)"0"));
        this.xAxisBottom.getTitle().setText("m/z");
        this.xAxisBottom.getTick().setFormat((Format)ValueFormat.getDecimalFormatEnglish((String)"0.0###"));
    }

    private void createSecondaryAxes() {
        IAxisSet axisSet = this.getAxisSet();
        int axisIdMinutes = axisSet.createXAxis();
        this.xAxisTop = axisSet.getXAxis(axisIdMinutes);
        this.xAxisTop.getTitle().setText("dalton");
        this.xAxisTop.setPosition(IAxis.Position.Secondary);
        this.xAxisTop.getTick().setFormat((Format)ValueFormat.getDecimalFormatEnglish((String)"0.0###"));
        int axisIdAbundanceRelative = axisSet.createYAxis();
        this.yAxisRight = axisSet.getYAxis(axisIdAbundanceRelative);
        this.yAxisRight.getTitle().setText("relative abundance");
        this.yAxisRight.setPosition(IAxis.Position.Secondary);
        this.yAxisRight.getTick().setFormat((Format)ValueFormat.getDecimalFormatEnglish((String)"0.0##"));
    }

    private void setSecondaryRanges() {
        assert (this.chromatogramSelection != null) : "The chromatogramSelection instance must be not null.";
        assert (this.xAxisTop != null) : "The dalton instance must be not null.";
        assert (this.yAxisRight != null) : "The relativeAbundance instance must be not null.";
        double min = this.lowerX > LOWER_X_NOT_SET ? (double)this.lowerX : this.multipleLineSeries.getXMin();
        double max = this.upperX > UPPER_X_NOT_SET ? (double)this.upperX : this.multipleLineSeries.getXMax();
        Range range = new Range(min, max);
        this.xAxisTop.setRange(range);
        min = ChartUtil.getRelativeAbundance((double)this.maxSignal, (double)this.multipleLineSeries.getYMin());
        max = ChartUtil.getRelativeAbundance((double)this.maxSignal, (double)this.multipleLineSeries.getYMax());
        range = new Range(min, max);
        this.yAxisRight.setRange(range);
    }

    private void setAxesAndBackgroundColors() {
        assert (this.yAxisLeft != null) : "The abundance instance must be not null.";
        assert (this.xAxisBottom != null) : "The ions instance must be not null.";
        assert (this.xAxisTop != null) : "The dalton instance must be not null.";
        assert (this.yAxisRight != null) : "The relativeAbundance instance must be not null.";
        this.setBackground(Colors.WHITE);
        this.setBackgroundInPlotArea(Colors.WHITE);
        ChartUtil.setAxisColor((IAxis)this.yAxisLeft, (Color)Colors.BLACK);
        ChartUtil.setAxisColor((IAxis)this.xAxisBottom, (Color)Colors.BLACK);
        ChartUtil.setAxisColor((IAxis)this.xAxisTop, (Color)Colors.BLACK);
        ChartUtil.setAxisColor((IAxis)this.yAxisRight, (Color)Colors.BLACK);
    }

    protected void setSeries(boolean forceReload) {
        double xMax;
        assert (this.chromatogramSelection != null) : "The chromatogramSelection instance must be not null.";
        assert (this.multipleLineSeries != null) : "The multipleLineSeries instance must be not null.";
        this.deleteAllCurrentSeries();
        this.setViewSeries();
        double xMin = this.lowerX > LOWER_X_NOT_SET ? (double)this.lowerX : this.multipleLineSeries.getXMin();
        double d = xMax = this.upperX > UPPER_X_NOT_SET ? (double)this.upperX : this.multipleLineSeries.getXMax();
        if (xMin < xMax) {
            this.maxSignal = this.multipleLineSeries.getYMax();
            this.getAxisSet().adjustRange();
            this.setSecondaryRanges();
        }
        this.redraw();
    }

    private void deleteAllCurrentSeries() {
        this.multipleLineSeries.removeAll();
        ISeries[] series = this.getSeriesSet().getSeries();
        ArrayList<String> ids = new ArrayList<String>();
        ISeries[] iSeriesArray = series;
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries serie = iSeriesArray[n2];
            ids.add(serie.getId());
            ++n2;
        }
        for (String id : ids) {
            this.getSeriesSet().deleteSeries(id);
        }
    }

    private void setTopAndLeftAxisVisibility() {
        assert (this.xAxisTop != null) : "The dalton instance must be not null.";
        assert (this.yAxisRight != null) : "The relativeAbundance instance must be not null.";
        this.getTitle().setForeground(this.getBackground());
        if (this.showAxisTop) {
            this.getTitle().setText("");
            this.getTitle().setVisible(false);
        } else {
            this.getTitle().setText("Series");
            this.getTitle().setVisible(true);
        }
        if (this.xAxisTop != null) {
            this.xAxisTop.getTitle().setVisible(this.showAxisTop);
            this.xAxisTop.getTick().setVisible(this.showAxisTop);
        }
        if (this.yAxisLeft != null) {
            this.yAxisLeft.getTitle().setVisible(this.showAxisLeft);
            this.yAxisLeft.getTick().setVisible(this.showAxisLeft);
        }
        if (this.xAxisBottom != null) {
            this.xAxisBottom.getTitle().setVisible(this.showAxisBottom);
            this.xAxisBottom.getTick().setVisible(this.showAxisBottom);
            if (this.lowerX != LOWER_X_NOT_SET && this.upperX != UPPER_X_NOT_SET) {
                Range rangeBottom = this.xAxisBottom.getRange();
                if (!(rangeBottom.lower > this.multipleLineSeries.getXMin()) && !(rangeBottom.upper < this.multipleLineSeries.getXMax())) {
                    rangeBottom.lower = this.lowerX;
                    rangeBottom.upper = this.upperX;
                }
                this.xAxisBottom.setRange(rangeBottom);
            }
        }
        if (this.yAxisRight != null) {
            this.yAxisRight.getTitle().setVisible(this.showAxisRight);
            this.yAxisRight.getTick().setVisible(this.showAxisRight);
        }
    }
}

