/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.alignment.model.core;

import org.eclipse.chemclipse.chromatogram.alignment.model.core.IRetentionIndex;

public class RetentionIndex
implements IRetentionIndex,
Comparable<IRetentionIndex> {
    public static final int MIN_RETENTION_TIME = 0;
    public static final int MAX_RETENTION_TIME = Integer.MAX_VALUE;
    private int retentionTime = 0;
    public static final float MIN_INDEX = 0.0f;
    public static final float MAX_INDEX = Float.MAX_VALUE;
    private float index = 0.0f;
    private String name = "";

    public RetentionIndex() {
    }

    public RetentionIndex(int retentionTime, float index) {
        this.setCkeckedRetentionTime(retentionTime);
        this.setCheckedIndex(index);
    }

    public RetentionIndex(int retentionTime, float index, String name) {
        this(retentionTime, index);
        this.name = name;
    }

    @Override
    public int getRetentionTime() {
        return this.retentionTime;
    }

    @Override
    public void setRetentionTime(int retentionTime) {
        this.setCkeckedRetentionTime(retentionTime);
    }

    private void setCkeckedRetentionTime(int retentionTime) {
        if (retentionTime >= 0 && retentionTime <= Integer.MAX_VALUE) {
            this.retentionTime = retentionTime;
        }
    }

    @Override
    public float getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(float index) {
        this.setCheckedIndex(index);
    }

    private void setCheckedIndex(float index) {
        if (index >= 0.0f && index <= Float.MAX_VALUE) {
            this.index = index;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(IRetentionIndex other) {
        return (int)(this.index - other.getIndex());
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        RetentionIndex other = (RetentionIndex)otherObject;
        return this.index == other.index && this.retentionTime == other.retentionTime && this.name.equals(other.name);
    }

    public int hashCode() {
        return 7 * new Double(this.index).hashCode() + 9 * Integer.valueOf(this.retentionTime).hashCode() + 11 * this.name.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("index=" + this.index);
        builder.append(",");
        builder.append("retentionTime=" + this.retentionTime);
        builder.append(",");
        builder.append("name=" + this.name);
        builder.append("]");
        return builder.toString();
    }
}

