/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.MainStateJacobianProvider;
import org.apache.commons.math3.ode.ParameterConfiguration;
import org.apache.commons.math3.ode.ParameterJacobianProvider;
import org.apache.commons.math3.ode.ParameterJacobianWrapper;
import org.apache.commons.math3.ode.ParameterizedODE;
import org.apache.commons.math3.ode.SecondaryEquations;
import org.apache.commons.math3.ode.UnknownParameterException;

public class JacobianMatrices {
    private ExpandableStatefulODE efode = null;
    private int index = -1;
    private MainStateJacobianProvider jode;
    private ParameterizedODE pode;
    private int stateDim;
    private ParameterConfiguration[] selectedParameters;
    private List<ParameterJacobianProvider> jacobianProviders;
    private int paramDim;
    private boolean dirtyParameter;
    private double[] matricesData;

    public JacobianMatrices(FirstOrderDifferentialEquations fode, double[] hY, String ... parameters) throws DimensionMismatchException {
        this(new MainStateJacobianWrapper(fode, hY), parameters);
    }

    public JacobianMatrices(MainStateJacobianProvider jode, String ... parameters) {
        int i;
        this.jode = jode;
        this.pode = null;
        this.stateDim = jode.getDimension();
        if (parameters == null) {
            this.selectedParameters = null;
            this.paramDim = 0;
        } else {
            this.selectedParameters = new ParameterConfiguration[parameters.length];
            i = 0;
            while (i < parameters.length) {
                this.selectedParameters[i] = new ParameterConfiguration(parameters[i], Double.NaN);
                ++i;
            }
            this.paramDim = parameters.length;
        }
        this.dirtyParameter = false;
        this.jacobianProviders = new ArrayList<ParameterJacobianProvider>();
        this.matricesData = new double[(this.stateDim + this.paramDim) * this.stateDim];
        i = 0;
        while (i < this.stateDim) {
            this.matricesData[i * (this.stateDim + 1)] = 1.0;
            ++i;
        }
    }

    public void registerVariationalEquations(ExpandableStatefulODE expandable) throws DimensionMismatchException, MismatchedEquations {
        MainStateJacobianProvider ode;
        FirstOrderDifferentialEquations firstOrderDifferentialEquations = ode = this.jode instanceof MainStateJacobianWrapper ? ((MainStateJacobianWrapper)this.jode).ode : this.jode;
        if (expandable.getPrimary() != ode) {
            throw new MismatchedEquations();
        }
        this.efode = expandable;
        this.index = this.efode.addSecondaryEquations(new JacobiansSecondaryEquations());
        this.efode.setSecondaryState(this.index, this.matricesData);
    }

    public void addParameterJacobianProvider(ParameterJacobianProvider provider) {
        this.jacobianProviders.add(provider);
    }

    public void setParameterizedODE(ParameterizedODE parameterizedOde) {
        this.pode = parameterizedOde;
        this.dirtyParameter = true;
    }

    public void setParameterStep(String parameter, double hP) throws UnknownParameterException {
        ParameterConfiguration[] parameterConfigurationArray = this.selectedParameters;
        int n = this.selectedParameters.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterConfiguration param = parameterConfigurationArray[n2];
            if (parameter.equals(param.getParameterName())) {
                param.setHP(hP);
                this.dirtyParameter = true;
                return;
            }
            ++n2;
        }
        throw new UnknownParameterException(parameter);
    }

    public void setInitialMainStateJacobian(double[][] dYdY0) throws DimensionMismatchException {
        this.checkDimension(this.stateDim, dYdY0);
        this.checkDimension(this.stateDim, dYdY0[0]);
        int i = 0;
        double[][] dArray = dYdY0;
        int n = dYdY0.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row = dArray[n2];
            System.arraycopy(row, 0, this.matricesData, i, this.stateDim);
            i += this.stateDim;
            ++n2;
        }
        if (this.efode != null) {
            this.efode.setSecondaryState(this.index, this.matricesData);
        }
    }

    public void setInitialParameterJacobian(String pName, double[] dYdP) throws UnknownParameterException, DimensionMismatchException {
        this.checkDimension(this.stateDim, dYdP);
        int i = this.stateDim * this.stateDim;
        ParameterConfiguration[] parameterConfigurationArray = this.selectedParameters;
        int n = this.selectedParameters.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterConfiguration param = parameterConfigurationArray[n2];
            if (pName.equals(param.getParameterName())) {
                System.arraycopy(dYdP, 0, this.matricesData, i, this.stateDim);
                if (this.efode != null) {
                    this.efode.setSecondaryState(this.index, this.matricesData);
                }
                return;
            }
            i += this.stateDim;
            ++n2;
        }
        throw new UnknownParameterException(pName);
    }

    public void getCurrentMainSetJacobian(double[][] dYdY0) {
        double[] p = this.efode.getSecondaryState(this.index);
        int j = 0;
        int i = 0;
        while (i < this.stateDim) {
            System.arraycopy(p, j, dYdY0[i], 0, this.stateDim);
            j += this.stateDim;
            ++i;
        }
    }

    public void getCurrentParameterJacobian(String pName, double[] dYdP) {
        double[] p = this.efode.getSecondaryState(this.index);
        int i = this.stateDim * this.stateDim;
        ParameterConfiguration[] parameterConfigurationArray = this.selectedParameters;
        int n = this.selectedParameters.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterConfiguration param = parameterConfigurationArray[n2];
            if (param.getParameterName().equals(pName)) {
                System.arraycopy(p, i, dYdP, 0, this.stateDim);
                return;
            }
            i += this.stateDim;
            ++n2;
        }
    }

    private void checkDimension(int expected, Object array) throws DimensionMismatchException {
        int arrayDimension;
        int n = arrayDimension = array == null ? 0 : Array.getLength(array);
        if (arrayDimension != expected) {
            throw new DimensionMismatchException(arrayDimension, expected);
        }
    }

    private class JacobiansSecondaryEquations
    implements SecondaryEquations {
        private JacobiansSecondaryEquations() {
        }

        @Override
        public int getDimension() {
            return JacobianMatrices.this.stateDim * (JacobianMatrices.this.stateDim + JacobianMatrices.this.paramDim);
        }

        @Override
        public void computeDerivatives(double t, double[] y, double[] yDot, double[] z, double[] zDot) throws MaxCountExceededException, DimensionMismatchException {
            if (JacobianMatrices.this.dirtyParameter && JacobianMatrices.this.paramDim != 0) {
                JacobianMatrices.this.jacobianProviders.add(new ParameterJacobianWrapper(JacobianMatrices.this.jode, JacobianMatrices.this.pode, JacobianMatrices.this.selectedParameters));
                JacobianMatrices.this.dirtyParameter = false;
            }
            double[][] dFdY = new double[JacobianMatrices.this.stateDim][JacobianMatrices.this.stateDim];
            JacobianMatrices.this.jode.computeMainStateJacobian(t, y, yDot, dFdY);
            int i = 0;
            while (i < JacobianMatrices.this.stateDim) {
                double[] dFdYi = dFdY[i];
                int j = 0;
                while (j < JacobianMatrices.this.stateDim) {
                    int startIndex;
                    double s = 0.0;
                    int zIndex = startIndex = j;
                    int l = 0;
                    while (l < JacobianMatrices.this.stateDim) {
                        s += dFdYi[l] * z[zIndex];
                        zIndex += JacobianMatrices.this.stateDim;
                        ++l;
                    }
                    zDot[startIndex + i * ((JacobianMatrices)JacobianMatrices.this).stateDim] = s;
                    ++j;
                }
                ++i;
            }
            if (JacobianMatrices.this.paramDim != 0) {
                double[] dFdP = new double[JacobianMatrices.this.stateDim];
                int startIndex = JacobianMatrices.this.stateDim * JacobianMatrices.this.stateDim;
                ParameterConfiguration[] parameterConfigurationArray = JacobianMatrices.this.selectedParameters;
                int n = parameterConfigurationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ParameterConfiguration param = parameterConfigurationArray[n2];
                    boolean found = false;
                    int k = 0;
                    while (!found && k < JacobianMatrices.this.jacobianProviders.size()) {
                        ParameterJacobianProvider provider = (ParameterJacobianProvider)JacobianMatrices.this.jacobianProviders.get(k);
                        if (provider.isSupported(param.getParameterName())) {
                            provider.computeParameterJacobian(t, y, yDot, param.getParameterName(), dFdP);
                            int i2 = 0;
                            while (i2 < JacobianMatrices.this.stateDim) {
                                double[] dFdYi = dFdY[i2];
                                int zIndex = startIndex;
                                double s = dFdP[i2];
                                int l = 0;
                                while (l < JacobianMatrices.this.stateDim) {
                                    s += dFdYi[l] * z[zIndex];
                                    ++zIndex;
                                    ++l;
                                }
                                zDot[startIndex + i2] = s;
                                ++i2;
                            }
                            found = true;
                        }
                        ++k;
                    }
                    if (!found) {
                        Arrays.fill(zDot, startIndex, startIndex + JacobianMatrices.this.stateDim, 0.0);
                    }
                    startIndex += JacobianMatrices.this.stateDim;
                    ++n2;
                }
            }
        }
    }

    private static class MainStateJacobianWrapper
    implements MainStateJacobianProvider {
        private final FirstOrderDifferentialEquations ode;
        private final double[] hY;

        public MainStateJacobianWrapper(FirstOrderDifferentialEquations ode, double[] hY) throws DimensionMismatchException {
            this.ode = ode;
            this.hY = (double[])hY.clone();
            if (hY.length != ode.getDimension()) {
                throw new DimensionMismatchException(ode.getDimension(), hY.length);
            }
        }

        @Override
        public int getDimension() {
            return this.ode.getDimension();
        }

        @Override
        public void computeDerivatives(double t, double[] y, double[] yDot) throws MaxCountExceededException, DimensionMismatchException {
            this.ode.computeDerivatives(t, y, yDot);
        }

        @Override
        public void computeMainStateJacobian(double t, double[] y, double[] yDot, double[][] dFdY) throws MaxCountExceededException, DimensionMismatchException {
            int n = this.ode.getDimension();
            double[] tmpDot = new double[n];
            int j = 0;
            while (j < n) {
                double savedYj = y[j];
                int n2 = j;
                y[n2] = y[n2] + this.hY[j];
                this.ode.computeDerivatives(t, y, tmpDot);
                int i = 0;
                while (i < n) {
                    dFdY[i][j] = (tmpDot[i] - yDot[i]) / this.hY[j];
                    ++i;
                }
                y[j] = savedYj;
                ++j;
            }
        }
    }

    public static class MismatchedEquations
    extends MathIllegalArgumentException {
        private static final long serialVersionUID = 20120902L;

        public MismatchedEquations() {
            super(LocalizedFormats.UNMATCHED_ODE_IN_EXPANDED_SET, new Object[0]);
        }
    }
}

