/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.core;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks.AbstractPeakIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IPeakIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.exceptions.ValueMustNotBeNullException;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.IPeakIntegratorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.PeakIntegratorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.PeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.support.TrapezoidPeakIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.settings.ITrapezoidPeakIntegrationSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakIntegrator
extends AbstractPeakIntegrator {
    private static final Logger logger = Logger.getLogger(PeakIntegrator.class);

    public IPeakIntegratorProcessingInfo integrate(IPeak peak, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) {
        PeakIntegratorProcessingInfo processingInfo = new PeakIntegratorProcessingInfo();
        try {
            super.validate(peak, peakIntegrationSettings);
            TrapezoidPeakIntegratorSupport firstDerivativePeakIntegratorSupport = new TrapezoidPeakIntegratorSupport();
            IPeakIntegrationResult peakIntegrationResult = firstDerivativePeakIntegratorSupport.calculatePeakIntegrationResult(peak, peakIntegrationSettings, monitor);
            PeakIntegrationResults peakIntegrationResults = new PeakIntegrationResults();
            peakIntegrationResults.add(peakIntegrationResult);
            processingInfo.setPeakIntegrationResults((IPeakIntegrationResults)peakIntegrationResults);
        }
        catch (ValueMustNotBeNullException e) {
            logger.warn((Object)e);
            this.addIntegratorExceptionInfo((IProcessingInfo)processingInfo);
        }
        return processingInfo;
    }

    public IPeakIntegratorProcessingInfo integrate(IPeak peak, IProgressMonitor monitor) {
        ITrapezoidPeakIntegrationSettings peakIntegrationSettings = PreferenceSupplier.getPeakIntegrationSettings();
        return this.integrate(peak, (IPeakIntegrationSettings)peakIntegrationSettings, monitor);
    }

    public IPeakIntegratorProcessingInfo integrate(List<? extends IPeak> peaks, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) {
        PeakIntegratorProcessingInfo processingInfo = new PeakIntegratorProcessingInfo();
        try {
            super.validate(peaks, peakIntegrationSettings);
            TrapezoidPeakIntegratorSupport firstDerivativePeakIntegratorSupport = new TrapezoidPeakIntegratorSupport();
            IPeakIntegrationResults peakIntegrationResults = firstDerivativePeakIntegratorSupport.calculatePeakIntegrationResults(peaks, peakIntegrationSettings, monitor);
            processingInfo.setPeakIntegrationResults(peakIntegrationResults);
        }
        catch (ValueMustNotBeNullException e) {
            logger.warn((Object)e);
            this.addIntegratorExceptionInfo((IProcessingInfo)processingInfo);
        }
        return processingInfo;
    }

    public IPeakIntegratorProcessingInfo integrate(List<? extends IPeak> peaks, IProgressMonitor monitor) {
        ITrapezoidPeakIntegrationSettings peakIntegrationSettings = PreferenceSupplier.getPeakIntegrationSettings();
        return this.integrate(peaks, (IPeakIntegrationSettings)peakIntegrationSettings, monitor);
    }

    public IPeakIntegratorProcessingInfo integrate(IChromatogramSelection chromatogramSelection, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) {
        PeakIntegratorProcessingInfo processingInfo = new PeakIntegratorProcessingInfo();
        try {
            super.validate(chromatogramSelection, peakIntegrationSettings);
            TrapezoidPeakIntegratorSupport firstDerivativePeakIntegratorSupport = new TrapezoidPeakIntegratorSupport();
            IPeakIntegrationResults peakIntegrationResults = firstDerivativePeakIntegratorSupport.calculatePeakIntegrationResults(chromatogramSelection, peakIntegrationSettings, monitor);
            processingInfo.setPeakIntegrationResults(peakIntegrationResults);
        }
        catch (ValueMustNotBeNullException e) {
            logger.warn((Object)e);
            this.addIntegratorExceptionInfo((IProcessingInfo)processingInfo);
        }
        return processingInfo;
    }

    public IPeakIntegratorProcessingInfo integrate(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        ITrapezoidPeakIntegrationSettings peakIntegrationSettings = PreferenceSupplier.getPeakIntegrationSettings();
        return this.integrate(chromatogramSelection, (IPeakIntegrationSettings)peakIntegrationSettings, monitor);
    }

    private void addIntegratorExceptionInfo(IProcessingInfo processingInfo) {
        processingInfo.addErrorMessage("Peak Integrator Trapezoid", "The peak(s) or settings couldn't be validated correctly.");
    }
}

