/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.console;

import java.io.IOException;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.log.CloudLog;
import org.eclipse.cft.server.core.internal.log.LogContentType;
import org.eclipse.cft.server.ui.internal.console.ConsoleConfig;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.console.IOConsoleOutputStream;

public abstract class ConsoleStream {
    protected ConsoleStream() {
    }

    public abstract void initialiseStream(ConsoleConfig var1) throws CoreException;

    public abstract void close();

    public abstract boolean isActive();

    protected abstract IOConsoleOutputStream getOutputStream(LogContentType var1);

    public synchronized void write(CloudLog log) throws CoreException {
        if (log == null || log.getMessage() == null) {
            return;
        }
        IOConsoleOutputStream outStream = this.getOutputStream(log.getLogType());
        if (outStream != null) {
            try {
                outStream.write(log.getMessage());
            }
            catch (IOException e) {
                throw CloudErrorUtil.toCoreException((Throwable)e);
            }
        }
    }
}

