/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.plantuml;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextProvider;
import net.sourceforge.plantuml.eclipse.views.PlantUmlView;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.handlers.IArtifactUnpacker;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.ui.helpers.SelectionSupportHelper;
import org.eclipse.capra.ui.plantuml.DisplayInternalLinksHandler;
import org.eclipse.capra.ui.plantuml.SelectRelationshipsHandler;
import org.eclipse.capra.ui.plantuml.ToggleDisplayGraphHandler;
import org.eclipse.capra.ui.plantuml.ToggleTransitivityHandler;
import org.eclipse.capra.ui.plantuml.TransitivityDepthHandler;
import org.eclipse.capra.ui.plantuml.VisualizationHelper;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class DiagramTextProviderHandler
implements DiagramTextProvider {
    private EObject artifactModel = null;

    private boolean isLockDiagram() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.capra.ui.plantuml.lockDiagram");
        return preferences.node("lockDiagram").getBoolean("option", false);
    }

    public String getDiagramText(IEditorPart editor, ISelection input) {
        return this.getDiagramText((IWorkbenchPart)editor, input);
    }

    public String getDiagramText(IViewPart view, ISelection input) {
        return this.getDiagramText((IWorkbenchPart)view, input);
    }

    public String getDiagramText(IWorkbenchPart part, ISelection input) {
        ArrayList<Object> selectedModels = new ArrayList<Object>();
        if (part.getSite().getSelectionProvider() != null) {
            selectedModels.addAll(SelectionSupportHelper.extractSelectedElements((ISelection)part.getSite().getSelectionProvider().getSelection(), (IWorkbenchPart)part));
        }
        return this.getDiagramText(selectedModels, Optional.of(part));
    }

    public String getDiagramText(List<Object> selectedModels, Optional<IWorkbenchPart> part) {
        if (selectedModels == null || selectedModels.size() < 1) {
            return VisualizationHelper.createMatrix(null, this.artifactModel, null, null, true);
        }
        ArrayList<Connection> traces = new ArrayList<Connection>();
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        EObject traceModel = null;
        TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().get();
        TraceMetaModelAdapter metamodelAdapter = (TraceMetaModelAdapter)ExtensionPointHelper.getTraceMetamodelAdapter().get();
        ResourceSet artifactResourceSet = part.isPresent() ? SelectionSupportHelper.getResourceSet((IWorkbenchPart)part.get()) : null;
        this.artifactModel = persistenceAdapter.getArtifactWrappers((ResourceSet)(artifactResourceSet != null ? artifactResourceSet : new ResourceSetImpl()));
        if (selectedModels.size() > 0) {
            EObject selectedObject;
            ArtifactHelper artifactHelper = new ArtifactHelper(this.artifactModel);
            selectedModels.stream().forEach(obj -> {
                IArtifactHandler handler = artifactHelper.getHandler(obj).orElse(null);
                if (handler != null) {
                    Object unpackedElement = null;
                    unpackedElement = handler instanceof IArtifactUnpacker ? ((IArtifactUnpacker)IArtifactUnpacker.class.cast(handler)).unpack(obj) : obj;
                    if (ToggleTransitivityHandler.isTraceViewTransitive()) {
                        selectedEObjects.addAll(EMFHelper.linearize((Object)handler.createWrapper(unpackedElement, this.artifactModel)));
                    } else {
                        selectedEObjects.add(handler.createWrapper(unpackedElement, this.artifactModel));
                    }
                }
            });
            EObject eObject = selectedObject = selectedEObjects.size() > 0 ? (EObject)selectedEObjects.get(0) : null;
            if (selectedObject != null && selectedObject.eResource() != null) {
                ResourceSet resourceSet = selectedObject.eResource().getResourceSet();
                traceModel = persistenceAdapter.getTraceModel(resourceSet);
                List<String> selectedRelationshipTypes = SelectRelationshipsHandler.getSelectedRelationshipTypes();
                for (EObject obj2 : selectedEObjects) {
                    traces.addAll(this.getViewableTraceLinks(obj2, traceModel, metamodelAdapter, selectedRelationshipTypes));
                }
                if (selectedModels.size() == 1) {
                    return VisualizationHelper.createNeighboursView(traces, EMFHelper.linearize((Object)selectedObject), this.artifactModel);
                }
                if (ToggleDisplayGraphHandler.isDisplayGraph()) {
                    return this.renderMultiSelectionGraph(traces, selectedEObjects, artifactHelper);
                }
            }
        }
        return VisualizationHelper.createMatrix(traceModel, this.artifactModel, selectedEObjects, selectedEObjects, DisplayInternalLinksHandler.areInternalLinksShown());
    }

    protected String renderMultiSelectionGraph(List<Connection> traces, List<EObject> selectedEObjects, ArtifactHelper artifactHelper) {
        ArrayList<Connection> relevantTraces = new ArrayList<Connection>();
        ArrayList<EObject> wrappers = new ArrayList<EObject>();
        for (Connection connection : traces) {
            if (!selectedEObjects.contains(connection.getOrigin())) continue;
            if (!selectedEObjects.stream().anyMatch(connection.getTargets()::contains)) continue;
            Connection newConnection = new Connection(connection.getOrigin(), connection.getTargets().stream().filter(selectedEObjects::contains).collect(Collectors.toList()), connection.getTlink());
            relevantTraces.add(newConnection);
            IArtifactHandler originHandler = artifactHelper.getHandler((Object)connection.getOrigin()).orElse(null);
            wrappers.add(originHandler.createWrapper((Object)connection.getOrigin(), this.artifactModel));
            connection.getTargets().stream().filter(selectedEObjects::contains).forEach(t -> {
                IArtifactHandler targetHandler = artifactHelper.getHandler((Object)connection.getOrigin()).orElse(null);
                wrappers.add(targetHandler.createWrapper(t, this.artifactModel));
            });
        }
        return VisualizationHelper.createNeighboursView(relevantTraces, wrappers, this.artifactModel);
    }

    protected List<Connection> getViewableTraceLinks(EObject selectedObject, EObject traceModel, TraceMetaModelAdapter metamodelAdapter, List<String> selectedRelationshipTypes) {
        List traces;
        if (ToggleTransitivityHandler.isTraceViewTransitive()) {
            int transitivityDepth = Integer.parseInt(TransitivityDepthHandler.getTransitivityDepth());
            traces = metamodelAdapter.getTransitivelyConnectedElements(selectedObject, traceModel, selectedRelationshipTypes, transitivityDepth);
        } else {
            traces = metamodelAdapter.getConnectedElements(selectedObject, traceModel, selectedRelationshipTypes);
        }
        if (DisplayInternalLinksHandler.areInternalLinksShown() && ToggleTransitivityHandler.isTraceViewTransitive()) {
            EObject previousElement = SelectRelationshipsHandler.getPreviousElement();
            int transitivityDepth = Integer.parseInt(TransitivityDepthHandler.getTransitivityDepth());
            if (previousElement != null) {
                String currentElementName;
                String previousElementName = EMFHelper.getNameAttribute((EObject)previousElement);
                if (!previousElementName.equals(currentElementName = EMFHelper.getNameAttribute((EObject)selectedObject))) {
                    SelectRelationshipsHandler.clearPossibleRelationsForSelection();
                    SelectRelationshipsHandler.emptySelectedRelationshipTypes();
                    SelectRelationshipsHandler.setPreviousElement(selectedObject);
                }
            } else {
                SelectRelationshipsHandler.setPreviousElement(selectedObject);
            }
            traces.addAll(metamodelAdapter.getInternalElementsTransitive(selectedObject, traceModel, selectedRelationshipTypes, transitivityDepth, traces));
        } else if (DisplayInternalLinksHandler.areInternalLinksShown()) {
            EObject previousElement = SelectRelationshipsHandler.getPreviousElement();
            if (previousElement != null) {
                String currentElementName;
                String previousElementName = EMFHelper.getNameAttribute((EObject)previousElement);
                if (!previousElementName.equals(currentElementName = EMFHelper.getNameAttribute((EObject)selectedObject))) {
                    SelectRelationshipsHandler.clearPossibleRelationsForSelection();
                    SelectRelationshipsHandler.emptySelectedRelationshipTypes();
                    SelectRelationshipsHandler.setPreviousElement(selectedObject);
                }
            } else {
                SelectRelationshipsHandler.setPreviousElement(selectedObject);
            }
            traces.addAll(metamodelAdapter.getInternalElements(selectedObject, traceModel, selectedRelationshipTypes, false, 0, traces));
        }
        List<EObject> links = DiagramTextProviderHandler.extractLinksFromTraces(traces);
        SelectRelationshipsHandler.addToPossibleRelationsForSelection(links);
        return traces;
    }

    public boolean supportsEditor(IEditorPart editor) {
        return !this.isLockDiagram();
    }

    public boolean supportsView(IViewPart part) {
        if (this.isLockDiagram()) {
            return false;
        }
        return !(part instanceof PlantUmlView);
    }

    public boolean supportsSelection(ISelection selection) {
        return !this.isLockDiagram();
    }

    private static List<EObject> extractLinksFromTraces(List<Connection> traces) {
        ArrayList<EObject> links = new ArrayList<EObject>();
        for (Connection trace : traces) {
            if (links.contains(trace.getTlink())) continue;
            links.add(trace.getTlink());
        }
        return links;
    }
}

