/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.domain.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.core.domain.EgfResourceSet;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.model.EGFModelPlugin;
import org.eclipse.egf.model.domain.Domain;
import org.eclipse.egf.model.domain.DomainPackage;
import org.eclipse.egf.model.domain.DomainViewpoint;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.model.domain.FilesystemDomain;
import org.eclipse.egf.model.domain.LoadableDomain;
import org.eclipse.egf.model.domain.TypeDomain;
import org.eclipse.egf.model.domain.TypeGenPackages;
import org.eclipse.egf.model.domain.WorkspaceDomain;
import org.eclipse.egf.model.types.util.TypesValidator;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainValidator
extends EObjectValidator {
    public static final DomainValidator INSTANCE = new DomainValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.egf.model.domain";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    private final IBatchValidator batchValidator;
    protected TypesValidator typesValidator = TypesValidator.INSTANCE;

    public DomainValidator() {
        this.batchValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        this.batchValidator.setTraversalStrategy((ITraversalStrategy)new ITraversalStrategy.Recursive());
        this.batchValidator.setIncludeLiveConstraints(true);
        this.batchValidator.setReportSuccesses(false);
    }

    protected EPackage getEPackage() {
        return DomainPackage.eINSTANCE;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = Status.OK_STATUS;
        super.validate(eClass, eObject, diagnostics, context);
        if (diagnostics != null && !this.hasProcessed(eObject, context)) {
            status = this.batchValidator.validate(eObject, (IProgressMonitor)new NullProgressMonitor());
            this.processed(eObject, context, status);
            this.appendDiagnostics(status, diagnostics);
        }
        return status.isOK();
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateDomainViewpoint((DomainViewpoint)value, diagnostics, context);
            }
            case 1: {
                return this.validateDomain((Domain)value, diagnostics, context);
            }
            case 2: {
                return this.validateTypeGenPackages((TypeGenPackages)value, diagnostics, context);
            }
            case 3: {
                return this.validateEMFDomain((EMFDomain)value, diagnostics, context);
            }
            case 4: {
                return this.validateTypeDomain((TypeDomain)value, diagnostics, context);
            }
            case 5: {
                return this.validateFilesystemDomain((FilesystemDomain)value, diagnostics, context);
            }
            case 6: {
                return this.validateWorkspaceDomain((WorkspaceDomain)value, diagnostics, context);
            }
            case 7: {
                return this.validateLoadableDomain((LoadableDomain)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateDomainViewpoint(DomainViewpoint domainViewpoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(domainViewpoint, diagnostics, context);
    }

    public boolean validateDomain(Domain domain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(domain, diagnostics, context);
    }

    public boolean validateTypeGenPackages(TypeGenPackages typeGenPackages, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeGenPackages, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeGenPackages, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeGenPackages, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeGenPackages, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeGenPackages, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeGenPackages, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeGenPackages, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeGenPackages, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeGenPackages_ValidGenPackages(typeGenPackages, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeGenPackages_ValidGenPackages(TypeGenPackages typeGenPackages, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (typeGenPackages.getElements() == null) {
            return true;
        }
        boolean valid = true;
        EgfResourceSet resourceSet = new EgfResourceSet();
        if (typeGenPackages.eResource() != null && typeGenPackages.eResource() instanceof IPlatformFcoreProvider) {
            IPlatformFcore fcore = ((IPlatformFcoreProvider)typeGenPackages.eResource()).getIPlatformFcore();
            resourceSet = new EgfResourceSet(fcore.isRuntime());
        }
        for (GenPackage genPackage : typeGenPackages.getElements()) {
            URI uri = EcoreUtil.getURI((EObject)genPackage);
            Resource resource = resourceSet.getResource(uri, true);
            if (resource != null) continue;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidGenPackages", DomainValidator.getObjectLabel((EObject)typeGenPackages, context), NLS.bind((String)"Unable to load URI ''{0}''", (Object)uri)}, new Object[]{typeGenPackages}, context));
            }
            valid = false;
        }
        return valid;
    }

    public boolean validateEMFDomain_ValidURI(EMFDomain domain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (domain.getUri() == null) {
            return true;
        }
        URI uri = domain.getUri();
        boolean valid = true;
        InputStream inputStream = null;
        try {
            IPlatformFcore fcore;
            if (domain.eResource() != null && domain.eResource() instanceof IPlatformFcoreProvider && (fcore = ((IPlatformFcoreProvider)domain.eResource()).getIPlatformFcore()).isRuntime()) {
                inputStream = new ExtensibleURIConverterImpl().createInputStream(uri);
            }
            if (inputStream == null) {
                inputStream = EGFPlatformPlugin.getPlatformURIConverter().createInputStream(uri);
            }
        }
        catch (IOException exception) {
            valid = false;
        }
        FileHelper.safeClose(inputStream);
        if (!valid) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidURI", DomainValidator.getObjectLabel((EObject)domain, context), NLS.bind((String)"Unable to load URI ''{0}''", (Object)uri)}, new Object[]{domain}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateEMFDomain(EMFDomain emfDomain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(emfDomain, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(emfDomain, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(emfDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(emfDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(emfDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(emfDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(emfDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(emfDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEMFDomain_ValidURI(emfDomain, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeDomain(TypeDomain typeDomain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeDomain, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeDomain, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeDomain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.typesValidator.validateTypeObject_ValidValue(typeDomain, diagnostics, context);
        }
        return result;
    }

    public boolean validateFilesystemDomain(FilesystemDomain filesystemDomain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(filesystemDomain, diagnostics, context);
    }

    public boolean validateWorkspaceDomain(WorkspaceDomain workspaceDomain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(workspaceDomain, diagnostics, context);
    }

    public boolean validateLoadableDomain(LoadableDomain loadableDomain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(loadableDomain, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return EGFModelPlugin.INSTANCE;
    }

    private void processed(EObject eObject, Map<Object, Object> context, IStatus status) {
        if (context != null) {
            context.put(eObject, status);
        }
    }

    private boolean hasProcessed(EObject eObject, Map<Object, Object> context) {
        boolean result = false;
        if (context != null) {
            while (eObject != null) {
                if (context.containsKey(eObject)) {
                    result = true;
                    eObject = null;
                    continue;
                }
                eObject = eObject.eContainer();
            }
        }
        return result;
    }

    private void appendDiagnostics(IStatus status, DiagnosticChain diagnostics) {
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.appendDiagnostics(children[i], diagnostics);
                ++i;
            }
        } else if (status instanceof IConstraintStatus) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), ((IConstraintStatus)status).getResultLocus().toArray()));
        }
    }
}

