/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.configuration.ui.viewer.providers;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRefreshable;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.ui.toolkit.browser.category.CategoryRegistry;
import org.polarsys.capella.common.ui.toolkit.browser.category.ICategory;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.BrowserElementWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.CategoryWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.EObjectWrapper;
import org.polarsys.capella.docgen.configuration.ui.viewer.providers.DiagramContentProvider;
import org.polarsys.capella.docgen.configuration.ui.viewer.providers.GenerationSemanticBrowserModel;
import org.polarsys.capella.docgen.configuration.ui.viewer.providers.GenerationWizardContentProviderFactory;

public class DetailsContentProvider
implements ITreeContentProvider {
    public static final String ALL_RELATED_DIAGRAMS = "All Related Diagrams";
    public static final String ALL_RELATED_TABLES = "All Related Tables";
    private static final String DIAGRAM_CATEGOTY_ID = "org.polarsys.capella.core.semantic.queries.sirius.diagram.getall";
    private static final String TABLE_CATEGOTY_ID = "org.polarsys.capella.core.semantic.queries.sirius.category1";
    private ITreeContentProvider referencedcontentProvider;
    private ITreeContentProvider referencingcontentProvider;
    private ITreeContentProvider representationContentProvider;
    private DiagramContentProvider diagramContentContentProvider;

    public DetailsContentProvider(Session session) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        GenerationWizardContentProviderFactory semanticBrowserContentProviderFactory = new GenerationWizardContentProviderFactory();
        semanticBrowserContentProviderFactory.setModel(new GenerationSemanticBrowserModel());
        this.referencedcontentProvider = semanticBrowserContentProviderFactory.getReferencedContentProvider();
        this.referencingcontentProvider = semanticBrowserContentProviderFactory.getReferencingContentProvider();
        this.representationContentProvider = semanticBrowserContentProviderFactory.getCurrentContentProvider();
        this.diagramContentContentProvider = new DiagramContentProvider((AdapterFactory)adapterFactory);
    }

    public Object[] getChildren(Object parentElement) {
        if (DetailsContentProvider.isSiriusElement(parentElement)) {
            if (parentElement instanceof DSemanticDecorator) {
                return this.diagramContentContentProvider.getChildren(parentElement);
            }
            if (parentElement instanceof DRepresentationDescriptor) {
                return this.diagramContentContentProvider.getChildren(((DRepresentationDescriptor)parentElement).getRepresentation());
            }
        } else {
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            result.addAll(this.filterResult(parentElement, this.referencedcontentProvider.getChildren(parentElement)));
            result.addAll(this.filterResult(parentElement, this.referencingcontentProvider.getChildren(parentElement)));
            result.addAll(this.filterDiagramResult(parentElement, this.representationContentProvider.getChildren(parentElement)));
            return result.toArray();
        }
        return new Object[0];
    }

    private Set<Object> filterResult(Object parentElement, Object[] referencedChildren) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        if (parentElement instanceof EObjectWrapper) {
            Object[] objectArray = referencedChildren;
            int n = referencedChildren.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (!(object instanceof CategoryWrapper)) {
                    result.add(object);
                }
                ++n2;
            }
        } else {
            Collections.addAll(result, referencedChildren);
        }
        return result;
    }

    private Set<Object> filterDiagramResult(Object parentElement, Object[] referencedChildren) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        Object[] objectArray = referencedChildren;
        int n = referencedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof EObjectWrapper || object instanceof CategoryWrapper && ((CategoryWrapper)object).getElement() instanceof ICategory && (ALL_RELATED_DIAGRAMS.equals(((ICategory)((CategoryWrapper)object).getElement()).getName()) || ALL_RELATED_TABLES.equals(((ICategory)((CategoryWrapper)object).getElement()).getName()))) {
                result.add(object);
            }
            ++n2;
        }
        if (result.isEmpty() && !(parentElement instanceof BrowserElementWrapper)) {
            result.add(new CategoryWrapper((Object)CategoryRegistry.getInstance().getCategory(DIAGRAM_CATEGOTY_ID)));
            result.add(new CategoryWrapper((Object)CategoryRegistry.getInstance().getCategory(TABLE_CATEGOTY_ID)));
        }
        return result;
    }

    public Object getParent(Object element) {
        Object parent = this.referencedcontentProvider.getParent(element);
        if (parent != null) {
            return parent;
        }
        return this.referencingcontentProvider.getParent(element);
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.referencedcontentProvider.dispose();
        this.referencingcontentProvider.dispose();
        this.representationContentProvider.dispose();
        this.diagramContentContentProvider.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.referencedcontentProvider.inputChanged(viewer, oldInput, newInput);
        this.referencingcontentProvider.inputChanged(viewer, oldInput, newInput);
        this.representationContentProvider.inputChanged(viewer, oldInput, newInput);
    }

    private static boolean isSiriusElement(Object object) {
        return object instanceof DRefreshable || object instanceof DRepresentationDescriptor;
    }
}

