/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.StringCharacterIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EscapeChars {
    private static final String AND_CHARACTER = "&amp;";
    private static final Pattern SCRIPT = Pattern.compile("<SCRIPT>", 2);
    private static final Pattern SCRIPT_END = Pattern.compile("</SCRIPT>", 2);

    public static String forHTML(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '&') {
                result.append(AND_CHARACTER);
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\t') {
                EscapeChars.addCharEntity(9, result);
            } else if (character == '!') {
                EscapeChars.addCharEntity(33, result);
            } else if (character == '#') {
                EscapeChars.addCharEntity(35, result);
            } else if (character == '$') {
                EscapeChars.addCharEntity(36, result);
            } else if (character == '%') {
                EscapeChars.addCharEntity(37, result);
            } else if (character == '\'') {
                EscapeChars.addCharEntity(39, result);
            } else if (character == '(') {
                EscapeChars.addCharEntity(40, result);
            } else if (character == ')') {
                EscapeChars.addCharEntity(41, result);
            } else if (character == '*') {
                EscapeChars.addCharEntity(42, result);
            } else if (character == '+') {
                EscapeChars.addCharEntity(43, result);
            } else if (character == ',') {
                EscapeChars.addCharEntity(44, result);
            } else if (character == '-') {
                EscapeChars.addCharEntity(45, result);
            } else if (character == '.') {
                EscapeChars.addCharEntity(46, result);
            } else if (character == '/') {
                EscapeChars.addCharEntity(47, result);
            } else if (character == ':') {
                EscapeChars.addCharEntity(58, result);
            } else if (character == ';') {
                EscapeChars.addCharEntity(59, result);
            } else if (character == '=') {
                EscapeChars.addCharEntity(61, result);
            } else if (character == '?') {
                EscapeChars.addCharEntity(63, result);
            } else if (character == '@') {
                EscapeChars.addCharEntity(64, result);
            } else if (character == '[') {
                EscapeChars.addCharEntity(91, result);
            } else if (character == '\\') {
                EscapeChars.addCharEntity(92, result);
            } else if (character == ']') {
                EscapeChars.addCharEntity(93, result);
            } else if (character == '^') {
                EscapeChars.addCharEntity(94, result);
            } else if (character == '_') {
                EscapeChars.addCharEntity(95, result);
            } else if (character == '`') {
                EscapeChars.addCharEntity(96, result);
            } else if (character == '{') {
                EscapeChars.addCharEntity(123, result);
            } else if (character == '|') {
                EscapeChars.addCharEntity(124, result);
            } else if (character == '}') {
                EscapeChars.addCharEntity(125, result);
            } else if (character == '~') {
                EscapeChars.addCharEntity(126, result);
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String replaceSpecialCharacters(String value) {
        if (value != null) {
            value = value.replaceAll("\ufffd", "&laquo;");
            value = value.replaceAll("\ufffd", "&raquo;");
            value = value.replaceAll("\ufffd", "&ldquo;");
            value = value.replaceAll("\ufffd", "&rdquo;");
            value = value.replaceAll("\ufffd", "&bdquo;");
            value = value.replaceAll("\ufffd", "&lsquo;");
            value = value.replaceAll("\ufffd", "&rsquo;");
            value = value.replaceAll("\ufffd", "&sbquo;");
            value = value.replaceAll("\ufffd", "&hellip;");
            value = value.replaceAll("\ufffd", "&acute;");
            value = value.replaceAll("\ufffd", "&eacute;");
            value = value.replaceAll("\ufffd", "&egrave;");
            value = value.replaceAll("\ufffd", "&ccedil;");
            value = value.replaceAll("\ufffd", "&agrave;");
            value = value.replaceAll("\ufffd", "&ugrave;");
            value = value.replaceAll("\ufffd", "&acirc;");
            value = value.replaceAll("\ufffd", "&ecirc;");
            value = value.replaceAll("\ufffd", "&icirc;");
            value = value.replaceAll("\ufffd", "&ocirc;");
            value = value.replaceAll("\ufffd", "&ucirc;");
            value = value.replaceAll("\ufffd", "&auml;");
            value = value.replaceAll("\ufffd", "&euml;");
            value = value.replaceAll("\ufffd", "&iuml;");
            value = value.replaceAll("\ufffd", "&ouml;");
            value = value.replaceAll("\ufffd", "&uuml;");
            value = value.replaceAll("\ufffd", "&deg;");
        }
        return value;
    }

    public static String forHrefAmpersand(String aURL) {
        return aURL.replace("&", AND_CHARACTER);
    }

    public static String forURL(String aURLFragment) {
        String result = null;
        try {
            result = URLEncoder.encode(aURLFragment, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported", ex);
        }
        return result;
    }

    public static String forXML(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '&') {
                result.append(AND_CHARACTER);
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String forJSON(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\"') {
                result.append("\\\"");
            } else if (character == '\\') {
                result.append("\\\\");
            } else if (character == '/') {
                result.append("\\/");
            } else if (character == '\b') {
                result.append("\\b");
            } else if (character == '\f') {
                result.append("\\f");
            } else if (character == '\n') {
                result.append("\\n");
            } else if (character == '\r') {
                result.append("\\r");
            } else if (character == '\t') {
                result.append("\\t");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String toDisableTags(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String forRegex(String aRegexFragment) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aRegexFragment);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '.') {
                result.append("\\.");
            } else if (character == '\\') {
                result.append("\\\\");
            } else if (character == '?') {
                result.append("\\?");
            } else if (character == '*') {
                result.append("\\*");
            } else if (character == '+') {
                result.append("\\+");
            } else if (character == '&') {
                result.append("\\&");
            } else if (character == ':') {
                result.append("\\:");
            } else if (character == '{') {
                result.append("\\{");
            } else if (character == '}') {
                result.append("\\}");
            } else if (character == '[') {
                result.append("\\[");
            } else if (character == ']') {
                result.append("\\]");
            } else if (character == '(') {
                result.append("\\(");
            } else if (character == ')') {
                result.append("\\)");
            } else if (character == '^') {
                result.append("\\^");
            } else if (character == '$') {
                result.append("\\$");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String forReplacementString(String aInput) {
        return Matcher.quoteReplacement(aInput);
    }

    public static String forScriptTagsOnly(String aText) {
        String result = null;
        Matcher matcher = SCRIPT.matcher(aText);
        result = matcher.replaceAll("&lt;SCRIPT>");
        matcher = SCRIPT_END.matcher(result);
        result = matcher.replaceAll("&lt;/SCRIPT>");
        return result;
    }

    private EscapeChars() {
    }

    private static void addCharEntity(Integer aIdx, StringBuilder aBuilder) {
        String padding = "";
        if (aIdx <= 9) {
            padding = "00";
        } else if (aIdx <= 99) {
            padding = "0";
        }
        String number = String.valueOf(padding) + aIdx.toString();
        aBuilder.append("&#" + number + ";");
    }
}

