/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.properties.fields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.MultipleSemanticField;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.tools.dialogs.FilteringCriteriaSelectionDialog;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.capella.filtering.tools.utils.ui.CriteriaContentProvider;

public class IndirectCapellaElementCriteriaMultipleSemanticField
extends MultipleSemanticField {
    public IndirectCapellaElementCriteriaMultipleSemanticField(Composite parent, String label, TabbedPropertySheetWidgetFactory widgetFactory, IMultipleSemanticFieldController controller) {
        super(parent, label, widgetFactory, controller);
    }

    protected List<EObject> openTransferDialog(Button button, List<EObject> currentElements, List<EObject> availableElements, String title, String message) {
        Session session = SessionManager.INSTANCE.getSession(this._semanticElement);
        TransactionalEditingDomain transactionalEditingDomain = session.getTransactionalEditingDomain();
        Collection projects = FilteringUtils.getMainAndReferencedVariantProjects((EObject)this._semanticElement);
        FilteringCriteriaSelectionDialog dialog = new FilteringCriteriaSelectionDialog(button.getShell(), (ILabelProvider)new TransactionalAdapterFactoryLabelProvider(transactionalEditingDomain, ((AdapterFactoryEditingDomain)transactionalEditingDomain).getAdapterFactory()), new CriteriaContentProvider(), projects);
        dialog.setTitle("Assign Filtering Criteria");
        dialog.setMessage("Select the desired Filtering Criteria for the selection");
        dialog.setInput((Object)projects);
        dialog.setInitialElementSelections(currentElements);
        if (dialog.open() != 0) {
            return currentElements;
        }
        ArrayList<EObject> checkedElements = new ArrayList<EObject>();
        for (Object o : dialog.getCheckedElements()) {
            if (!(o instanceof EObject)) continue;
            checkedElements.add((EObject)o);
        }
        return checkedElements;
    }

    protected void handleDeleteButtonClicked() {
        if (FilteringUtils.getExplicitAssociatedCriteria((EObject)this._semanticElement).isEmpty()) {
            return;
        }
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                FilteringUtils.removeAssociatedCriteria((EObject)IndirectCapellaElementCriteriaMultipleSemanticField.this._semanticElement, (Collection)FilteringUtils.getExplicitAssociatedCriteria((EObject)IndirectCapellaElementCriteriaMultipleSemanticField.this._semanticElement));
            }
        };
        FilteringUtils.executeCommand((ICommand)command, (EObject)this._semanticElement);
        this.setValueTextField(Collections.emptyList());
    }

    protected void handleOpenButtonClicked(Button button) {
        Session session = SessionManager.INSTANCE.getSession(this._semanticElement);
        TransactionalEditingDomain transactionalEditingDomain = session.getTransactionalEditingDomain();
        Collection projects = FilteringUtils.getMainAndReferencedVariantProjects((EObject)this._semanticElement);
        final FilteringCriteriaSelectionDialog dialog = new FilteringCriteriaSelectionDialog(button.getShell(), (ILabelProvider)new TransactionalAdapterFactoryLabelProvider(transactionalEditingDomain, ((AdapterFactoryEditingDomain)transactionalEditingDomain).getAdapterFactory()), new CriteriaContentProvider(), projects);
        dialog.setTitle("Assign Filtering Criteria");
        dialog.setMessage("Select the desired Filtering Criteria for the selection");
        dialog.setInput((Object)projects);
        List currentElements = FilteringUtils.getExplicitAssociatedCriteria((EObject)this._semanticElement);
        dialog.setInitialElementSelections(currentElements);
        if (dialog.open() != 0) {
            return;
        }
        ArrayList<EObject> checkedElements = new ArrayList<EObject>();
        for (Object o : dialog.getCheckedElements()) {
            if (!(o instanceof EObject)) continue;
            checkedElements.add((EObject)o);
        }
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                ArrayList<FilteringCriterion> featuresToAdd = new ArrayList<FilteringCriterion>();
                ArrayList<FilteringCriterion> featuresToRemove = new ArrayList<FilteringCriterion>();
                Collection toCheck = dialog.getCheckedElements();
                Collection toUnCheck = dialog.getUnCheckedElements();
                for (Object unCheckMe : toUnCheck) {
                    if (!FilteringUtils.getExplicitAssociatedCriteria((EObject)IndirectCapellaElementCriteriaMultipleSemanticField.this._semanticElement).contains(unCheckMe)) continue;
                    featuresToRemove.add((FilteringCriterion)unCheckMe);
                }
                for (Object checkMe : toCheck) {
                    if (FilteringUtils.getExplicitAssociatedCriteria((EObject)IndirectCapellaElementCriteriaMultipleSemanticField.this._semanticElement).contains(checkMe)) continue;
                    featuresToAdd.add((FilteringCriterion)checkMe);
                }
                FilteringUtils.addAssociatedCriteria((EObject)IndirectCapellaElementCriteriaMultipleSemanticField.this._semanticElement, featuresToAdd);
                FilteringUtils.removeAssociatedCriteria((EObject)IndirectCapellaElementCriteriaMultipleSemanticField.this._semanticElement, featuresToRemove);
            }
        };
        FilteringUtils.executeCommand((ICommand)command, (EObject)this._semanticElement);
        this.setValueTextField(FilteringUtils.getExplicitAssociatedCriteria((EObject)this._semanticElement));
    }
}

