/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.Logger;
import org.eclipse.buildship.core.console.ProcessStreamsProvider;
import org.eclipse.buildship.core.event.EventListener;
import org.eclipse.buildship.core.launch.GradleLaunchConfigurationManager;
import org.eclipse.buildship.core.notification.UserNotification;
import org.eclipse.buildship.core.util.logging.EclipseLogger;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.console.ConsoleProcessStreamsProvider;
import org.eclipse.buildship.ui.launch.ConsoleShowingLaunchListener;
import org.eclipse.buildship.ui.launch.UiGradleLaunchConfigurationManager;
import org.eclipse.buildship.ui.notification.DialogUserNotification;
import org.eclipse.buildship.ui.view.execution.ExecutionShowingLaunchRequestListener;
import org.eclipse.buildship.ui.workspace.ShutdownListener;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public final class UiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.buildship.ui";
    private static UiPlugin plugin;
    private ServiceRegistration loggerService;
    private ServiceRegistration processStreamsProviderService;
    private ServiceRegistration dialogUserNotificationService;
    private ServiceRegistration gradleLaunchConfigurationService;
    private ConsoleShowingLaunchListener consoleShowingLaunchListener;
    private ExecutionShowingLaunchRequestListener executionShowingLaunchRequestListener;
    private ShutdownListener shutdownListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.registerServices(context);
        this.registerListeners();
    }

    public void stop(BundleContext context) throws Exception {
        this.unregisterListeners();
        this.unregisterServices();
        plugin = null;
        super.stop(context);
    }

    private void registerServices(BundleContext context) {
        Hashtable<String, Object> preferences = new Hashtable<String, Object>();
        ((Dictionary)preferences).put("service.ranking", 1);
        Hashtable<String, Object> priorityPreferences = new Hashtable<String, Object>();
        ((Dictionary)priorityPreferences).put("service.ranking", 2);
        this.loggerService = this.registerService(context, Logger.class, this.createLogger(), preferences);
        this.processStreamsProviderService = this.registerService(context, ProcessStreamsProvider.class, this.createConsoleProcessStreamsProvider(), priorityPreferences);
        this.dialogUserNotificationService = this.registerService(context, UserNotification.class, this.createUserNotification(), priorityPreferences);
        this.gradleLaunchConfigurationService = this.registerService(context, GradleLaunchConfigurationManager.class, this.createLaunchConfigurationManager(), priorityPreferences);
    }

    private <T> ServiceRegistration registerService(BundleContext context, Class<T> clazz, T service, Dictionary<String, Object> properties) {
        return context.registerService(clazz.getName(), service, properties);
    }

    private EclipseLogger createLogger() {
        return new EclipseLogger(this.getLog(), PLUGIN_ID, this.isDebugging());
    }

    private ProcessStreamsProvider createConsoleProcessStreamsProvider() {
        return new ConsoleProcessStreamsProvider();
    }

    private UserNotification createUserNotification() {
        return new DialogUserNotification();
    }

    private GradleLaunchConfigurationManager createLaunchConfigurationManager() {
        return new UiGradleLaunchConfigurationManager(CorePlugin.gradleLaunchConfigurationManager());
    }

    private void unregisterServices() {
        this.gradleLaunchConfigurationService.unregister();
        this.dialogUserNotificationService.unregister();
        this.processStreamsProviderService.unregister();
        this.loggerService.unregister();
    }

    private void registerListeners() {
        this.consoleShowingLaunchListener = new ConsoleShowingLaunchListener();
        this.consoleShowingLaunchListener.handleAlreadyRunningLaunches();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this.consoleShowingLaunchListener);
        this.executionShowingLaunchRequestListener = new ExecutionShowingLaunchRequestListener();
        CorePlugin.listenerRegistry().addEventListener((EventListener)this.executionShowingLaunchRequestListener);
        this.shutdownListener = new ShutdownListener();
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)this.shutdownListener);
    }

    private void unregisterListeners() {
        PlatformUI.getWorkbench().removeWorkbenchListener((IWorkbenchListener)this.shutdownListener);
        CorePlugin.listenerRegistry().removeEventListener((EventListener)this.executionShowingLaunchRequestListener);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this.consoleShowingLaunchListener);
    }

    public static UiPlugin getInstance() {
        return plugin;
    }

    public static Logger logger() {
        return (Logger)UiPlugin.getService(UiPlugin.getInstance().loggerService.getReference());
    }

    private static <T> T getService(ServiceReference reference) {
        return (T)reference.getBundle().getBundleContext().getService(reference);
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
        for (PluginImages pluginImage : PluginImages.values()) {
            pluginImage.register();
        }
    }
}

