/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.gen.ide;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.mwe.core.issues.MWEDiagnostic;
import org.eclipse.ui.statushandlers.StatusManager;

public class LogWorkflow
implements Log {
    private static final long serialVersionUID = 9181448189753075665L;
    static List<MWEDiagnostic> errors;
    static List<MWEDiagnostic> warnings;
    static List<MWEDiagnostic> fatals;
    static StringBuffer info;
    String name;
    static boolean success;
    static String priorLog;

    public LogWorkflow(String name) {
        LogWorkflow.clearLog();
        this.name = name;
    }

    public static void report(IStatus status, boolean show) {
        int style = 1;
        if (show) {
            style |= 2;
        }
        StatusManager.getManager().handle(status, style);
    }

    public static void report(int severity, String pluginName, String message, MWEDiagnostic[] MWEDiagnostics, boolean show) {
        LogWorkflow.report(LogWorkflow.createStatus(severity, pluginName, message, MWEDiagnostics), show);
    }

    public static void report(int severity, String pluginName, String message, boolean show) {
        LogWorkflow.report((IStatus)new Status(severity, pluginName, message), show);
    }

    public static IStatus createStatus(int severity, String pluginName, String message, MWEDiagnostic[] MWEDiagnostics) {
        return new WorkflowStatus(severity, pluginName, message, MWEDiagnostics);
    }

    public static MWEDiagnostic[] getErrors() {
        return errors.toArray(new MWEDiagnostic[0]);
    }

    public static MWEDiagnostic[] getWarnings() {
        return warnings.toArray(new MWEDiagnostic[0]);
    }

    public static MWEDiagnostic[] getFatals() {
        return fatals.toArray(new MWEDiagnostic[0]);
    }

    public static void registerToLogFactory() {
        priorLog = System.getProperty("org.apache.commons.logging.Log");
        System.setProperty("org.apache.commons.logging.Log", LogWorkflow.class.getName());
    }

    public static void restoreLogFactory() {
        if (priorLog != null) {
            System.setProperty("org.apache.commons.logging.Log", priorLog);
        }
    }

    public static void clearLog() {
        errors = new ArrayList<MWEDiagnostic>();
        warnings = new ArrayList<MWEDiagnostic>();
        fatals = new ArrayList<MWEDiagnostic>();
        info = new StringBuffer();
    }

    public static void report(String pluginName, String taskDescription) {
        LogWorkflow.report(pluginName, taskDescription, true);
    }

    public static void report(String pluginName, String taskDescription, boolean showErrors) {
        String logMessage = "\r\rLog:\r" + info;
        String taskMessage = taskDescription;
        String successMessage = String.valueOf(taskDescription) + (success ? " completed succesfully." : " failed.");
        if (LogWorkflow.getFatals().length > 0) {
            LogWorkflow.report(4, pluginName, "Fatal errors occurred during " + taskMessage, LogWorkflow.getFatals(), true);
        } else if (LogWorkflow.getErrors().length > 0) {
            LogWorkflow.report(4, pluginName, "Errors occurred during " + taskMessage, LogWorkflow.getErrors(), showErrors);
        } else if (LogWorkflow.getWarnings().length > 0) {
            LogWorkflow.report(2, pluginName, String.valueOf(successMessage) + " Warnings occurred while executing workflow. (These may not actually be problems.)" + logMessage, LogWorkflow.getWarnings(), false);
        } else {
            LogWorkflow.report(0, pluginName, String.valueOf(successMessage) + logMessage, false);
        }
        LogWorkflow.clearLog();
    }

    public String messageFor(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof WrappedException) {
            return ((WrappedException)object).getMessage();
        }
        return object.toString();
    }

    public void error(Object message) {
        errors.add(new MWEDiagnostic(0, (String)message, message, this.name, null, null, null));
        this.warningOrAbove("ERROR: " + this.messageFor(message));
    }

    public void error(Object message, Throwable t) {
        errors.add(new MWEDiagnostic(0, this.messageFor(message), (Object)t, this.name, t, null, null));
        this.warningOrAbove("ERROR: " + this.messageFor(message));
    }

    public void fatal(Object message) {
        fatals.add(new MWEDiagnostic(0, this.messageFor(message), message, this.name, null, null, null));
        this.warningOrAbove("FATAL: " + this.messageFor(message));
    }

    public void fatal(Object message, Throwable t) {
        fatals.add(new MWEDiagnostic(0, this.messageFor(message), (Object)t, this.name, t, null, null));
        this.warningOrAbove("FATAL: " + this.messageFor(message));
    }

    public void warn(Object message) {
        warnings.add(new MWEDiagnostic(0, this.messageFor(message), message, this.name, null, null, null));
        this.warningOrAbove("WARNING: " + this.messageFor(message));
    }

    public void warn(Object message, Throwable t) {
        warnings.add(new MWEDiagnostic(0, this.messageFor(message), (Object)t, this.name, t, null, null));
        this.warningOrAbove("WARNING: " + this.messageFor(message));
    }

    public void belowWarning(Object message) {
        System.out.println(message);
    }

    public void warningOrAbove(Object message) {
        System.err.println(message);
    }

    public static void addInfo(Object message) {
        info.append(message + "\r");
    }

    public void info(Object message) {
        this.belowWarning(message);
    }

    public void info(Object message, Throwable t) {
        this.belowWarning(message);
    }

    public void trace(Object message) {
        this.belowWarning(message);
    }

    public void trace(Object message, Throwable t) {
        this.belowWarning(message);
    }

    public void debug(Object message) {
        this.belowWarning(message);
    }

    public void debug(Object message, Throwable t) {
        this.belowWarning(message);
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public static void setSuccess(boolean success) {
        LogWorkflow.success = success;
    }

    static class WorkflowStatus
    extends MultiStatus {
        public WorkflowStatus(int severity, String pluginName, String message, MWEDiagnostic[] MWEDiagnostics) {
            super(pluginName, 0, message, null);
            this.setSeverity(severity);
            MWEDiagnostic[] mWEDiagnosticArray = MWEDiagnostics;
            int n = MWEDiagnostics.length;
            int n2 = 0;
            while (n2 < n) {
                MWEDiagnostic MWEDiagnostic2 = mWEDiagnosticArray[n2];
                Status status = null;
                status = MWEDiagnostic2.getElement() instanceof Exception ? new Status(severity, pluginName, MWEDiagnostic2.getMessage(), (Throwable)((Exception)MWEDiagnostic2.getElement())) : new Status(severity, pluginName, MWEDiagnostic2.getMessage());
                this.add((IStatus)status);
                ++n2;
            }
        }
    }
}

