/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.xtend.ast;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Property;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Check
extends SyntaxElement {
    private Identifier type;
    private boolean errorSeverity = true;
    private Expression msg;
    private Expression constraint;
    private Expression guard;
    private final Identifier feature;

    public Check(Identifier type, Identifier f, Expression guard, boolean errorSeverity, Expression msg, Expression constraint) {
        this.type = type;
        this.feature = f;
        this.guard = guard;
        this.errorSeverity = errorSeverity;
        this.msg = msg;
        this.constraint = constraint;
    }

    public final void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        try {
            Property property;
            if (ctx.getCallback() != null && !ctx.getCallback().pre(this, ctx)) {
                return;
            }
            Type toCheck = ctx.getTypeForName(this.type.getValue());
            if (toCheck == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Type not found: " + this.type.getValue(), this));
                return;
            }
            if (this.feature != null && (property = toCheck.getProperty(this.feature.getValue())) == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.FEATURE_NOT_FOUND, "Couldn't find property '" + this.feature.getValue() + "' for type '" + this.type.getValue() + "'", this));
                return;
            }
            ctx = ctx.cloneWithVariable(new Variable("this", toCheck));
            if (this.guard != null) {
                Type guardType = null;
                try {
                    guardType = this.guard.analyze(ctx, issues);
                }
                catch (RuntimeException ex) {
                    ctx.handleRuntimeException(ex, this, null);
                }
                if (guardType == null) {
                    return;
                }
                if (!guardType.equals(ctx.getBooleanType())) {
                    issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Boolean expected! (is " + guardType.getName() + ")", this.guard));
                }
            }
            Type constraintType = null;
            try {
                constraintType = this.constraint.analyze(ctx, issues);
            }
            catch (RuntimeException ex) {
                ctx.handleRuntimeException(ex, this, null);
            }
            if (constraintType == null) {
                return;
            }
            if (!constraintType.equals(ctx.getBooleanType())) {
                issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Boolean expected! (is " + constraintType.getName() + ")", this.constraint));
            }
            try {
                this.msg.analyze(ctx, issues);
            }
            catch (RuntimeException ex) {
                ctx.handleRuntimeException(ex, this, null);
            }
        }
        finally {
            if (ctx.getCallback() != null) {
                ctx.getCallback().post(this, ctx, null);
            }
        }
    }

    public void validate(ExecutionContext ctx, Collection<?> colToCheck, Issues issues, boolean warnIfNothingChecked) {
        try {
            if (ctx.getCallback() != null && !ctx.getCallback().pre(this, ctx)) {
                return;
            }
            Type typeToCheck = ctx.getTypeForName(this.type.getValue());
            if (typeToCheck == null) {
                throw new EvaluationException("Type not found : " + this.type.getValue(), (SyntaxElement)this, ctx);
            }
            boolean someObjectFound = false;
            for (Object o : colToCheck) {
                if (!typeToCheck.isInstance(o)) continue;
                someObjectFound = true;
                try {
                    ctx = ctx.cloneWithVariable(new Variable("this", o));
                    if (!this.process(ctx)) continue;
                    Object result = null;
                    try {
                        result = this.constraint.evaluate(ctx);
                    }
                    catch (RuntimeException e) {
                        this.addIssueForException(issues, e, o);
                    }
                    if (result != null && !(result instanceof Boolean)) {
                        throw new EvaluationException("Boolean expected! ( was " + result.getClass().getName() + ")", (SyntaxElement)this, ctx);
                    }
                    Boolean r = (Boolean)result;
                    if (!Boolean.FALSE.equals(r)) continue;
                    Object msgResult = null;
                    try {
                        msgResult = this.msg.evaluate(ctx);
                    }
                    catch (RuntimeException e) {
                        this.addIssueForException(issues, e, o);
                    }
                    String stringResult = "Message evaluation returned null";
                    if (msgResult != null) {
                        stringResult = msgResult.toString();
                    }
                    String propertyName = null;
                    if (this.feature != null) {
                        String featureValue = this.feature.getValue();
                        Property property = typeToCheck.getProperty(featureValue);
                        if (property == null) {
                            throw new EvaluationException("Property " + featureValue + " for Type " + typeToCheck + " not found!", (SyntaxElement)this, ctx);
                        }
                        propertyName = property.getName();
                    }
                    if (this.errorSeverity) {
                        issues.addError(null, stringResult, o, propertyName, null, Collections.emptyList());
                        continue;
                    }
                    issues.addWarning(null, stringResult, o, propertyName, null, Collections.emptyList());
                }
                catch (NullPointerException npe) {
                    Object msgResult = this.msg.evaluate(ctx);
                    String stringResult = "Message evaluation returned null";
                    if (msgResult != null) {
                        stringResult = msgResult.toString();
                    }
                    if (this.errorSeverity) {
                        issues.addError(String.valueOf(stringResult) + " (NPE in constraint evaluation)", o);
                        continue;
                    }
                    issues.addWarning(String.valueOf(stringResult) + " (NPE in constraint evaluation)", o);
                }
            }
            if (warnIfNothingChecked && !someObjectFound) {
                issues.addWarning("The constraint did not match any model elements. Context: " + this.type.toString() + ", message: " + this.msg);
            }
        }
        finally {
            if (ctx.getCallback() != null) {
                ctx.getCallback().post(this, ctx, null);
            }
        }
    }

    protected void addIssueForException(Issues issues, Exception exception, Object element) {
        issues.addError(null, exception.getMessage(), element, (Throwable)exception, Collections.emptyList());
    }

    private boolean process(ExecutionContext ctx) {
        if (this.guard != null) {
            Object result = this.guard.evaluate(ctx);
            return result instanceof Boolean && (Boolean)result != false;
        }
        return true;
    }

    public String toString() {
        return this.type + " " + this.msg;
    }

    public boolean isErrorCheck() {
        return this.errorSeverity;
    }

    public Expression getConstraint() {
        return this.constraint;
    }

    public Expression getGuard() {
        return this.guard;
    }

    public Expression getMsg() {
        return this.msg;
    }

    public Identifier getType() {
        return this.type;
    }
}

