/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Vector;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.component.Grid;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class GridAttributesComposite
extends Composite
implements SelectionListener,
Listener {
    private transient LineAttributesComposite liacLines = null;
    private transient LineAttributesComposite liacTicks = null;
    private transient Composite cmpContent = null;
    private transient Composite cmpLines = null;
    private transient Label lblStyle = null;
    private transient Combo cmbTickStyle = null;
    private transient Grid grid = null;
    private transient Vector vListeners = null;
    private int orientation;
    private transient boolean bLineGroupEnabled = true;
    private transient ChartWizardContext context;
    public static final int LINE_STYLE_CHANGED_EVENT = 1;
    public static final int LINE_WIDTH_CHANGED_EVENT = 2;
    public static final int LINE_COLOR_CHANGED_EVENT = 3;
    public static final int LINE_VISIBILITY_CHANGED_EVENT = 4;
    public static final int TICK_STYLE_CHANGED_EVENT = 5;
    public static final int TICK_COLOR_CHANGED_EVENT = 6;
    public static final int TICK_VISIBILITY_CHANGED_EVENT = 7;

    public GridAttributesComposite(Composite parent, int style, ChartWizardContext context, Grid grid, int orientation) {
        super(parent, style);
        this.orientation = orientation;
        this.context = context;
        this.init(grid);
        this.placeComponents();
    }

    public GridAttributesComposite(Composite parent, int style, ChartWizardContext context, Grid grid, boolean bLineGroupEnabled) {
        super(parent, style);
        this.bLineGroupEnabled = bLineGroupEnabled;
        this.context = context;
        this.init(grid);
        this.placeComponents();
    }

    private void init(Grid grid) {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
        this.grid = grid;
        this.vListeners = new Vector();
    }

    private void placeComponents() {
        boolean bTicksEnabled;
        FillLayout flMain = new FillLayout();
        flMain.marginHeight = 4;
        flMain.marginWidth = 2;
        GridLayout glContent = new GridLayout();
        glContent.verticalSpacing = 5;
        glContent.horizontalSpacing = 5;
        glContent.marginHeight = 0;
        glContent.marginWidth = 0;
        glContent.numColumns = 2;
        GridLayout glTicks = new GridLayout();
        glTicks.marginHeight = 4;
        glTicks.marginWidth = 4;
        glTicks.verticalSpacing = 2;
        glTicks.horizontalSpacing = 5;
        glTicks.numColumns = 2;
        this.setLayout((Layout)flMain);
        this.cmpContent = new Composite((Composite)this, 0);
        this.cmpContent.setLayout((Layout)glContent);
        if (this.bLineGroupEnabled) {
            FillLayout flLines = new FillLayout();
            flLines.marginHeight = 1;
            flLines.marginWidth = 1;
            this.cmpLines = new Composite(this.cmpContent, 0);
            GridData gdCMPLines = new GridData(1808);
            gdCMPLines.horizontalSpan = 2;
            this.cmpLines.setLayoutData((Object)gdCMPLines);
            this.cmpLines.setLayout((Layout)flLines);
            this.liacLines = new LineAttributesComposite(this.cmpLines, 0, this.context, this.grid.getLineAttributes(), true, true, true);
            this.liacLines.addListener(this);
            this.liacLines.setAttributesEnabled(ChartUIUtil.is3DWallFloorSet((Chart)this.context.getModel()));
        }
        boolean bl = bTicksEnabled = this.context.getModel().getDimension().getValue() != 2;
        if (bTicksEnabled) {
            Group grpTicks = new Group(this.cmpContent, 0);
            GridData gdGRPTicks = new GridData(1808);
            gdGRPTicks.horizontalSpan = 2;
            grpTicks.setLayoutData((Object)gdGRPTicks);
            grpTicks.setLayout((Layout)glTicks);
            grpTicks.setText(Messages.getString("GridAttributesComposite.Lbl.Ticks"));
            this.liacTicks = new LineAttributesComposite((Composite)grpTicks, 0, this.context, this.grid.getTickAttributes(), false, false, true);
            GridData gdLIACTicks = new GridData(768);
            gdLIACTicks.horizontalSpan = 2;
            this.liacTicks.setLayoutData(gdLIACTicks);
            this.liacTicks.addListener(this);
            this.lblStyle = new Label((Composite)grpTicks, 0);
            GridData gdLBLStyle = new GridData();
            gdLBLStyle.horizontalIndent = 4;
            this.lblStyle.setLayoutData((Object)gdLBLStyle);
            this.lblStyle.setText(Messages.getString("GridAttributesComposite.Lbl.Style"));
            this.lblStyle.setEnabled(this.grid.getTickAttributes().isVisible());
            this.cmbTickStyle = new Combo((Composite)grpTicks, 12);
            GridData gdCMBTickStyle = new GridData(768);
            this.cmbTickStyle.setLayoutData((Object)gdCMBTickStyle);
            this.cmbTickStyle.addSelectionListener((SelectionListener)this);
            this.cmbTickStyle.setEnabled(this.grid.getTickAttributes().isVisible());
            this.populateLists();
            this.setDefaultSelections();
        }
    }

    private void populateLists() {
        if (this.orientation == 0) {
            this.cmbTickStyle.setItems(LiteralHelper.horizontalTickStyleSet.getDisplayNames());
        } else if (this.orientation == 1) {
            this.cmbTickStyle.setItems(LiteralHelper.verticalTickStyleSet.getDisplayNames());
        }
    }

    private void setDefaultSelections() {
        if (this.grid.getTickStyle() == null) {
            this.cmbTickStyle.select(0);
            return;
        }
        if (this.orientation == 0) {
            this.cmbTickStyle.select(LiteralHelper.horizontalTickStyleSet.getSafeNameIndex(this.grid.getTickStyle().getName()));
        } else if (this.orientation == 1) {
            this.cmbTickStyle.select(LiteralHelper.verticalTickStyleSet.getSafeNameIndex(this.grid.getTickStyle().getName()));
        }
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.cmbTickStyle)) {
            Event eGrid = new Event();
            eGrid.widget = this;
            eGrid.type = 5;
            TickStyle tsGrid = TickStyle.getByName((String)LiteralHelper.fullTickStyleSet.getNameByDisplayName(this.cmbTickStyle.getText()));
            eGrid.data = tsGrid;
            this.fireEvent(eGrid);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Point getPreferredSize() {
        return new Point(230, 240);
    }

    public void handleEvent(Event event) {
        Event eGrid = new Event();
        eGrid.widget = this;
        if (event.widget.equals((Object)this.liacLines)) {
            if (event.type == 1) {
                eGrid.type = 1;
                eGrid.data = event.data;
            } else if (event.type == 2) {
                eGrid.type = 2;
                eGrid.data = event.data;
            } else if (event.type == 3) {
                eGrid.type = 3;
                eGrid.data = event.data;
            } else {
                eGrid.type = 4;
                eGrid.data = event.data;
            }
        } else if (event.widget.equals((Object)this.liacTicks)) {
            if (event.type == 3) {
                eGrid.type = 6;
                eGrid.data = event.data;
                this.grid.getTickAttributes().setColor((ColorDefinition)event.data);
            } else {
                eGrid.type = 7;
                eGrid.data = event.data;
                this.grid.getTickAttributes().setVisible(((Boolean)event.data).booleanValue());
                this.lblStyle.setEnabled(((Boolean)event.data).booleanValue());
                this.cmbTickStyle.setEnabled(((Boolean)event.data).booleanValue());
            }
        } else {
            return;
        }
        this.fireEvent(eGrid);
    }

    private void fireEvent(Event event) {
        int i = 0;
        while (i < this.vListeners.size()) {
            ((Listener)this.vListeners.get(i)).handleEvent(event);
            ++i;
        }
    }
}

