/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw3d.graphics3d.Graphics3DDescriptor;
import org.eclipse.draw3d.graphics3d.Graphics3DType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graphics3DRegistry {
    private static final Logger log = Logger.getLogger(Graphics3DRegistry.class.getName());
    private static final List<Graphics3DDescriptor> descriptors = new Vector<Graphics3DDescriptor>();
    public static final String GRAPHICS3D_EP = "org.eclipse.draw3d.graphics3d";

    public static Graphics3DDescriptor getDefaultScreenRenderer() {
        Graphics3DRegistry.updateDescriptors();
        for (Graphics3DDescriptor descr : descriptors) {
            if (descr.getType() != Graphics3DType.SCREEN) continue;
            return descr;
        }
        log.severe("No screen renderer not found");
        return null;
    }

    public static Graphics3DDescriptor getRenderer(String i_rendererID) {
        Graphics3DRegistry.updateDescriptors();
        for (Graphics3DDescriptor descr : descriptors) {
            if (!descr.getRendererID().equals(i_rendererID)) continue;
            return descr;
        }
        log.warning("Renderer with id " + i_rendererID + " not found");
        return null;
    }

    public static List<Graphics3DDescriptor> getRenderersForType(Graphics3DType type) {
        Graphics3DRegistry.updateDescriptors();
        ArrayList<Graphics3DDescriptor> result = new ArrayList<Graphics3DDescriptor>();
        for (Graphics3DDescriptor descr : descriptors) {
            if (descr.getType() != type) continue;
            result.add(descr);
        }
        return result;
    }

    public static void resetDescriptors() {
        descriptors.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateDescriptors() {
        List<Graphics3DDescriptor> list = descriptors;
        synchronized (list) {
            IExtension[] extensions;
            if (descriptors.size() > 0) {
                return;
            }
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(GRAPHICS3D_EP);
            if (point == null) {
                log.severe("Extension point 'org.eclipse.draw3d.graphics3d' not found");
                return;
            }
            IExtension[] iExtensionArray = extensions = point.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] ices;
                IExtension extension = iExtensionArray[n2];
                String strContributorName = extension.getContributor().getName();
                if (log.isLoggable(Level.INFO)) {
                    log.info("Extension found: " + extension + ", Contributor: " + strContributorName);
                }
                IConfigurationElement[] iConfigurationElementArray = ices = extension.getConfigurationElements();
                int n3 = ices.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals("renderer")) {
                        Graphics3DDescriptor descriptor = new Graphics3DDescriptor();
                        descriptor.setContributorName(strContributorName);
                        descriptor.setRendererID(element.getAttribute("id"));
                        descriptor.setClassname(element.getAttribute("class"));
                        descriptor.setType(Graphics3DType.valueOf(element.getAttribute("type")));
                        IConfigurationElement name = element.getChildren("name")[0];
                        descriptor.setName(name.getValue());
                        IConfigurationElement descr = element.getChildren("description")[0];
                        descriptor.setDescription(descr.getValue());
                        IConfigurationElement[] params = element.getChildren("parameter");
                        if (params != null) {
                            IConfigurationElement[] iConfigurationElementArray2 = params;
                            int n5 = params.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IConfigurationElement param = iConfigurationElementArray2[n6];
                                descriptor.getParameters().setProperty(param.getAttribute("name"), param.getAttribute("value"));
                                ++n6;
                            }
                        }
                        descriptors.add(descriptor);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        if (descriptors.size() == 0) {
            log.severe("No plugins for extension point 'org.eclipse.draw3d.graphics3d' found");
            return;
        }
    }
}

