/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.axf.ide;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.amp.axf.core.IEngine;
import org.eclipse.amp.axf.core.ILifeCycleListener;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.core.IObservationProvider;
import org.eclipse.amp.axf.ide.AXFWorkbenchPlugin;
import org.eclipse.amp.axf.ide.LifeCycleListeners;
import org.eclipse.amp.axf.ide.ModelManagerListeners;
import org.eclipse.amp.axf.ide.ModelManagerViewPart;
import org.eclipse.amp.axf.ide.view.StatusLineView;
import org.eclipse.amp.axf.view.IModelPart;
import org.eclipse.amp.axf.view.ModelInput;
import org.eclipse.amp.axf.view.ModelViewPart;
import org.eclipse.amp.axf.view.SelectionSynchronizer;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.ErrorViewPart;
import org.eclipse.ui.statushandlers.StatusManager;

public class ModelViewManager
implements IAdapterFactory {
    public static final String EXECUTION_PERSPECTIVE_ID = "org.eclipse.amp.axf.ExecutionPerspective";
    private static ModelViewManager instance;
    String priorPerspectiveID;
    Map<IModel, List<IViewPart>> viewsForModel;
    ModelManagerListeners managerListeners = new ModelManagerListeners();
    String executionPerspective = "org.eclipse.amp.axf.ExecutionPerspective";
    IContextService contextService;
    IContextActivation ideContext;
    IContextActivation partContext;
    private List<IModel> models = new ArrayList<IModel>();
    private List<IViewPart> views = new ArrayList<IViewPart>();
    private Map<IModel, IEngine> runnerForModel;
    private Map<IEngine, IModel> modelForRunner = new HashMap<IEngine, IModel>();
    private Map<Object, IModel> modelForArbitrary = new HashMap<Object, IModel>();
    private LifeCycleListeners activeModelListeners = new LifeCycleListeners();
    private IModel activeModel;
    private IPartListener modelActivationListener;
    private IObservationProvider[] modelSlots = new IObservationProvider[16];
    private SelectionSynchronizer editSelection;
    private StatusLineView statusLineView;
    private ModelManagerViewPart managerViewPart;

    private ModelViewManager() {
    }

    public static ModelViewManager getInstance() {
        if (instance == null) {
            instance = new ModelViewManager();
        }
        return instance;
    }

    static ModelViewManager createNewInstance() {
        instance = null;
        return ModelViewManager.getInstance();
    }

    public IModel getActiveModel() {
        return this.activeModel;
    }

    public synchronized void setActiveModel(IModel newModel) {
        if (newModel != null && !this.models.contains(newModel)) {
            return;
        }
        IModel oldModel = this.activeModel;
        this.activeModel = newModel;
        if (newModel != oldModel) {
            this.getActiveModelListeners().replaceModel(oldModel, newModel);
            if (newModel != null) {
                this.managerListeners.notifyModelActivated(newModel);
            }
        }
    }

    public List<IModel> getModels() {
        return this.models;
    }

    public int getSlot(IObservationProvider model) {
        int i = 0;
        IObservationProvider[] iObservationProviderArray = this.modelSlots;
        int n = this.modelSlots.length;
        int n2 = 0;
        while (n2 < n) {
            IObservationProvider slot = iObservationProviderArray[n2];
            if (slot == model) {
                return i;
            }
            ++i;
            ++n2;
        }
        return -1;
    }

    public int assignSlot(IObservationProvider model) {
        int i = 0;
        IObservationProvider[] iObservationProviderArray = this.modelSlots;
        int n = this.modelSlots.length;
        int n2 = 0;
        while (n2 < n) {
            IObservationProvider slot = iObservationProviderArray[n2];
            if (slot == null) {
                this.modelSlots[i] = model;
                return i;
            }
            ++i;
            ++n2;
        }
        StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.amp.axf.ui", "Currently, the execution engine only supports " + this.modelSlots.length + " slots. The UI may not perform properly."));
        return -1;
    }

    public int releaseSlot(IObservationProvider model) {
        int i = 0;
        IObservationProvider[] iObservationProviderArray = this.modelSlots;
        int n = this.modelSlots.length;
        int n2 = 0;
        while (n2 < n) {
            IObservationProvider slot = iObservationProviderArray[n2];
            if (slot == model) {
                this.modelSlots[i] = null;
                return i;
            }
            ++i;
            ++n2;
        }
        throw new RuntimeException(model + " has not been assigned to a slot.");
    }

    public synchronized void register(IModel model, IEngine executor, Object modelObject) {
        if (model == null) {
            throw new RuntimeException("Tried to register a null model.");
        }
        if (executor == null) {
            throw new RuntimeException("Tried to register a null executor.");
        }
        if (this.modelActivationListener == null) {
            this.activate();
        }
        this.models.add(model);
        this.modelForRunner.put(executor, model);
        this.runnerForModel.put(model, executor);
        this.assignSlot((IObservationProvider)model);
        if (modelObject != null) {
            this.modelForArbitrary.put(modelObject, model);
        }
        this.managerListeners.notifyModelAdded(model);
        this.viewsForModel.put(model, new ArrayList());
        this.setActiveModel(model);
    }

    public void register(IModel model, IEngine executor) {
        this.register(model, executor, null);
    }

    public synchronized void register(IViewPart part) {
        this.views.add(part);
    }

    public synchronized void removed(IViewPart part) {
        this.views.remove(part);
        List<IViewPart> modelViews = this.getViews(this.activeModel);
        if (modelViews != null) {
            modelViews.remove(part);
        }
        this.managerListeners.notifyViewRemoved(part);
    }

    public List<IViewPart> getViews(IModel model) {
        return this.viewsForModel.get(model);
    }

    public IViewPart createViewPart(String id, ModelInput editorInput, String name) {
        PartCreator creator = new PartCreator(name, editorInput, id);
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)creator);
        return creator.getPart();
    }

    public void closeView(final IViewPart part) {
        if (PlatformUI.getWorkbench() != null) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (!display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
                        if (workbenchWindow != null && workbenchWindow.getActivePage() != null) {
                            workbenchWindow.getActivePage().hideView(part);
                        }
                    }
                });
            }
        } else {
            new Thread(){

                @Override
                public void run() {
                    ModelViewManager.this.removed(part);
                }
            }.start();
        }
    }

    public synchronized void remove(IModel model) {
        if (this.models.remove(model)) {
            this.modelForRunner.remove(model.getEngine());
            this.runnerForModel.remove(model);
            this.managerListeners.notifyModelRemoved(model);
            for (IViewPart part : this.viewsForModel.get(model)) {
                this.closeView(part);
            }
            this.viewsForModel.remove(model);
            ArrayList<Object> arbitraries = new ArrayList<Object>();
            for (Map.Entry<Object, IModel> entry : this.modelForArbitrary.entrySet()) {
                if (entry.getValue() != model) continue;
                arbitraries.add(entry.getKey());
            }
            for (Map.Entry<Object, Object> entry : arbitraries) {
                this.modelForArbitrary.remove(entry);
            }
            this.releaseSlot((IObservationProvider)model);
            if (!model.getEngine().isCloseRequested()) {
                model.getEngine().close();
            }
            if (this.models.size() > 0) {
                this.setActiveModel(this.models.get(this.models.size() - 1));
            } else {
                this.setActiveModel(null);
                this.deactivate();
            }
        } else {
            StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.amp.axf.ui", "Removing a model that no longer exists:" + model, (Throwable)new Exception()));
        }
    }

    private IWorkbenchPage getPage() {
        IWorkbench wb = AXFWorkbenchPlugin.getDefault().getWorkbench();
        return wb.getWorkbenchWindows()[0].getPages()[0];
    }

    private synchronized void activate() {
        final IWorkbench wb = AXFWorkbenchPlugin.getDefault().getWorkbench();
        wb.addWorkbenchListener(new IWorkbenchListener(){

            public void postShutdown(IWorkbench workbench) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                if (!forced) {
                    ModelViewManager modelViewManager = ModelViewManager.this;
                    synchronized (modelViewManager) {
                        for (IModel model : new ArrayList<IModel>(ModelViewManager.this.getModels())) {
                            ModelViewManager.this.remove(model);
                        }
                    }
                }
                return true;
            }
        });
        this.viewsForModel = new HashMap<IModel, List<IViewPart>>();
        this.runnerForModel = new HashMap<IModel, IEngine>();
        this.modelActivationListener = new ActivationListener();
        this.activeModelListeners = new LifeCycleListeners();
        this.getPage().addPartListener(this.modelActivationListener);
        this.statusLineView = StatusLineView.getDefault();
        this.getPage().addPartListener((IPartListener)this.statusLineView);
        this.getActiveModelListeners().addListener((ILifeCycleListener)this.statusLineView);
        this.activatePerspective(wb, this.executionPerspective, false);
        wb.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ModelViewManager.this.contextService = (IContextService)wb.getService(IContextService.class);
                    ModelViewManager.this.ideContext = ModelViewManager.this.contextService.activateContext("org.eclipse.amp.axf.executionContext");
                    ModelViewManager.this.partContext = ModelViewManager.this.contextService.activateContext("org.eclipse.amp.axf.activeEditorContext");
                }
                catch (Exception e) {
                    throw new RuntimeException("Couldn't activate services.", e);
                }
            }
        });
    }

    private void activatePerspective(final IWorkbench wb, final String perspectiveID, final boolean editors) {
        wb.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IPerspectiveDescriptor perspective = wb.getPerspectiveRegistry().findPerspectiveWithId(perspectiveID);
                if (perspective != null) {
                    IWorkbenchPage activePage;
                    IWorkbenchPage iWorkbenchPage = activePage = wb.getActiveWorkbenchWindow() != null ? wb.getActiveWorkbenchWindow().getActivePage() : null;
                    if (activePage != null) {
                        if (ModelViewManager.this.priorPerspectiveID == null || !activePage.getPerspective().getId().equals(ModelViewManager.this.executionPerspective)) {
                            ModelViewManager.this.priorPerspectiveID = activePage.getPerspective().getId();
                        }
                        activePage.setPerspective(perspective);
                        activePage.setEditorAreaVisible(editors);
                    }
                }
            }
        });
    }

    private synchronized void deactivate() {
        IWorkbench wb = AXFWorkbenchPlugin.getDefault().getWorkbench();
        if (wb != null) {
            wb.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ModelViewManager.this.contextService != null) {
                        ModelViewManager.this.contextService.deactivateContext(ModelViewManager.this.ideContext);
                        ModelViewManager.this.contextService.deactivateContext(ModelViewManager.this.partContext);
                    }
                }
            });
            this.getPage().removePartListener(this.modelActivationListener);
            this.getPage().removePartListener((IPartListener)this.statusLineView);
            if (this.priorPerspectiveID != null) {
                this.activatePerspective(wb, this.priorPerspectiveID, true);
            }
            this.modelActivationListener = null;
            this.statusLineView = null;
            this.activeModelListeners = null;
        }
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IEngine.class && adaptableObject instanceof IModel) {
            return this.runnerForModel.get(adaptableObject);
        }
        if (adapterType == IModel.class) {
            if (adaptableObject instanceof IEngine) {
                return this.modelForRunner.get(adaptableObject);
            }
            return this.modelForArbitrary.get(adaptableObject);
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IEngine.class, IModel.class};
    }

    public SelectionSynchronizer getSelectionSynchronizer() {
        return this.editSelection;
    }

    public void setSelectionSynchronizer(SelectionSynchronizer editSelection) {
        if (this.editSelection != null) {
            editSelection.replace(this.editSelection);
        }
        this.editSelection = editSelection;
    }

    public ModelManagerListeners getManagerListeners() {
        return this.managerListeners;
    }

    public LifeCycleListeners getActiveModelListeners() {
        return this.activeModelListeners;
    }

    public ModelManagerViewPart getManagerViewPart() {
        return this.managerViewPart;
    }

    public void setManagerViewPart(ModelManagerViewPart managerViewPart) {
        this.managerViewPart = managerViewPart;
    }

    public String getExecutionPerspective() {
        return this.executionPerspective;
    }

    public void setExecutionPerspective(String executionPerspective) {
        this.executionPerspective = executionPerspective;
    }

    final class ActivationListener
    implements IPartListener {
        ActivationListener() {
        }

        private void assignPart(final IWorkbenchPart part) {
            if (part instanceof IModelPart && ((IModelPart)part).getAdapter(IModel.class) != null) {
                new Thread(){

                    @Override
                    public void run() {
                        IModel model = (IModel)((IModelPart)part).getAdapter(IModel.class);
                        ModelViewManager.this.setActiveModel(model);
                    }
                }.start();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            this.assignPart(part);
        }

        public void partActivated(IWorkbenchPart part) {
            this.assignPart(part);
        }

        public void partClosed(final IWorkbenchPart part) {
            if (part instanceof IModelPart && ((IModelPart)part).getAdapter(IModel.class) != null) {
                new Thread(){

                    @Override
                    public void run() {
                        ModelViewManager.this.removed((IViewPart)part);
                    }
                }.start();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            this.assignPart(part);
        }
    }

    private final class PartCreator
    implements Runnable {
        private final String name;
        private final ModelInput editorInput;
        private final String id;
        IViewPart part;

        PartCreator(String name, ModelInput editorInput, String id) {
            this.name = name;
            this.editorInput = editorInput;
            this.id = id;
        }

        @Override
        public void run() {
            try {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = workbenchWindow.getActivePage();
                int slot = ModelViewManager.this.getSlot((IObservationProvider)this.editorInput.getModel());
                String secondaryID = String.valueOf(slot);
                int viewCount = 0;
                for (IViewPart view : ModelViewManager.this.viewsForModel.get(this.editorInput.getModel())) {
                    if (!view.getViewSite().getId().equals(this.id)) continue;
                    ++viewCount;
                }
                secondaryID = String.valueOf(secondaryID) + "-" + viewCount;
                this.part = page.showView(this.id, secondaryID, 2);
                if (this.part instanceof ModelViewPart) {
                    ModelViewManager.this.register(this.part);
                    ((ModelViewPart)this.part).setInput((IEditorInput)this.editorInput);
                    ((ModelViewPart)this.part).setPartName(String.valueOf(this.editorInput.getName()) + " " + this.name);
                    ((ModelViewPart)this.part).createModelListeners();
                    ModelViewManager.this.getViews(this.editorInput.getModel()).add(this.part);
                    new Thread(){

                        @Override
                        public void run() {
                            ((PartCreator)PartCreator.this).ModelViewManager.this.managerListeners.notifyViewAdded(PartCreator.this.part);
                        }
                    }.start();
                } else if (!(this.part instanceof ErrorViewPart)) {
                    throw new RuntimeException("Couldn't create model view part.");
                }
            }
            catch (PartInitException e) {
                throw new RuntimeException("Couldn't instantiate model view " + this.id, e);
            }
        }

        public IViewPart getPart() {
            return this.part;
        }
    }
}

