/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl;

import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.geometry.IMatrix3f;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector2f;
import org.eclipse.draw3d.geometry.Vector2fImpl;
import org.eclipse.draw3d.graphics.optimizer.PrimitiveSet;
import org.eclipse.draw3d.graphics.optimizer.RecordingGraphics;
import org.eclipse.draw3d.graphics.optimizer.classification.PrimitiveClass;
import org.eclipse.draw3d.graphics.optimizer.classification.PrimitiveClassifier;
import org.eclipse.draw3d.graphics.optimizer.primitive.PolygonPrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.Primitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.RenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.SolidRenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.TextPrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.TextRenderRule;
import org.eclipse.draw3d.graphics3d.AbstractGraphics3DDraw;
import org.eclipse.draw3d.graphics3d.DisplayListManager;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.Graphics3DDescriptor;
import org.eclipse.draw3d.graphics3d.Graphics3DException;
import org.eclipse.draw3d.graphics3d.Graphics3DOffscreenBufferConfig;
import org.eclipse.draw3d.graphics3d.Graphics3DOffscreenBuffers;
import org.eclipse.draw3d.graphics3d.ILodHelper;
import org.eclipse.draw3d.graphics3d.RenderImage;
import org.eclipse.draw3d.graphics3d.lwjgl.TextRenderImage;
import org.eclipse.draw3d.graphics3d.lwjgl.font.GLFontKey;
import org.eclipse.draw3d.graphics3d.lwjgl.font.LwjglFont;
import org.eclipse.draw3d.graphics3d.lwjgl.font.LwjglFontManager;
import org.eclipse.draw3d.graphics3d.lwjgl.font.LwjglVectorFont;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglGradientQuadVBO;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglImageVBO;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglLineVBO;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglPolygonVBO;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglPolylineVBO;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglPrimitiveClassifier;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglQuadVBO;
import org.eclipse.draw3d.graphics3d.lwjgl.offscreen.LwjglOffscreenBackBuffers;
import org.eclipse.draw3d.graphics3d.lwjgl.offscreen.LwjglOffscreenBufferConfig;
import org.eclipse.draw3d.graphics3d.lwjgl.offscreen.LwjglOffscreenBuffersFbo;
import org.eclipse.draw3d.graphics3d.lwjgl.texture.LwjglTextureFbo;
import org.eclipse.draw3d.graphics3d.lwjgl.texture.LwjglTextureManager;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.draw3d.util.LogGraphics;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.opengl.GLCanvas;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.glu.GLUtessellator;
import org.lwjgl.util.glu.GLUtessellatorCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graphics3DLwjgl
extends AbstractGraphics3DDraw
implements Graphics3D {
    private static final float OFFSET_2DCONTENT_SURFACE = -0.2f;
    private static final int ATTRIB_MASK = 537164109;
    private static final Logger log = Logger.getLogger(Graphics3DLwjgl.class.getName());
    public static final float RASTER_OFFSET = 0.0f;
    protected Graphics3DDescriptor descriptor;
    final int hashCode;
    private Graphics m_activeGraphics;
    public GLCanvas m_context = null;
    private DisplayListManager m_displayListManager = null;
    private LwjglFontManager m_fontManager;
    private boolean m_log2D;
    private GLUtessellator m_tesselator;
    private LwjglTextureManager m_textureManager = null;
    private Map<GLFontKey, LwjglVectorFont> m_vectorFonts = new HashMap<GLFontKey, LwjglVectorFont>();
    Properties properties = new Properties();
    static Boolean checked = null;
    private IPosition3D m_current2DPosition;

    public Graphics3DLwjgl() {
        this.hashCode = super.hashCode();
        if (log.isLoggable(Level.INFO)) {
            log.info("Graphics3DLwjgl constructor called");
        }
    }

    void check() {
        if (checked == null) {
            checked = false;
            try {
                try {
                    Display.setFullscreen((boolean)false);
                    Display.setDisplayMode((DisplayMode)new DisplayMode(10, 10));
                    Display.create();
                    GLContext.useContext((Object)this.m_context);
                    ContextCapabilities caps = GLContext.getCapabilities();
                    float version = Graphics3DLwjgl.openGLVersions(caps);
                    if (version < 1.5f) {
                        throw new Graphics3DException("Need at least OpenGL version 1.5, found only " + version);
                    }
                    checked = true;
                }
                catch (LWJGLException ex) {
                    throw new Graphics3DException("Cannot retrieve OpenGL capabilies, error creating LWJGL display", (Throwable)ex);
                }
            }
            finally {
                Display.destroy();
            }
        }
    }

    static float openGLVersions(ContextCapabilities caps) {
        float v = 0.0f;
        if (caps.OpenGL11) {
            v = 1.1f;
        }
        if (caps.OpenGL12) {
            v = 1.2f;
        }
        if (caps.OpenGL13) {
            v = 1.3f;
        }
        if (caps.OpenGL14) {
            v = 1.4f;
        }
        if (caps.OpenGL15) {
            v = 1.5f;
        }
        if (caps.OpenGL20) {
            v = 2.0f;
        }
        if (caps.OpenGL21) {
            v = 2.1f;
        }
        if (caps.OpenGL30) {
            v = 3.0f;
        }
        if (caps.OpenGL31) {
            v = 3.1f;
        }
        if (caps.OpenGL32) {
            v = 3.2f;
        }
        return v;
    }

    public Graphics begin2DRendering(Object i_key, IPosition3D i_position, int i_width, int i_height) {
        this.m_activeGraphics = new RecordingGraphics((PrimitiveClassifier)new LwjglPrimitiveClassifier());
        this.m_current2DPosition = i_position;
        if (this.m_log2D) {
            return new LogGraphics(this.m_activeGraphics);
        }
        return this.m_activeGraphics;
    }

    private LwjglVectorFont getVectorFont(Font i_swtFont, char i_startChar, char i_endChar, boolean i_antialias) {
        GLFontKey key = new GLFontKey(i_swtFont, i_startChar, i_endChar, i_antialias);
        LwjglVectorFont vectorFont = this.m_vectorFonts.get(key);
        if (vectorFont == null) {
            vectorFont = new LwjglVectorFont(i_swtFont, i_startChar, i_endChar, i_antialias);
            vectorFont.initialize();
            this.m_vectorFonts.put(key, vectorFont);
        }
        return vectorFont;
    }

    public RenderImage deactivateGraphics2D() {
        IPosition3D pos2d = this.m_current2DPosition;
        if (this.m_activeGraphics instanceof RecordingGraphics) {
            RecordingGraphics og = (RecordingGraphics)this.m_activeGraphics;
            List primiveSets = og.getPrimiveSets();
            final LinkedList<RenderImage> vbos = new LinkedList<RenderImage>();
            for (PrimitiveSet set : primiveSets) {
                PrimitiveClass clazz = set.getPrimitiveClass();
                if (clazz.isPolygon()) {
                    this.tesselate(set, vbos);
                    continue;
                }
                if (clazz.isQuad()) {
                    if (clazz.isGradient()) {
                        vbos.add(new LwjglGradientQuadVBO(set));
                        continue;
                    }
                    if (clazz.isImage()) {
                        vbos.add(new LwjglImageVBO(set));
                        continue;
                    }
                    vbos.add(new LwjglQuadVBO(set));
                    continue;
                }
                if (clazz.isPolyline()) {
                    vbos.add(new LwjglPolylineVBO(set));
                    continue;
                }
                if (clazz.isLine()) {
                    vbos.add(new LwjglLineVBO(set));
                    continue;
                }
                if (clazz.isText()) {
                    TextRenderRule textRule = clazz.getRenderRule().asText();
                    LwjglVectorFont vectorFont = this.getVectorFont(textRule.getFont(), ' ', '\u007f', true);
                    LwjglFont textureFont = this.getFontManager().getFont(textRule.getFont(), ' ', '\u007f', true);
                    final LinkedList<TextRenderImage> textImages = new LinkedList<TextRenderImage>();
                    for (Primitive primitive : set.getPrimitives()) {
                        TextPrimitive text = (TextPrimitive)primitive;
                        textImages.add(new TextRenderImage(text, vectorFont, textureFont, this.m_current2DPosition));
                    }
                    vbos.add(new RenderImage(){

                        public void dispose() {
                            for (TextRenderImage image : textImages) {
                                image.dispose();
                            }
                            textImages.clear();
                        }

                        public void initialize(Graphics3D i_g3d) {
                            for (TextRenderImage image : textImages) {
                                image.initialize(i_g3d);
                            }
                        }

                        public void render(Graphics3D i_g3d, ILodHelper i_lodHelper) {
                            for (TextRenderImage image : textImages) {
                                image.render(i_g3d, i_lodHelper);
                            }
                        }
                    });
                    continue;
                }
                throw new AssertionError((Object)("unknown primitive class: " + clazz));
            }
            this.m_current2DPosition = null;
            return new RenderImage(){

                public void dispose() {
                    for (RenderImage vbo : vbos) {
                        vbo.dispose();
                    }
                }

                public void initialize(Graphics3D i_g3d) {
                    for (RenderImage vbo : vbos) {
                        vbo.initialize(i_g3d);
                    }
                }

                public void render(Graphics3D i_g3d, ILodHelper i_lodContext) {
                    GL11.glMatrixMode((int)5888);
                    GL11.glPushMatrix();
                    try {
                        for (RenderImage vbo : vbos) {
                            Graphics3DLwjgl.this.glTranslatef(0.0f, 0.0f, -0.2f);
                            vbo.render(i_g3d, i_lodContext);
                        }
                    }
                    finally {
                        GL11.glPopMatrix();
                    }
                }
            };
        }
        return null;
    }

    public void dispose() {
        try {
            if (this.m_textureManager != null) {
                this.m_textureManager.dispose();
            }
            if (this.m_fontManager != null) {
                this.m_fontManager.dispose();
            }
            if (this.m_displayListManager != null) {
                this.m_displayListManager.dispose();
            }
            if (this.m_tesselator != null) {
                this.m_tesselator.gluDeleteTess();
            }
            if (this.m_vectorFonts != null) {
                for (LwjglVectorFont font : this.m_vectorFonts.values()) {
                    font.dispose();
                }
                this.m_vectorFonts.clear();
                this.m_vectorFonts = null;
            }
        }
        catch (Exception ex) {
            log.warning("Error disposing texture manager: " + ex);
        }
    }

    private void generateVectorText(PrimitiveSet i_set, List<RenderImage> i_vbos) {
        if (this.m_tesselator == null) {
            this.m_tesselator = GLU.gluNewTess();
        }
        PolygonTesselator callback = new PolygonTesselator(i_set.getPrimitiveClass().getRenderRule());
        this.m_tesselator.gluTessCallback(100104, null);
        this.m_tesselator.gluTessCallback(100110, null);
        this.m_tesselator.gluTessCallback(100100, (GLUtessellatorCallback)callback);
        this.m_tesselator.gluTessCallback(100106, null);
        this.m_tesselator.gluTessCallback(100101, (GLUtessellatorCallback)callback);
        this.m_tesselator.gluTessCallback(100107, null);
        this.m_tesselator.gluTessCallback(100105, (GLUtessellatorCallback)callback);
        this.m_tesselator.gluTessCallback(100111, null);
        this.m_tesselator.gluTessCallback(100102, (GLUtessellatorCallback)callback);
        this.m_tesselator.gluTessCallback(100108, null);
        this.m_tesselator.gluTessCallback(100103, null);
        this.m_tesselator.gluTessCallback(100109, (GLUtessellatorCallback)callback);
        this.m_tesselator.gluTessProperty(100142, 0.0);
        this.m_tesselator.gluTessProperty(100141, 0.0);
        for (Primitive primitive : i_set.getPrimitives()) {
            TextPrimitive textPrimitive = (TextPrimitive)primitive;
            TextRenderRule textRule = textPrimitive.getRenderRule().asText();
            Font swtFont = textRule.getFont();
            FontData fontData = swtFont.getFontData()[0];
            String name = fontData.getName();
            int size = fontData.getHeight();
            int style = 0;
            if ((fontData.getStyle() & 1) != 0) {
                style |= 1;
            }
            if ((fontData.getStyle() & 2) != 0) {
                style |= 2;
            }
            java.awt.Font awtFont = new java.awt.Font(name, style, size);
            IMatrix3f t = textPrimitive.getTransformation();
            AffineTransform af = new AffineTransform(t.get(0, 0), t.get(0, 1), t.get(1, 0), t.get(1, 1), t.get(2, 0), t.get(2, 1));
            Point p = textPrimitive.getPosition();
            af.translate(p.x, p.y + size);
            String text = textPrimitive.getText();
            FontRenderContext rc = new FontRenderContext(null, true, true);
            GlyphVector glyphs = awtFont.createGlyphVector(rc, text);
            Shape outline = glyphs.getOutline();
            PathIterator path = outline.getPathIterator(af, 0.1);
            if (path.getWindingRule() == 0) {
                this.m_tesselator.gluTessProperty(100140, 100130.0);
            } else if (path.getWindingRule() == 1) {
                this.m_tesselator.gluTessProperty(100140, 100131.0);
            }
            double[] coords = new double[3];
            coords[2] = 0.0;
            this.m_tesselator.gluTessBeginPolygon((Object)glyphs);
            this.m_tesselator.gluTessNormal(0.0, 0.0, -1.0);
            while (!path.isDone()) {
                int type = path.currentSegment(coords);
                switch (type) {
                    case 0: {
                        this.m_tesselator.gluTessBeginContour();
                        this.m_tesselator.gluTessVertex(coords, 0, (Object)new Vector2fImpl((float)coords[0], (float)coords[1]));
                        break;
                    }
                    case 4: {
                        this.m_tesselator.gluTessEndContour();
                        break;
                    }
                    case 1: {
                        this.m_tesselator.gluTessVertex(coords, 0, (Object)new Vector2fImpl((float)coords[0], (float)coords[1]));
                    }
                }
                path.next();
            }
            this.m_tesselator.gluTessEndPolygon();
        }
        callback.addVBOs(i_vbos);
    }

    public Graphics3DDescriptor getDescriptor() {
        return this.descriptor;
    }

    public DisplayListManager getDisplayListManager() {
        if (this.m_displayListManager == null) {
            this.m_displayListManager = new DisplayListManager((Graphics3D)this);
        }
        return this.m_displayListManager;
    }

    private LwjglFontManager getFontManager() {
        if (this.m_fontManager == null) {
            this.m_fontManager = new LwjglFontManager(this.getDisplayListManager());
        }
        return this.m_fontManager;
    }

    public int getGraphics2DId(Object i_key) {
        LwjglTextureManager textureManager = this.getTextureManager();
        return textureManager.getTextureId(i_key);
    }

    public Graphics3DOffscreenBuffers getGraphics3DOffscreenBuffer(int i_height, int i_width, Graphics3DOffscreenBufferConfig i_bufferConfig) {
        if (LwjglTextureFbo.isSuppported()) {
            return new LwjglOffscreenBuffersFbo(i_height, i_width, i_bufferConfig);
        }
        return new LwjglOffscreenBackBuffers(i_height, i_width, i_bufferConfig);
    }

    public Graphics3DOffscreenBufferConfig getGraphics3DOffscreenBufferConfig(int i_buffers, int ... i_args) {
        return new LwjglOffscreenBufferConfig(this, i_buffers, i_args);
    }

    public String getID() {
        return Graphics3DLwjgl.class.getName();
    }

    public int getPlatform() {
        return LWJGLUtil.getPlatform();
    }

    public String getProperty(String i_key) {
        return this.properties.getProperty(i_key);
    }

    private LwjglTextureManager getTextureManager() {
        if (this.m_textureManager == null) {
            this.m_textureManager = new LwjglTextureManager(this.m_context, this.getDisplayListManager(), this.getFontManager());
        } else if (this.m_textureManager.isDisposed()) {
            throw new IllegalStateException("TextureManager is disposed");
        }
        return this.m_textureManager;
    }

    public void glBegin(int mode) {
        GL11.glBegin((int)mode);
    }

    public void glBindTexture(int target, int texture) {
        GL11.glBindTexture((int)target, (int)texture);
    }

    public void glBlendFunc(int sfactor, int dfactor) {
        GL11.glBlendFunc((int)sfactor, (int)dfactor);
    }

    public void glCallList(int list) {
        GL11.glCallList((int)list);
    }

    public void glClear(int mask) {
        GL11.glClear((int)mask);
    }

    public void glClearColor(float red, float green, float blue, float alpha) {
        GL11.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void glClearDepth(double depth) {
        GL11.glClearDepth((double)depth);
    }

    public void glColor3f(float red, float green, float blue) {
        GL11.glColor3f((float)red, (float)green, (float)blue);
    }

    public void glColor4f(float red, float green, float blue, float alpha) {
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void glDeleteLists(int list, int range) {
        GL11.glDeleteLists((int)list, (int)range);
    }

    public void glDisable(int cap) {
        GL11.glDisable((int)cap);
    }

    public void glEnable(int cap) {
        GL11.glEnable((int)cap);
    }

    public void glEnd() {
        GL11.glEnd();
    }

    public void glEndList() {
        GL11.glEndList();
    }

    public void glFinish() {
        GL11.glFinish();
    }

    public void glFlush() {
        GL11.glFlush();
    }

    public int glGenLists(int range) {
        return GL11.glGenLists((int)range);
    }

    public void glGetFloat(int pname, FloatBuffer params) {
        GL11.glGetFloat((int)pname, (FloatBuffer)params);
    }

    public void glGetInteger(int pname, IntBuffer params) {
        GL11.glGetInteger((int)pname, (IntBuffer)params);
    }

    public String glGetString(int name) {
        return GL11.glGetString((int)name);
    }

    public void glHint(int target, int mode) {
        GL11.glHint((int)target, (int)mode);
    }

    public boolean glIsEnabled(int cap) {
        return GL11.glIsEnabled((int)cap);
    }

    public void glLineStipple(int factor, short pattern) {
        GL11.glLineStipple((int)factor, (short)pattern);
    }

    public void glLineWidth(float width) {
        GL11.glLineWidth((float)width);
    }

    public void glLoadIdentity() {
        GL11.glLoadIdentity();
    }

    public void glMatrixMode(int mode) {
        GL11.glMatrixMode((int)mode);
    }

    public void glNewList(int list, int mode) {
        GL11.glNewList((int)list, (int)mode);
    }

    public void glNormal3f(float nx, float ny, float nz) {
        GL11.glNormal3f((float)nx, (float)ny, (float)nz);
    }

    public void glNormal3f(int nx, int ny, int nz) {
        GL11.glNormal3f((float)nx, (float)ny, (float)nz);
    }

    public void glPixelStorei(int pname, int param) {
        GL11.glPixelStorei((int)pname, (int)param);
    }

    public void glPointSize(float size) {
        GL11.glPointSize((float)size);
    }

    public void glPolygonMode(int face, int mode) {
        GL11.glPolygonMode((int)face, (int)mode);
    }

    public void glPopMatrix() {
        GL11.glPopMatrix();
    }

    public void glPushMatrix() {
        GL11.glPushMatrix();
    }

    public void glShadeModel(int mode) {
        GL11.glShadeModel((int)mode);
    }

    public void glTexCoord2f(float s, float t) {
        GL11.glTexCoord2f((float)s, (float)t);
    }

    public void glTexEnvi(int target, int pname, int param) {
        GL11.glTexEnvi((int)target, (int)pname, (int)param);
    }

    public void glTranslatef(float x, float y, float z) {
        GL11.glTranslatef((float)x, (float)y, (float)z);
    }

    public void gluLookAt(float eyex, float eyey, float eyez, float centerx, float centery, float centerz, float upx, float upy, float upz) {
        GLU.gluLookAt((float)eyex, (float)eyey, (float)eyez, (float)centerx, (float)centery, (float)centerz, (float)upx, (float)upy, (float)upz);
    }

    public void gluOrtho2D(int left, int right, int bottom, int top) {
        GLU.gluOrtho2D((float)left, (float)right, (float)bottom, (float)top);
    }

    public void gluPerspective(int fovy, float aspect, int zNear, int zFar) {
        GLU.gluPerspective((float)fovy, (float)aspect, (float)zNear, (float)zFar);
    }

    public void gluUnProject(int winx, int winy, float winz, FloatBuffer modelMatrix, FloatBuffer projMatrix, IntBuffer viewport, FloatBuffer obj_pos) {
        GLU.gluUnProject((float)winx, (float)winy, (float)winz, (FloatBuffer)modelMatrix, (FloatBuffer)projMatrix, (IntBuffer)viewport, (FloatBuffer)obj_pos);
    }

    public void glVertex2f(float x, float y) {
        GL11.glVertex2f((float)x, (float)y);
    }

    public void glVertex3f(float x, float y, float z) {
        GL11.glVertex3f((float)x, (float)y, (float)z);
    }

    public void glViewport(int x, int y, int width, int height) {
        GL11.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    public boolean hasGraphics2D(Object i_key) {
        LwjglTextureManager textureManager = this.getTextureManager();
        return textureManager.contains(i_key);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void setDescriptor(Graphics3DDescriptor i_graphics3DDescriptor) {
        this.descriptor = i_graphics3DDescriptor;
    }

    public void setGLCanvas(GLCanvas i_canvas) {
        if (this.m_textureManager != null) {
            throw new IllegalStateException("Texture manager already initialized, cannot set new canvas");
        }
        this.m_context = i_canvas;
        this.check();
    }

    public void setLog2D(boolean i_log2D) {
        this.m_log2D = i_log2D;
    }

    private void setMatrix(IMatrix4f i_matrix) {
        FloatBuffer buffer = Draw3DCache.getFloatBuffer((int)16);
        try {
            buffer.rewind();
            i_matrix.toBufferRowMajor(buffer);
            buffer.rewind();
            GL11.glMultMatrix((FloatBuffer)buffer);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnFloatBuffer((FloatBuffer[])new FloatBuffer[]{buffer});
            throw throwable;
        }
        Draw3DCache.returnFloatBuffer((FloatBuffer[])new FloatBuffer[]{buffer});
    }

    public void setPosition(IPosition3D i_position) {
        this.setMatrix(i_position.getTransformationMatrix());
    }

    public void setProperty(String key, String value) {
        if (value != null) {
            this.properties.setProperty(key, value);
        } else {
            this.properties.remove(key);
        }
    }

    private void tesselate(float[] i_vertices) {
        this.m_tesselator.gluTessBeginPolygon((Object)i_vertices);
        this.m_tesselator.gluTessNormal(0.0, 0.0, -1.0);
        this.m_tesselator.gluTessBeginContour();
        double[] coords = new double[3];
        coords[2] = 0.0;
        int i = 0;
        while (i < i_vertices.length / 2) {
            float x = i_vertices[2 * i];
            float y = i_vertices[2 * i + 1];
            coords[0] = x;
            coords[1] = y;
            Vector2fImpl v = new Vector2fImpl(x, y);
            this.m_tesselator.gluTessVertex(coords, 0, (Object)v);
            ++i;
        }
        this.m_tesselator.gluTessEndContour();
        this.m_tesselator.gluTessEndPolygon();
    }

    private void tesselate(PrimitiveSet i_set, List<RenderImage> i_vbos) {
        if (this.m_tesselator == null) {
            this.m_tesselator = GLU.gluNewTess();
        }
        RenderRule renderRule = i_set.getPrimitiveClass().getRenderRule();
        PolygonTesselator callback = new PolygonTesselator(renderRule);
        this.m_tesselator.gluTessCallback(100104, null);
        this.m_tesselator.gluTessCallback(100110, null);
        this.m_tesselator.gluTessCallback(100100, (GLUtessellatorCallback)callback);
        this.m_tesselator.gluTessCallback(100106, null);
        this.m_tesselator.gluTessCallback(100101, (GLUtessellatorCallback)callback);
        this.m_tesselator.gluTessCallback(100107, null);
        this.m_tesselator.gluTessCallback(100105, (GLUtessellatorCallback)callback);
        this.m_tesselator.gluTessCallback(100111, null);
        this.m_tesselator.gluTessCallback(100102, (GLUtessellatorCallback)callback);
        this.m_tesselator.gluTessCallback(100108, null);
        this.m_tesselator.gluTessCallback(100103, null);
        this.m_tesselator.gluTessCallback(100109, (GLUtessellatorCallback)callback);
        this.m_tesselator.gluTessProperty(100142, 0.0);
        if (renderRule.isOutline()) {
            this.m_tesselator.gluTessProperty(100141, 1.0);
            this.m_tesselator.gluTessProperty(100140, 100130.0);
        } else if (renderRule.isSolid()) {
            SolidRenderRule solid = renderRule.asSolid();
            this.m_tesselator.gluTessProperty(100141, 0.0);
            this.m_tesselator.gluTessProperty(100140, (double)(solid.getFillRule() == 1 ? 100130 : 100131));
        }
        for (Primitive primitive : i_set.getPrimitives()) {
            PolygonPrimitive polygon = (PolygonPrimitive)primitive;
            this.tesselate(polygon.getVertices());
        }
        callback.addVBOs(i_vbos);
    }

    public void useContext(Object context) throws Graphics3DException {
        try {
            GLContext.useContext((Object)context);
        }
        catch (LWJGLException ex) {
            throw new Graphics3DException((Throwable)ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PolygonTesselator
    implements GLUtessellatorCallback {
        private int m_currentType;
        private List<IVector2f> m_currentVertices = new LinkedList<IVector2f>();
        private LwjglPolygonVBO m_lineLoops;
        private RenderRule m_renderRule;
        private LwjglPolygonVBO m_triangleFans;
        private LwjglPolygonVBO m_triangleSets;
        private LwjglPolygonVBO m_triangleStrips;

        public PolygonTesselator(RenderRule i_renderRule) {
            if (i_renderRule == null) {
                throw new NullPointerException("i_renderRule must not be null");
            }
            this.m_renderRule = i_renderRule;
        }

        public void addVBOs(List<RenderImage> i_vbos) {
            if (this.m_lineLoops != null) {
                i_vbos.add(this.m_lineLoops);
            }
            if (this.m_triangleFans != null) {
                i_vbos.add(this.m_triangleFans);
            }
            if (this.m_triangleSets != null) {
                i_vbos.add(this.m_triangleSets);
            }
            if (this.m_triangleStrips != null) {
                i_vbos.add(this.m_triangleStrips);
            }
        }

        public void begin(int i_type) {
            this.m_currentType = i_type;
        }

        public void beginData(int i_type, Object i_polygonData) {
            throw new UnsupportedOperationException();
        }

        public void combine(double[] i_coords, Object[] i_data, float[] i_weight, Object[] i_outData) {
            Vector2fImpl v = new Vector2fImpl((float)i_coords[0], (float)i_coords[1]);
            i_outData[0] = v;
        }

        public void combineData(double[] i_coords, Object[] i_data, float[] i_weight, Object[] i_outData, Object i_polygonData) {
            throw new UnsupportedOperationException();
        }

        public void edgeFlag(boolean i_boundaryEdge) {
            throw new UnsupportedOperationException();
        }

        public void edgeFlagData(boolean i_boundaryEdge, Object i_polygonData) {
            throw new UnsupportedOperationException();
        }

        public void end() {
            switch (this.m_currentType) {
                case 6: {
                    if (this.m_triangleFans == null) {
                        this.m_triangleFans = new LwjglPolygonVBO(this.m_currentType, this.m_renderRule);
                    }
                    this.m_triangleFans.addPolygon(this.m_currentVertices);
                    break;
                }
                case 5: {
                    if (this.m_triangleStrips == null) {
                        this.m_triangleStrips = new LwjglPolygonVBO(this.m_currentType, this.m_renderRule);
                    }
                    this.m_triangleStrips.addPolygon(this.m_currentVertices);
                    break;
                }
                case 4: {
                    if (this.m_triangleSets == null) {
                        this.m_triangleSets = new LwjglPolygonVBO(this.m_currentType, this.m_renderRule);
                    }
                    this.m_triangleSets.addPolygon(this.m_currentVertices);
                    break;
                }
                case 2: {
                    if (this.m_lineLoops == null) {
                        this.m_lineLoops = new LwjglPolygonVBO(this.m_currentType, this.m_renderRule);
                    }
                    this.m_lineLoops.addPolygon(this.m_currentVertices);
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown polygon type: " + this.m_currentType);
                }
            }
            this.m_currentVertices.clear();
            this.m_currentType = 0;
        }

        public void endData(Object i_polygonData) {
            throw new UnsupportedOperationException();
        }

        public void error(int i_errnum) {
            throw new RuntimeException("error during polygon tesselation: " + i_errnum);
        }

        public void errorData(int i_errnum, Object i_polygonData) {
            throw new RuntimeException("error during polygon tesselation of polygon " + i_polygonData + ": " + i_errnum);
        }

        public void vertex(Object i_vertexData) {
            IVector2f v = (IVector2f)i_vertexData;
            this.m_currentVertices.add(v);
        }

        public void vertexData(Object i_vertexData, Object i_polygonData) {
            throw new UnsupportedOperationException();
        }
    }
}

