/**
 * <copyright>
 * </copyright>
 *
 * $Id: RunItemProvider.java,v 1.3 2010/03/25 03:01:38 mparker Exp $
 */
package org.eclipse.amp.amf.adata.provider;


import java.text.DateFormat;
import java.util.Collection;
import java.util.List;

import org.eclipse.amp.amf.adata.DataFactory;
import org.eclipse.amp.amf.adata.DataPackage;
import org.eclipse.amp.amf.adata.Run;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

/**
 * This is the item provider adapter for a {@link org.eclipse.amp.amf.adata.Run} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class RunItemProvider
extends ItemProviderAdapter
implements
IEditingDomainItemProvider, IStructuredItemContentProvider, ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource, ITableItemLabelProvider, ITableItemColorProvider, IItemColorProvider {
    /**
     * This constructs an instance from a factory and a notifier.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public RunItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    /**
     * This returns the property descriptors for the adapted class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);

            addModelPropertyDescriptor(object);
            addStartedPropertyDescriptor(object);
            addFinishedPropertyDescriptor(object);
            addEntriesPropertyDescriptor(object);
            addNamePropertyDescriptor(object);
        }
        return itemPropertyDescriptors;
    }

    /**
     * This adds a property descriptor for the Model feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected void addModelPropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
        (createItemPropertyDescriptor
         (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
          getResourceLocator(),
          getString("_UI_Run_model_feature"),
          getString("_UI_PropertyDescriptor_description", "_UI_Run_model_feature", "_UI_Run_type"),
          DataPackage.Literals.RUN__MODEL,
          true,
          false,
          true,
          null,
          null,
          null));
    }

    /**
     * This adds a property descriptor for the Started feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected void addStartedPropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
        (createItemPropertyDescriptor
         (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
          getResourceLocator(),
          getString("_UI_Run_started_feature"),
          getString("_UI_PropertyDescriptor_description", "_UI_Run_started_feature", "_UI_Run_type"),
          DataPackage.Literals.RUN__STARTED,
          true,
          false,
          false,
          ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
          null,
          null));
    }

    /**
     * This adds a property descriptor for the Finished feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected void addFinishedPropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
        (createItemPropertyDescriptor
         (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
          getResourceLocator(),
          getString("_UI_Run_finished_feature"),
          getString("_UI_PropertyDescriptor_description", "_UI_Run_finished_feature", "_UI_Run_type"),
          DataPackage.Literals.RUN__FINISHED,
          true,
          false,
          false,
          ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
          null,
          null));
    }

    /**
     * This adds a property descriptor for the Entries feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected void addEntriesPropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
        (createItemPropertyDescriptor
         (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
          getResourceLocator(),
          getString("_UI_Run_entries_feature"),
          getString("_UI_PropertyDescriptor_description", "_UI_Run_entries_feature", "_UI_Run_type"),
          DataPackage.Literals.RUN__ENTRIES,
          true,
          false,
          true,
          null,
          null,
          null));
    }

    /**
     * This adds a property descriptor for the Name feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected void addNamePropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
        (createItemPropertyDescriptor
         (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
          getResourceLocator(),
          getString("_UI_Run_name_feature"),
          getString("_UI_PropertyDescriptor_description", "_UI_Run_name_feature", "_UI_Run_type"),
          DataPackage.Literals.RUN__NAME,
          true,
          false,
          false,
          ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
          null,
          null));
    }

    /**
     * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
     * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
     * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (childrenFeatures == null) {
            super.getChildrenFeatures(object);
            childrenFeatures.add(DataPackage.Literals.RUN__PARAMETER_SETS);
            childrenFeatures.add(DataPackage.Literals.RUN__MEASUREMENTS);
        }
        return childrenFeatures;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        // Check the type of the specified child object and return the proper feature to use for
        // adding (see {@link AddCommand}) it as a child.

        return super.getChildFeature(object, child);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean hasChildren(Object object) {
        return hasChildren(object, true);
    }

    /**
     * This returns Run.gif.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object getImage(Object object) {
        return overlayImage(object, getResourceLocator().getImage("full/obj16/Run"));
    }

    /**
     * This returns the label text for the adapted class. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated NOT
     */
    @Override
    public String getText(Object object) {
        Run run = (Run) object;
        String label = run.getName();
        label += " " + DateFormat.getDateTimeInstance(DateFormat.LONG, DateFormat.LONG).format(run.getFinished());
        return label;
    }

    /**
     * This handles model notifications by calling {@link #updateChildren} to update any cached
     * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void notifyChanged(Notification notification) {
        updateChildren(notification);

        switch (notification.getFeatureID(Run.class)) {
            case DataPackage.RUN__STARTED:
            case DataPackage.RUN__FINISHED:
            case DataPackage.RUN__NAME:
                fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            case DataPackage.RUN__PARAMETER_SETS:
            case DataPackage.RUN__MEASUREMENTS:
                fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
        }
        super.notifyChanged(notification);
    }

    /**
     * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
     * that can be created under this object.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);

        newChildDescriptors.add
        (createChildParameter
         (DataPackage.Literals.RUN__PARAMETER_SETS,
          DataFactory.eINSTANCE.createParameterSet()));

        newChildDescriptors.add
        (createChildParameter
         (DataPackage.Literals.RUN__MEASUREMENTS,
          DataFactory.eINSTANCE.createMeasurement()));
    }

    /**
     * Return the resource locator for this item provider's resources.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ResourceLocator getResourceLocator() {
        return ADataEditPlugin.INSTANCE;
    }

}
