/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SNeighborhoodType implements Enumerator
{
    EUCLIDIAN(10, "Euclidian", "EUCLIDIAN"),
    MOORE(20, "Moore", "MOORE"),
    VON_NEUMANN(30, "VonNeumann", "VON_NEUMANN");

    public static final int EUCLIDIAN_VALUE = 10;
    public static final int MOORE_VALUE = 20;
    public static final int VON_NEUMANN_VALUE = 30;
    private static final SNeighborhoodType[] VALUES_ARRAY;
    public static final List<SNeighborhoodType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SNeighborhoodType[]{EUCLIDIAN, MOORE, VON_NEUMANN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SNeighborhoodType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SNeighborhoodType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SNeighborhoodType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SNeighborhoodType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SNeighborhoodType get(int value) {
        switch (value) {
            case 10: {
                return EUCLIDIAN;
            }
            case 20: {
                return MOORE;
            }
            case 30: {
                return VON_NEUMANN;
            }
        }
        return null;
    }

    private SNeighborhoodType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

