/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.ascape.util.HasName;

public class VectorSelection
extends Observable
implements Observer,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Vector vector;
    private List selectedElementsList = new LinkedList();
    private int selectedCount = 0;

    public VectorSelection() {
    }

    public VectorSelection(Vector vector) {
        this.setVector(vector);
    }

    public synchronized void setVector(Vector vector) {
        this.vector = vector;
        this.update();
    }

    public Vector getVector() {
        return this.vector;
    }

    public Object[] getSelection() {
        return this.selectedElementsList.toArray();
    }

    public void addElement(Object object, boolean select) {
        if (!this.vector.contains(object)) {
            this.vector.addElement(object);
            this.update();
        }
        this.setSelected(object, select);
    }

    public void removeElement(Object object) {
        if (this.vector.contains(object)) {
            this.vector.removeElement(object);
            this.update();
        }
    }

    public void addElement(Object object) {
        this.addElement(object, true);
    }

    public boolean isSelected(Object elem) {
        return this.selectedElementsList.contains(elem);
    }

    public boolean isSelected(int index) {
        return this.selectedElementsList.contains(this.vector.get(index));
    }

    public synchronized void selectAll() {
        this.selectedCount = this.vector.size();
        this.selectedElementsList.clear();
        this.selectedElementsList.addAll(this.vector);
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void clearSelection() {
        this.selectedElementsList.clear();
        this.selectedCount = 0;
    }

    public synchronized void clear() {
        this.vector.removeAllElements();
        this.clearSelection();
    }

    public synchronized void select(String name) {
        this.setSelected(name, true);
    }

    public synchronized void unselect(String name) {
        this.setSelected(name, false);
    }

    public synchronized void setSelected(int index, boolean select) {
        Object selectedElem = this.vector.get(index);
        if (select && !this.selectedElementsList.contains(selectedElem)) {
            int previousIndex = this.vector.indexOf(selectedElem) - 1;
            while (previousIndex >= 0) {
                Object previousElem = this.vector.get(previousIndex);
                if (this.selectedElementsList.contains(previousElem)) {
                    previousIndex = this.selectedElementsList.indexOf(previousElem);
                    break;
                }
                --previousIndex;
            }
            ++this.selectedCount;
            this.selectedElementsList.add(Math.min(this.selectedElementsList.size(), previousIndex + 1), selectedElem);
        } else if (!select && this.selectedElementsList.contains(selectedElem)) {
            --this.selectedCount;
            this.selectedElementsList.remove(selectedElem);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void setSelected(String name, boolean select) {
        Enumeration e = this.vector.elements();
        int index = 0;
        while (e.hasMoreElements()) {
            String candidateName = ((HasName)e.nextElement()).getName();
            if (candidateName.equalsIgnoreCase(name) || candidateName.replaceAll(" ", "").equalsIgnoreCase(name)) {
                this.setSelected(index, select);
                this.setChanged();
                this.notifyObservers();
                return;
            }
            ++index;
        }
        throw new RuntimeException("Tried to select an item in VectorSelection that does not exit: " + name);
    }

    public synchronized void setSelected(Object elem, boolean select) {
        int index = this.vector.indexOf(elem);
        if (index == -1) {
            throw new RuntimeException("Tried to select an item in VectorSelection that does not exit: " + elem);
        }
        this.setSelected(index, select);
        this.setChanged();
        this.notifyObservers();
    }

    public int getSelectionSize() {
        return this.selectedCount;
    }

    public int getIndexInVector(int index) {
        try {
            Object elem = this.selectedElementsList.get(index);
            return this.vector.indexOf(elem);
        }
        catch (NullPointerException nullPointerException) {
            throw new RuntimeException("Object does not exist in vector");
        }
    }

    public int getSelectedIndex(Object object) {
        return this.selectedElementsList.indexOf(object);
    }

    public Object getSelectedElement(int index) {
        return this.vector.elementAt(this.getIndexInVector(index));
    }

    public void update(Observable observed, Object arg) {
        this.update();
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void update() {
        LinkedList newSelectedElementsList = new LinkedList();
        Enumeration e = this.vector.elements();
        while (e.hasMoreElements()) {
            Object elem = e.nextElement();
            if (!this.selectedElementsList.contains(elem)) continue;
            newSelectedElementsList.add(elem);
        }
        this.selectedElementsList.clear();
        this.selectedElementsList.addAll(newSelectedElementsList);
    }

    public Object clone() {
        try {
            VectorSelection clone = (VectorSelection)super.clone();
            clone.vector = (Vector)this.vector.clone();
            clone.selectedElementsList = (List)((LinkedList)this.selectedElementsList).clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized void moveToFront(Object elem) {
        if (!this.vector.contains(elem)) {
            throw new RuntimeException("Tried to move an element that's not in the vector: " + elem);
        }
        this.vector.remove(elem);
        this.vector.add(0, elem);
        this.update();
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void moveToBack(Object elem) {
        if (!this.vector.contains(elem)) {
            throw new RuntimeException("Tried to move an element that's not in the vector: " + elem);
        }
        this.vector.remove(elem);
        this.vector.add(this.vector.size(), elem);
        this.update();
        this.setChanged();
        this.notifyObservers();
    }

    public String toString() {
        String desc = "";
        Enumeration e = this.vector.elements();
        while (e.hasMoreElements()) {
            Object elem = e.nextElement();
            desc = String.valueOf(desc) + elem.toString();
            desc = this.selectedElementsList.contains(elem) ? String.valueOf(desc) + " [Selected]" : String.valueOf(desc) + " [Not Selected]";
            desc = String.valueOf(desc) + "\n";
        }
        if (desc.equals("")) {
            desc = "[Empty]";
        }
        return desc;
    }
}

