/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.ascape.model.space.CollectionSpace;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Geometry;
import org.ascape.model.space.Location;
import org.ascape.util.RandomIterator;
import org.ascape.util.ResetableIterator;

public class Singleton
extends CollectionSpace {
    private static final long serialVersionUID = 1L;

    public Singleton() {
        this.geometry = new Geometry(1, true);
        this.collection.add(this);
        this.collection = Collections.unmodifiableList((List)this.collection);
    }

    public int getSize() {
        return 1;
    }

    public void construct() {
    }

    public void populate() {
    }

    public Iterator iterator() {
        return new LocationRandomIterator();
    }

    public ResetableIterator safeIterator(int start, int limit) {
        return new LocationRandomIterator();
    }

    public ResetableIterator safeIterator() {
        return new LocationRandomIterator();
    }

    public RandomIterator safeRandomIterator() {
        return new LocationRandomIterator();
    }

    public Location[] getLocations() {
        Location[] agents = new Location[]{(Location)((Object)this.getContext())};
        return agents;
    }

    public void moveToward(Location origin, Coordinate target, double distance) {
        if (!origin.equals(target)) {
            throw new RuntimeException("Tried to move toward a different coordinate within an agent space!");
        }
    }

    public void moveAway(Location origin, Coordinate target, double distance) {
        if (!origin.equals(target)) {
            throw new RuntimeException("Tried to move away from a different coordinate within an agent space!");
        }
    }

    public double calculateDistance(Coordinate origin, Coordinate target) {
        if (this.contains(origin) && origin == target) {
            return 0.0;
        }
        throw new RuntimeException("Tried to calcualte distance for non-space members.");
    }

    public String toString() {
        if (this.getContext().getName() != null) {
            return this.getContext().getName();
        }
        return "A Singleton";
    }

    public Location findRandom() {
        return (Location)((Object)this.getContext());
    }

    public Coordinate findRandomCoordinate() {
        return ((Location)((Object)this.getContext())).getCoordinate();
    }

    public void setExtent(Coordinate extent) {
        throw new RuntimeException("Tried to set the extent of a Singleton, which can have one and nly one member.");
    }

    public final boolean isMutable() {
        return false;
    }

    private class LocationRandomIterator
    implements RandomIterator,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int i;

        private LocationRandomIterator() {
        }

        public void first() {
            this.i = 0;
        }

        public boolean hasNext() {
            return this.i != 1;
        }

        public Object next() {
            if (this.i != 1) {
                ++this.i;
                return Singleton.this.getContext();
            }
            throw new RuntimeException("No objects available in iterator.");
        }

        public void randomize() {
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove an object from a immutable space.");
        }
    }
}

