/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.shapes;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.RenderFragment;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.graphics3d.DisplayListManager;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.shapes.PositionableShape;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CylinderShape
extends PositionableShape {
    private static final Map<CylinderConfigKey, CylinderConfig> CONFIG_CACHE = new HashMap<CylinderConfigKey, CylinderConfig>();
    private static final float[] TMP_F2 = new float[2];
    private int m_alpha = 255;
    private CylinderConfig m_config;
    private boolean m_fill = true;
    private Color m_fillColor = Display.getCurrent().getSystemColor(1);
    private CylinderKey m_fillKey;
    private boolean m_outline = true;
    private Color m_outlineColor = Display.getCurrent().getSystemColor(2);
    private CylinderKey m_outlineKey;
    private boolean m_superimposed;

    public static CylinderShape createCone(IPosition3D i_position3D, int i_segments, boolean i_superimposed) {
        return new CylinderShape(i_position3D, i_segments, 0.0f, i_superimposed);
    }

    public static CylinderShape createCylinder(IPosition3D i_position3D, int i_segments, boolean i_superimposed) {
        return new CylinderShape(i_position3D, i_segments, 1.0f, i_superimposed);
    }

    public CylinderShape(IPosition3D i_position3D, int i_segments, float i_radiusProportions) {
        this(i_position3D, i_segments, i_radiusProportions, false);
    }

    public CylinderShape(IPosition3D i_position3D, int i_segments, float i_radiusProportions, boolean i_superimposed) {
        super(i_position3D);
        this.m_superimposed = i_superimposed;
        if (i_segments < 3) {
            throw new IllegalArgumentException("cylinders must have at least 3 segments");
        }
        if (i_radiusProportions < 0.0f || i_radiusProportions > 1.0f) {
            throw new IllegalArgumentException("radius proportions must be between 0 and 1, inclusive");
        }
        CylinderConfigKey key = new CylinderConfigKey(i_segments, i_radiusProportions);
        this.m_config = CONFIG_CACHE.get(key);
        if (this.m_config == null) {
            IVector3f[] bottom;
            IVector3f[] top = new IVector3f[i_segments];
            double c = 0.0;
            double a = Math.PI * 2 / (double)i_segments;
            int i = 0;
            while (i < i_segments) {
                float x = (float)Math.cos(c) / 2.0f + 0.5f;
                float y = (float)Math.sin(c) / 2.0f + 0.5f;
                top[i] = new Vector3fImpl(x, y, 1.0f);
                c += a;
                ++i;
            }
            if (i_radiusProportions == 0.0f) {
                bottom = new IVector3f[]{new Vector3fImpl(0.5f, 0.5f, 0.0f)};
            } else {
                bottom = new IVector3f[i_segments];
                int i2 = 0;
                while (i2 < top.length) {
                    Vector3fImpl v = new Vector3fImpl(top[i2]);
                    if (i_radiusProportions != 1.0f) {
                        v.translate(-0.5f, -0.5f, -1.0f);
                        v.scale(i_radiusProportions);
                        v.translate(0.5f, 0.5f, 0.0f);
                    } else {
                        v.translate(0.0f, 0.0f, -1.0f);
                    }
                    bottom[i2] = v;
                    ++i2;
                }
            }
            this.m_config = new CylinderConfig(i_radiusProportions, top, bottom);
            CONFIG_CACHE.put(key, this.m_config);
        }
        this.m_fillKey = new CylinderKey(i_segments, i_radiusProportions, false);
        this.m_outlineKey = new CylinderKey(i_segments, i_radiusProportions, true);
    }

    private float doGetConeDistance(Vector3f rayOrigin, IVector3f rayDirection, float i_minZ, float i_height) {
        float sa2 = this.m_config.getSinApex2();
        float ca2 = this.m_config.getCosApex2();
        float xo = rayOrigin.getX();
        float yo = rayOrigin.getY();
        float zo = rayOrigin.getZ();
        float xd = rayDirection.getX();
        float yd = rayDirection.getY();
        float zd = rayDirection.getZ();
        float xo2 = xo * xo;
        float yo2 = yo * yo;
        float zo2 = zo * zo;
        float xd2 = xd * xd;
        float yd2 = yd * yd;
        float zd2 = zd * zd;
        float A = ca2 * (xd2 + yd2) - sa2 * zd2;
        float B = 2.0f * (ca2 * (xo * xd + yo * yd) - sa2 * zo * zd);
        float C = ca2 * (xo2 + yo2) - sa2 * zo2;
        Math3D.solveQuadraticEquation((float)A, (float)B, (float)C, (float[])TMP_F2);
        float d0 = TMP_F2[0];
        float d1 = TMP_F2[1];
        float zi0 = Float.isNaN(d0) ? Float.NaN : zo + zd * d0;
        float zi1 = Float.isNaN(d1) ? Float.NaN : zo + zd * d1;
        boolean v0 = Math3D.in((float)i_minZ, (float)i_height, (float)zi0);
        boolean v1 = Math3D.in((float)i_minZ, (float)i_height, (float)zi1);
        if (!v0 && !v1) {
            return Float.NaN;
        }
        if (v0 && v1) {
            return Math3D.minDistance((float)d0, (float)d1);
        }
        if (v0) {
            return d0;
        }
        return d1;
    }

    @Override
    protected float doGetDistance(IVector3f i_rayOrigin, IVector3f i_rayDirection, Map<Object, Object> i_context) {
        float radiusProportions = this.m_config.getRadiusProportions();
        if (radiusProportions == 1.0f) {
            return this.getCylinderDistance(i_rayOrigin, i_rayDirection);
        }
        if (radiusProportions == 0.0f) {
            return this.getConeDistance(i_rayOrigin, i_rayDirection);
        }
        return this.getTruncatedConeDistance(i_rayOrigin, i_rayDirection);
    }

    @Override
    protected void doRender(RenderContext i_renderContext) {
        Graphics3D g3d = i_renderContext.getGraphics3D();
        DisplayListManager displayListManager = i_renderContext.getGraphics3D().getDisplayListManager();
        this.initDisplayLists(displayListManager, g3d);
        if (this.m_fill) {
            g3d.glColor(this.m_fillColor, this.m_alpha);
            displayListManager.executeDisplayList((Object)this.m_fillKey);
        }
        if (this.m_outline) {
            g3d.glColor(this.m_outlineColor, this.m_alpha);
            displayListManager.executeDisplayList((Object)this.m_outlineKey);
        }
    }

    private float getCapDistance(IVector3f i_rayOrigin, IVector3f i_rayDirection) {
        float d;
        IVector3f[] bottom = this.m_config.getBottomVertices();
        if (bottom.length > 1 && !Float.isNaN(d = Math3D.rayIntersectsPolygon((IVector3f)i_rayOrigin, (IVector3f)i_rayDirection, (IVector3f[])bottom, (IVector3f)IVector3f.Z_AXIS_NEG, null))) {
            return d;
        }
        IVector3f[] top = this.m_config.getTopVertices();
        return Math3D.rayIntersectsPolygon((IVector3f)i_rayOrigin, (IVector3f)i_rayDirection, (IVector3f[])top, (IVector3f)IVector3f.Z_AXIS, null);
    }

    private float getConeDistance(IVector3f i_rayOrigin, IVector3f i_rayDirection) {
        float f;
        float d = this.getCapDistance(i_rayOrigin, i_rayDirection);
        if (!Float.isNaN(d)) {
            return d;
        }
        Vector3f newOrigin = Draw3DCache.getVector3f();
        try {
            Math3D.translate((IVector3f)i_rayOrigin, (float)-0.5f, (float)-0.5f, (float)0.0f, (Vector3f)newOrigin);
            f = this.doGetConeDistance(newOrigin, i_rayDirection, 0.0f, 1.0f);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{newOrigin});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{newOrigin});
        return f;
    }

    private float getCylinderDistance(IVector3f i_rayOrigin, IVector3f i_rayDirection) {
        float f;
        float d = this.getCapDistance(i_rayOrigin, i_rayDirection);
        if (!Float.isNaN(d)) {
            return d;
        }
        Vector3f newOrigin = Draw3DCache.getVector3f();
        try {
            Math3D.translate((IVector3f)i_rayOrigin, (float)-0.5f, (float)-0.5f, (float)0.0f, (Vector3f)newOrigin);
            float xo = newOrigin.getX();
            float yo = newOrigin.getY();
            float xd = i_rayDirection.getX();
            float yd = i_rayDirection.getY();
            float A = xd * xd + yd * yd;
            float B = 2.0f * (xo * xd + yo * yd);
            float C = xo * xo + yo * yo - 0.25f;
            Math3D.solveQuadraticEquation((float)A, (float)B, (float)C, (float[])TMP_F2);
            f = Math3D.minDistance((float[])TMP_F2);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{newOrigin});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{newOrigin});
        return f;
    }

    @Override
    public RenderFragment.RenderType getRenderType() {
        return RenderFragment.RenderType.getRenderType(this.m_alpha, this.m_superimposed);
    }

    private float getTruncatedConeDistance(IVector3f i_rayOrigin, IVector3f i_rayDirection) {
        float f;
        float d = this.getCapDistance(i_rayOrigin, i_rayDirection);
        if (!Float.isNaN(d)) {
            return d;
        }
        Vector3f newOrigin = Draw3DCache.getVector3f();
        try {
            float h = this.m_config.getHeight();
            Math3D.translate((IVector3f)i_rayOrigin, (float)-0.5f, (float)-0.5f, (float)(h - 1.0f), (Vector3f)newOrigin);
            f = this.doGetConeDistance(newOrigin, i_rayDirection, h - 1.0f, h);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{newOrigin});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{newOrigin});
        return f;
    }

    private void initDisplayLists(DisplayListManager i_manager, final Graphics3D i_graphics3D) {
        boolean initOutline;
        boolean initFill = this.m_fill && !i_manager.isDisplayList(new Object[]{this.m_fillKey});
        boolean bl = initOutline = this.m_outline && !i_manager.isDisplayList(new Object[]{this.m_outlineKey});
        if (!initFill && !initOutline) {
            return;
        }
        i_manager.interruptDisplayList();
        try {
            if (initFill) {
                i_manager.createDisplayList((Object)this.m_fillKey, new Runnable(){

                    public void run() {
                        CylinderShape.this.renderFill(i_graphics3D);
                    }
                });
            }
            if (initOutline) {
                i_manager.createDisplayList((Object)this.m_outlineKey, new Runnable(){

                    public void run() {
                        CylinderShape.this.renderOutline(i_graphics3D);
                    }
                });
            }
        }
        finally {
            i_manager.resumeDisplayList();
        }
    }

    private void renderFill(Graphics3D g3d) {
        g3d.glPolygonMode(1032, 6914);
        float radiusProportions = this.m_config.getRadiusProportions();
        IVector3f[] top = this.m_config.getTopVertices();
        IVector3f[] bottom = this.m_config.getBottomVertices();
        g3d.glBegin(9);
        int i = 0;
        while (i < top.length) {
            g3d.glVertex3f(top[i]);
            ++i;
        }
        g3d.glEnd();
        if (radiusProportions == 0.0f) {
            g3d.glBegin(6);
            g3d.glVertex3f(bottom[0]);
            i = top.length - 1;
            while (i >= 0) {
                g3d.glVertex3f(top[i]);
                --i;
            }
            g3d.glVertex3f(top[top.length - 1]);
            g3d.glEnd();
        } else {
            g3d.glBegin(8);
            i = bottom.length - 1;
            while (i >= 0) {
                g3d.glVertex3f(bottom[i]);
                g3d.glVertex3f(top[i]);
                --i;
            }
            g3d.glVertex3f(bottom[bottom.length - 1]);
            g3d.glVertex3f(top[top.length - 1]);
            g3d.glEnd();
            g3d.glBegin(9);
            i = bottom.length - 1;
            while (i >= 0) {
                g3d.glVertex3f(bottom[i]);
                --i;
            }
            g3d.glEnd();
        }
    }

    private void renderOutline(Graphics3D g3d) {
        g3d.glPolygonMode(1032, 6913);
        float radiusProportions = this.m_config.getRadiusProportions();
        IVector3f[] top = this.m_config.getTopVertices();
        IVector3f[] bottom = this.m_config.getBottomVertices();
        g3d.glBegin(2);
        g3d.glNormal3f(0, 0, -1);
        int i = 0;
        while (i < top.length) {
            g3d.glVertex3f(top[i]);
            ++i;
        }
        g3d.glEnd();
        if (radiusProportions == 0.0f) {
            g3d.glBegin(1);
            i = 0;
            while (i < top.length) {
                g3d.glVertex3f(top[i]);
                g3d.glVertex3f(bottom[0]);
                ++i;
            }
            g3d.glEnd();
        } else {
            g3d.glBegin(1);
            i = 0;
            while (i < top.length) {
                g3d.glVertex3f(top[i]);
                g3d.glVertex3f(bottom[i]);
                ++i;
            }
            g3d.glEnd();
            g3d.glBegin(2);
            i = 0;
            while (i < bottom.length) {
                g3d.glVertex3f(bottom[i]);
                ++i;
            }
            g3d.glEnd();
        }
    }

    public void setAlpha(int i_alpha) {
        this.m_alpha = i_alpha;
    }

    public void setFill(boolean i_fill) {
        this.m_fill = i_fill;
    }

    public void setFillColor(Color i_color) {
        this.m_fillColor = i_color;
    }

    public void setOutline(boolean i_outline) {
        this.m_outline = i_outline;
    }

    public void setOutlineColor(Color i_color) {
        this.m_outlineColor = i_color;
    }

    private static class CylinderConfig {
        private IVector3f[] m_bottomVertices;
        private float m_cosApex2;
        private float m_height;
        private float m_radiusProportions;
        private float m_sinApex2;
        private IVector3f[] m_topVertices;

        public CylinderConfig(float i_radiusProportions, IVector3f[] i_topVertices, IVector3f[] i_bottomVertices) {
            this.m_radiusProportions = i_radiusProportions;
            this.m_topVertices = i_topVertices;
            this.m_bottomVertices = i_bottomVertices;
            this.m_height = this.m_radiusProportions != 1.0f ? 1.0f / (1.0f - this.m_radiusProportions) : 1.0f;
            double a = Math.atan(0.5 / (double)this.m_height);
            double sa = Math.sin(a);
            double ca = Math.cos(a);
            this.m_sinApex2 = (float)(sa * sa);
            this.m_cosApex2 = (float)(ca * ca);
        }

        public IVector3f[] getBottomVertices() {
            return this.m_bottomVertices;
        }

        public float getCosApex2() {
            return this.m_cosApex2;
        }

        public float getHeight() {
            return this.m_height;
        }

        public float getRadiusProportions() {
            return this.m_radiusProportions;
        }

        public float getSinApex2() {
            return this.m_sinApex2;
        }

        public IVector3f[] getTopVertices() {
            return this.m_topVertices;
        }
    }

    private static class CylinderConfigKey {
        private int m_hashCode = 17;

        public CylinderConfigKey(int i_segments, float i_radiusProportions) {
            this.m_hashCode = 37 * this.m_hashCode + new Integer(i_segments).hashCode();
            this.m_hashCode = 37 * this.m_hashCode + new Float(i_radiusProportions).hashCode();
        }

        public boolean equals(Object i_obj) {
            if (i_obj == null) {
                return false;
            }
            if (!(i_obj instanceof CylinderConfigKey)) {
                return false;
            }
            return this.m_hashCode == i_obj.hashCode();
        }

        public int hashCode() {
            return this.m_hashCode;
        }
    }

    private class CylinderKey {
        private int m_hashCode = 17;

        public CylinderKey(int i_segments, float i_radiusProportions, boolean i_outline) {
            this.m_hashCode = 37 * this.m_hashCode + new Integer(i_segments).hashCode();
            this.m_hashCode = 37 * this.m_hashCode + new Float(i_radiusProportions).hashCode();
            this.m_hashCode = 37 * this.m_hashCode + new Boolean(i_outline).hashCode();
        }

        public boolean equals(Object i_obj) {
            if (i_obj == null) {
                return false;
            }
            if (this == i_obj) {
                return true;
            }
            if (!(i_obj instanceof CylinderKey)) {
                return false;
            }
            return this.m_hashCode == i_obj.hashCode();
        }

        public int hashCode() {
            return this.m_hashCode;
        }
    }
}

