/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.picking;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.ParaxialBoundingBox;
import org.eclipse.draw3d.picking.Hit;
import org.eclipse.draw3d.picking.HitImpl;
import org.eclipse.draw3d.util.Draw3DCache;

public class Query {
    private static final Logger log = Logger.getLogger(Query.class.getName());
    private boolean m_debug = false;
    private Map<Object, Object> m_context;
    private IVector3f m_rayDirection;
    private IVector3f m_rayOrigin;
    private IFigure3D m_rootFigure;
    private TreeSearch m_search;

    public Query(IVector3f i_rayOrigin, IVector3f i_rayDirection, IFigure3D i_rootFigure, TreeSearch i_search) {
        if (i_rootFigure == null) {
            throw new NullPointerException("i_rootFigure must not be null");
        }
        this.setRay(i_rayOrigin, i_rayDirection);
        this.m_rootFigure = i_rootFigure;
        this.m_search = i_search;
    }

    private boolean accept(IFigure i_figure, TreeSearch i_search) {
        if (!i_figure.isVisible()) {
            if (this.m_debug) {
                log.info(i_figure + " rejected because it is not visible");
            }
            return false;
        }
        if (i_search == null) {
            return true;
        }
        boolean accept = i_search.accept(i_figure);
        if (this.m_debug && !accept) {
            log.info(i_figure + " rejected by tree search");
        }
        return accept;
    }

    private HitImpl combineParentChildHits(IFigure i_parentFigure, HitImpl i_childHit) {
        if (!(i_parentFigure instanceof IFigure3D)) {
            if (this.m_debug) {
                if (i_childHit != null) {
                    log.info(i_childHit.getFigure3D() + " wins over parent " + i_parentFigure + " because parent is 2D");
                } else {
                    log.info("neither parent nor child was hit, parent is 2D");
                }
            }
            return i_childHit;
        }
        IFigure3D parentFigure3D = (IFigure3D)i_parentFigure;
        if (parentFigure3D.equals(this.m_rootFigure)) {
            if (this.m_debug) {
                if (i_childHit != null) {
                    log.info(i_childHit.getFigure3D() + " wins over parent " + i_parentFigure + " because parent is the root figure");
                } else {
                    log.info("neither parent nor child was hit, parent is root");
                }
            }
            return i_childHit;
        }
        IFigure searchResult = null;
        ISurface parentSurface = parentFigure3D.getSurface();
        if (parentSurface != null) {
            Point sLocation = Draw3DCache.getPoint();
            try {
                parentSurface.getSurfaceLocation2D(this.m_rayOrigin, this.m_rayDirection, sLocation);
                searchResult = parentSurface.findFigureAt(sLocation.x, sLocation.y, this.m_search);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnPoint(sLocation);
                throw throwable;
            }
            Draw3DCache.returnPoint(sLocation);
        }
        if (this.m_debug && searchResult != null) {
            log.info("found 2D search result " + searchResult + " on parent surface " + parentSurface);
        }
        HitImpl hit = i_childHit;
        if (this.accept(parentFigure3D, this.m_search) || searchResult != null) {
            float realDistance = parentFigure3D.getDistance(this.m_rayOrigin, this.m_rayDirection, this.m_context);
            if (!Float.isNaN(realDistance) && (hit == null || realDistance < hit.getDistance())) {
                if (searchResult == null) {
                    searchResult = parentFigure3D;
                }
                hit = new HitImpl(parentFigure3D, searchResult, realDistance, this.m_rayOrigin, this.m_rayDirection);
                if (this.m_debug) {
                    if (i_childHit == null) {
                        log.info(parentFigure3D + " wins because no child was hit");
                    } else {
                        log.info(parentFigure3D + " wins over child " + i_childHit.getFigure3D() + " because it is closer");
                    }
                }
            } else if (this.m_debug) {
                if (Float.isNaN(realDistance) && i_childHit == null) {
                    log.info("neither parent " + parentFigure3D + " nor any child was hit");
                }
                if (!Float.isNaN(realDistance) && i_childHit != null) {
                    log.info("parent " + parentFigure3D + " was hit, but child " + i_childHit.getFigure3D() + " is closer");
                }
            }
        }
        return hit;
    }

    private HitImpl combineSiblingHits(HitImpl i_hit1, HitImpl i_hit2) {
        if (i_hit1 == null) {
            return i_hit2;
        }
        if (i_hit2 == null) {
            return i_hit1;
        }
        if (i_hit1.isCloserThan(i_hit2)) {
            if (this.m_debug) {
                log.info(i_hit1.getFigure3D() + " wins over sibling " + i_hit2.getFigure3D() + " because it is closer");
            }
            return i_hit1;
        }
        if (this.m_debug) {
            log.info(i_hit2.getFigure3D() + " wins over sibling " + i_hit1.getFigure3D() + " because it is closer");
        }
        return i_hit2;
    }

    private HitImpl doExecute(IFigure i_figure, float i_boundingBoxDistance) {
        if (Float.isNaN(i_boundingBoxDistance)) {
            if (this.m_debug) {
                log.info(i_figure + " pruned because bounding box was missed");
            }
            return null;
        }
        HitImpl hit = null;
        List children = i_figure.getChildren();
        for (IFigure child : children) {
            if (this.prune(child, this.m_search)) continue;
            float childDistance = child instanceof IFigure3D ? this.getBoundingBoxDistance((IFigure3D)child) : i_boundingBoxDistance;
            hit = this.combineSiblingHits(this.doExecute(child, childDistance), hit);
        }
        return this.combineParentChildHits(i_figure, hit);
    }

    public Hit execute() {
        if (this.prune(this.m_rootFigure, this.m_search)) {
            return null;
        }
        if (this.m_debug) {
            log.info("executing query " + this);
            long start = System.currentTimeMillis();
            HitImpl hit = this.doExecute(this.m_rootFigure, this.getBoundingBoxDistance(this.m_rootFigure));
            log.info("query executed in " + (System.currentTimeMillis() - start) + "ms and returned " + hit);
            return hit;
        }
        return this.doExecute(this.m_rootFigure, this.getBoundingBoxDistance(this.m_rootFigure));
    }

    public Object get(Object i_key) {
        if (i_key == null) {
            throw new NullPointerException("i_key must not be null");
        }
        if (this.m_context == null) {
            return null;
        }
        return this.m_context.get(i_key);
    }

    private float getBoundingBoxDistance(IFigure3D i_figure) {
        ParaxialBoundingBox pBounds;
        ParaxialBoundingBox tmp;
        block3: {
            tmp = Draw3DCache.getParaxialBoundingBox();
            try {
                pBounds = i_figure.getParaxialBoundingBox(tmp);
                if (pBounds != null) break block3;
            }
            catch (Throwable throwable) {
                Draw3DCache.returnParaxialBoundingBox((ParaxialBoundingBox[])new ParaxialBoundingBox[]{tmp});
                throw throwable;
            }
            Draw3DCache.returnParaxialBoundingBox((ParaxialBoundingBox[])new ParaxialBoundingBox[]{tmp});
            return Float.MAX_VALUE;
        }
        float f = pBounds.intersectRay(this.m_rayOrigin, this.m_rayDirection);
        Draw3DCache.returnParaxialBoundingBox((ParaxialBoundingBox[])new ParaxialBoundingBox[]{tmp});
        return f;
    }

    public IVector3f getRayDirection() {
        return this.m_rayDirection;
    }

    public IVector3f getRayOrigin() {
        return this.m_rayOrigin;
    }

    public boolean isDebug() {
        return this.m_debug;
    }

    private boolean prune(IFigure i_figure, TreeSearch i_search) {
        if (!i_figure.isVisible()) {
            if (this.m_debug) {
                log.info(i_figure + " was pruned because it is not visible");
            }
            return true;
        }
        if (i_search == null) {
            return false;
        }
        boolean prune = i_search.prune(i_figure);
        if (this.m_debug && prune) {
            log.info(i_figure + " pruned by tree search");
        }
        return prune;
    }

    public void setDebug(boolean i_debug) {
        this.m_debug = i_debug;
    }

    public void setRay(IVector3f i_rayOrigin, IVector3f i_rayDirection) {
        if (i_rayOrigin == null) {
            throw new NullPointerException("i_rayOrigin must not be null");
        }
        if (i_rayDirection == null) {
            throw new NullPointerException("i_rayDirection must not be null");
        }
        this.m_rayOrigin = i_rayOrigin;
        this.m_rayDirection = i_rayDirection;
    }

    public String toString() {
        return "Query [rayDirection=" + this.m_rayDirection + ", rayOrigin=" + this.m_rayOrigin + ", rootFigure=" + this.m_rootFigure + ", search=" + this.m_search + "]";
    }
}

