/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.font;

import java.nio.FloatBuffer;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.util.Draw3DCache;
import org.lwjgl.opengl.GL11;

public class LwjglFontChar {
    private char m_char;
    private final int m_height;
    private float m_s1;
    private float m_s2;
    private float m_t1;
    private float m_t2;
    private final int m_width;

    public LwjglFontChar(char i_char, int i_width, int i_height) {
        this.m_char = i_char;
        this.m_width = i_width;
        this.m_height = i_height;
    }

    public int getWidth() {
        return this.m_width;
    }

    public void render(IMatrix4f i_transformation, float i_x, float i_y, FloatBuffer i_vertexBuffer, FloatBuffer i_coordBuffer) {
        if (i_transformation == null || IMatrix4f.IDENTITY.equals(i_transformation)) {
            i_vertexBuffer.put(i_x);
            i_vertexBuffer.put(i_y);
            i_coordBuffer.put(this.m_s1);
            i_coordBuffer.put(this.m_t1);
            i_vertexBuffer.put(i_x);
            i_vertexBuffer.put(i_y + (float)this.m_height);
            i_coordBuffer.put(this.m_s1);
            i_coordBuffer.put(this.m_t2);
            i_vertexBuffer.put(i_x + (float)this.m_width);
            i_vertexBuffer.put(i_y + (float)this.m_height);
            i_coordBuffer.put(this.m_s2);
            i_coordBuffer.put(this.m_t2);
            i_vertexBuffer.put(i_x + (float)this.m_width);
            i_vertexBuffer.put(i_y);
            i_coordBuffer.put(this.m_s2);
            i_coordBuffer.put(this.m_t1);
        } else {
            Vector3f v = Draw3DCache.getVector3f();
            try {
                v.set(i_x, i_y, 0.0f);
                Math3D.transform((IVector3f)v, (IMatrix4f)i_transformation, (Vector3f)v);
                i_vertexBuffer.put(v.getX());
                i_vertexBuffer.put(v.getY());
                i_coordBuffer.put(this.m_s1);
                i_coordBuffer.put(this.m_t1);
                v.set(i_x, i_y + (float)this.m_height, 0.0f);
                Math3D.transform((IVector3f)v, (IMatrix4f)i_transformation, (Vector3f)v);
                i_vertexBuffer.put(v.getX());
                i_vertexBuffer.put(v.getY());
                i_coordBuffer.put(this.m_s1);
                i_coordBuffer.put(this.m_t2);
                v.set(i_x + (float)this.m_width, i_y + (float)this.m_height, 0.0f);
                Math3D.transform((IVector3f)v, (IMatrix4f)i_transformation, (Vector3f)v);
                i_vertexBuffer.put(v.getX());
                i_vertexBuffer.put(v.getY());
                i_coordBuffer.put(this.m_s2);
                i_coordBuffer.put(this.m_t2);
                v.set(i_x + (float)this.m_width, i_y, 0.0f);
                Math3D.transform((IVector3f)v, (IMatrix4f)i_transformation, (Vector3f)v);
                i_vertexBuffer.put(v.getX());
                i_vertexBuffer.put(v.getY());
                i_coordBuffer.put(this.m_s2);
                i_coordBuffer.put(this.m_t1);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{v});
                throw throwable;
            }
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{v});
        }
    }

    public void render() {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)this.m_s1, (float)this.m_t1);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)this.m_s1, (float)this.m_t2);
        GL11.glVertex2f((float)0.0f, (float)this.m_height);
        GL11.glTexCoord2f((float)this.m_s2, (float)this.m_t2);
        GL11.glVertex2f((float)this.m_width, (float)this.m_height);
        GL11.glTexCoord2f((float)this.m_s2, (float)this.m_t1);
        GL11.glVertex2f((float)this.m_width, (float)0.0f);
        GL11.glEnd();
    }

    public void setTextureCoords(float i_s1, float i_t1, float i_s2, float i_t2) {
        this.m_s1 = i_s1;
        this.m_t1 = i_t1;
        this.m_s2 = i_s2;
        this.m_t2 = i_t2;
    }

    public String toString() {
        return Character.toString(this.m_char);
    }
}

