/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ascape.wrap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ascape.model.Scape;
import org.ascape.model.event.ScapeListener;
import org.eclipse.amp.axf.core.IEngine;
import org.eclipse.amp.axf.core.ILifeCycleListener;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.core.IObservationProvider;
import org.eclipse.amp.escape.ascape.wrap.ModelWrapperScapeListener;
import org.eclipse.amp.escape.ascape.wrap.ScapeWrapperModelListener;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.jface.viewers.ILabelProviderListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScapeWrapperModel
implements IModel {
    Scape scape;
    IModel model;
    EditPartFactory factory;
    EditPartFactory treeFactory;
    Collection<ILifeCycleListener> listeners = new ArrayList<ILifeCycleListener>();
    Map<ILifeCycleListener, ModelWrapperScapeListener> wrapperForListener = new HashMap<ILifeCycleListener, ModelWrapperScapeListener>();
    boolean closed;

    public ScapeWrapperModel(Scape scape) {
        this.scape = scape;
        this.model = !scape.isRoot() ? new ScapeWrapperModel(scape.getRoot()) : this;
    }

    public String getName() {
        return this.scape.getName();
    }

    public int getPeriod() {
        return this.scape.getPeriod();
    }

    public IEngine getEngine() {
        return (IEngine)this.scape.getRunner();
    }

    public Object getRoot() {
        return this.getScape();
    }

    public int getStopPeriod() {
        return this.scape.getStopPeriod();
    }

    public String getTimeDescription() {
        return this.scape.getPeriodDescription();
    }

    public void addModelListener(final ILifeCycleListener listener) {
        new Thread(){

            public void run() {
                ScapeWrapperModel.this.listeners.add(listener);
                if (!(listener instanceof ScapeWrapperModelListener)) {
                    ModelWrapperScapeListener wrapper = new ModelWrapperScapeListener(ScapeWrapperModel.this, ScapeWrapperModel.this.scape, listener);
                    ScapeWrapperModel.this.scape.addView((ScapeListener)wrapper);
                    ScapeWrapperModel.this.wrapperForListener.put(listener, wrapper);
                }
            }
        }.start();
    }

    public Collection<ILifeCycleListener> getModelListeners() {
        return this.listeners;
    }

    public void removeModelListener(final ILifeCycleListener listener) {
        new Thread(){

            public void run() {
                ScapeWrapperModel.this.listeners.remove(listener);
                if (listener instanceof ScapeWrapperModelListener) {
                    ScapeWrapperModel.this.scape.removeScapeListener(((ScapeWrapperModelListener)listener).getWrapped());
                }
                listener.observationEnd((IObservationProvider)ScapeWrapperModel.this);
            }
        }.start();
    }

    public boolean isInitialized() {
        return this.scape.isInitialized();
    }

    public Scape getScape() {
        return this.scape;
    }

    public String getText(Object element) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean isActive() {
        return this.getScape().isRunning();
    }

    public boolean isCreated() {
        return this.getScape().isRunning();
    }

    public boolean isEnded() {
        return this.closed;
    }

    public boolean isEnding() {
        return this.getScape().getRunner().isCloseRequested();
    }

    public boolean isStarted() {
        return this.getScape().isInitialized() && this.getScape().isRunning();
    }

    public boolean isStopped() {
        return !this.getScape().getRunner().isRunning() && !this.isEnded();
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }
}

