/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ascape.adapt;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.ascape.model.CellOccupant;
import org.ascape.model.HostCell;
import org.ascape.model.Scape;
import org.ascape.util.PropertyAccessor;
import org.eclipse.amp.agf.IPropertyChangeProvider;
import org.eclipse.amp.escape.ascape.wrap.ScapeWrapperModel;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class BeanPropertySource
implements IPropertySource,
IPropertySource2,
IPropertyChangeProvider {
    Object source;
    IPropertyDescriptor[] eclipseDescriptors;
    Map<Method, PropertyDescriptor> descriptorsSet;
    protected transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    static Map<Method, org.eclipse.ui.views.properties.PropertyDescriptor> descriptorLibrary = new HashMap<Method, org.eclipse.ui.views.properties.PropertyDescriptor>();
    static final org.eclipse.ui.views.properties.PropertyDescriptor dummy = new org.eclipse.ui.views.properties.PropertyDescriptor((Object)"dummy", "dummy");

    public BeanPropertySource(Object source) {
        this.source = source;
        if (this.source instanceof ScapeWrapperModel) {
            this.source = ((ScapeWrapperModel)source).getScape();
        }
        this.descriptorsSet = new HashMap<Method, PropertyDescriptor>();
        this.createDescriptors();
    }

    public Object getEditableValue() {
        return this.source;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.eclipseDescriptors == null) {
            this.createDescriptors();
        }
        return this.eclipseDescriptors;
    }

    IPropertyDescriptor createDescriptor(Method id, PropertyDescriptor beanDescr, String category) {
        Object desc = this.getDescriptor(id);
        if (desc == null) {
            Class<?> propertyType = beanDescr.getPropertyType();
            ?[] enumValues = propertyType.getEnumConstants();
            if (propertyType.isArray()) {
                desc = dummy;
            } else if (enumValues != null) {
                String[] valueNames = new String[enumValues.length];
                int i = 0;
                while (i < enumValues.length) {
                    Enum en = (Enum)enumValues[i];
                    valueNames[i] = en.toString();
                    ++i;
                }
                desc = new ComboBoxPropertyDescriptor((Object)id, PropertyAccessor.getLongName((PropertyDescriptor)beanDescr), valueNames);
                if (category == null) {
                    category = "Attributes";
                }
            } else if (propertyType.isPrimitive() || propertyType == String.class) {
                if (beanDescr.getWriteMethod() != null) {
                    desc = propertyType == Boolean.TYPE ? new ComboBoxPropertyDescriptor((Object)id, PropertyAccessor.getLongName((PropertyDescriptor)beanDescr), new String[]{"true", "false"}) : new TextPropertyDescriptor((Object)id, PropertyAccessor.getLongName((PropertyDescriptor)beanDescr));
                    if (category == null) {
                        category = "Attributes";
                    }
                    desc.setDescription("The value for " + id.getName());
                } else {
                    desc = propertyType == Boolean.TYPE ? new ComboBoxPropertyDescriptor(id, PropertyAccessor.getLongName((PropertyDescriptor)beanDescr), new String[]{"true", "false"}){

                        public CellEditor createPropertyEditor(Composite parent) {
                            return null;
                        }
                    } : new org.eclipse.ui.views.properties.PropertyDescriptor((Object)id, PropertyAccessor.getLongName((PropertyDescriptor)beanDescr));
                    if (category == null) {
                        category = "Attributes (Fixed)";
                    }
                }
            } else {
                desc = new org.eclipse.ui.views.properties.PropertyDescriptor((Object)id, PropertyAccessor.getLongName((PropertyDescriptor)beanDescr));
                if (category == null) {
                    category = "Objects";
                }
            }
            desc.setCategory(category);
            descriptorLibrary.put(id, (org.eclipse.ui.views.properties.PropertyDescriptor)desc);
        }
        return desc != dummy ? desc : null;
    }

    private org.eclipse.ui.views.properties.PropertyDescriptor getDescriptor(Method id) {
        return descriptorLibrary.get(id);
    }

    protected void createDescriptors() {
        if (this.source instanceof Scape) {
            if (this.source.getClass() != Scape.class) {
                this.createDescriptors(this.source.getClass(), Scape.class, null);
            }
            this.createDescriptors(Scape.class, null, "Model");
        } else if (this.source instanceof HostCell && this.source.getClass() != HostCell.class) {
            this.createDescriptors(this.source.getClass(), HostCell.class, null);
            this.createDescriptors(HostCell.class, null, "Model");
        } else if (this.source instanceof CellOccupant && this.source.getClass() != CellOccupant.class) {
            this.createDescriptors(this.source.getClass(), CellOccupant.class, null);
            this.createDescriptors(CellOccupant.class, null, "Model");
        } else {
            this.createDescriptors(this.source.getClass(), null, null);
        }
    }

    protected void createDescriptors(Class sourceClass, Class stopClass, String category) {
        if (this.source != null) {
            try {
                PropertyDescriptor[] beansDescriptors = Introspector.getBeanInfo(sourceClass, stopClass).getPropertyDescriptors();
                ArrayList<IPropertyDescriptor> descrs = new ArrayList<IPropertyDescriptor>();
                if (this.eclipseDescriptors != null) {
                    descrs.addAll(Arrays.asList(this.eclipseDescriptors));
                }
                int i = 0;
                while (i < beansDescriptors.length) {
                    IPropertyDescriptor descr;
                    PropertyDescriptor beanDescr = beansDescriptors[i];
                    Method id = beanDescr.getReadMethod();
                    if (id != null && (descr = this.createDescriptor(id, beanDescr, category)) != null) {
                        descrs.add(descr);
                        this.descriptorsSet.put(id, beanDescr);
                    }
                    ++i;
                }
                this.eclipseDescriptors = descrs.toArray(new IPropertyDescriptor[descrs.size()]);
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.eclipseDescriptors = new IPropertyDescriptor[0];
        }
    }

    public Object getValue(PropertyDescriptor descriptor) {
        return PropertyAccessor.getValue((Object)this.source, (PropertyDescriptor)descriptor);
    }

    public Object getPropertyValue(Object id) {
        PropertyDescriptor descriptor = this.descriptorsSet.get(id);
        ?[] enumValues = descriptor.getPropertyType().getEnumConstants();
        if (enumValues != null) {
            int i = 0;
            while (i < enumValues.length) {
                Enum en = (Enum)enumValues[i];
                if (en.toString() == this.getValue(descriptor).toString()) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        if (descriptor.getPropertyType() == Boolean.TYPE) {
            if (((Boolean)this.getValue(descriptor)).booleanValue()) {
                return 0;
            }
            return 1;
        }
        return PropertyAccessor.getAsText((Object)this.source, (PropertyDescriptor)descriptor);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void setAsObject(PropertyDescriptor descriptor, Object value) throws InvocationTargetException, IllegalArgumentException {
        Object[] args = new Object[]{value};
        try {
            descriptor.getWriteMethod().invoke(this.source, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Set as text won't work for property " + descriptor.getName() + ", access too restricted: " + e);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        try {
            Object oldValue;
            PropertyDescriptor descriptor = this.descriptorsSet.get(id);
            ?[] enumValues = descriptor.getPropertyType().getEnumConstants();
            if (enumValues != null) {
                oldValue = this.getValue(descriptor);
                this.setAsObject(descriptor, enumValues[(Integer)value]);
            } else if (descriptor.getPropertyType() == Boolean.TYPE) {
                oldValue = this.getValue(descriptor);
                if (this.getValue(descriptor) == Integer.valueOf(0)) {
                    this.setAsObject(descriptor, true);
                } else {
                    this.setAsObject(descriptor, false);
                }
            } else {
                oldValue = PropertyAccessor.getAsText((Object)this.source, (PropertyDescriptor)descriptor);
                PropertyAccessor.setAsText((Object)this.source, (String)((String)value), (PropertyDescriptor)descriptor);
            }
            this.firePropertyChange(((Method)id).toString(), oldValue, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    protected void firePropertyChange(String id, Object old, Object newValue) {
        this.listeners.firePropertyChange(id, old, newValue);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new PropertyChangeSupport(this);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    public void resetPropertyValue(Object id) {
    }
}

